/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class LimitWhileOperator<U> {
    private final Stream<U> stream;

    public Stream<U> limitWhile(final Predicate<? super U> predicate) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean nextSet = false;
            boolean stillGoing = true;

            @Override
            public boolean hasNext() {
                if (!this.stillGoing) {
                    return false;
                }
                if (this.nextSet) {
                    return this.stillGoing;
                }
                if (it.hasNext()) {
                    this.next = it.next();
                    this.nextSet = true;
                    if (!predicate.test(this.next)) {
                        this.stillGoing = false;
                    }
                } else {
                    this.stillGoing = false;
                }
                return this.stillGoing;
            }

            @Override
            public U next() {
                if (this.nextSet) {
                    this.nextSet = false;
                    return this.next;
                }
                Object local = it.next();
                if (this.stillGoing) {
                    this.stillGoing = !predicate.test(local);
                }
                return local;
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public LimitWhileOperator(Stream<U> stream) {
        this.stream = stream;
    }
}

