/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.data.collections.extensions.standard.ListXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BatchByTimeOperator<T, C extends Collection<? super T>> {
    private final Stream<T> stream;
    private final Supplier<C> factory;

    public BatchByTimeOperator(Stream<T> stream) {
        this.stream = stream;
        this.factory = () -> new ListXImpl();
    }

    public BatchByTimeOperator(Stream<T> stream2, Supplier<C> factory2) {
        this.stream = stream2;
        this.factory = factory2;
    }

    public Stream<C> batchByTime(long time, TimeUnit t) {
        final Iterator it = this.stream.iterator();
        final long toRun = t.toNanos(time);
        return StreamUtils.stream(new Iterator<C>(){
            long start = System.nanoTime();

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public C next() {
                Collection list = (Collection)BatchByTimeOperator.this.factory.get();
                while (System.nanoTime() - this.start < toRun && it.hasNext()) {
                    list.add(it.next());
                }
                if (list.size() == 0 && it.hasNext()) {
                    list.add(it.next());
                }
                this.start = System.nanoTime();
                return list;
            }
        }).filter(l -> l.size() > 0);
    }
}

