/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream;

import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.internal.stream.ReversedIterator;
import com.aol.cyclops.util.stream.Streamable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SeqUtils {
    public static <U> Stream<U> reverse(Stream<U> stream) {
        return SeqUtils.reversedStream(stream.collect(Collectors.toList()));
    }

    public static <U> Stream<U> reversedStream(List<U> list) {
        return new ReversedIterator<U>(list).stream();
    }

    public static <U> Stream<U> cycle(int times, Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).limit(times).flatMap(Function.identity());
    }

    public static final <A> CollectionX<A> toLazyCollection(Stream<A> stream) {
        return SeqUtils.toLazyCollection(stream.iterator());
    }

    public static final <A> CollectionX<A> toLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toLazyCollection(iterator, false);
    }

    public static final <A> CollectionX<A> toConcurrentLazyCollection(Stream<A> stream) {
        return SeqUtils.toConcurrentLazyCollection(stream.iterator());
    }

    public static final <A> CollectionX<A> toConcurrentLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toLazyCollection(iterator, true);
    }

    private static final <A> CollectionX<A> toLazyCollection(Iterator<A> iterator, boolean concurrent) {
        return CollectionX.fromCollection(SeqUtils.createLazyCollection(iterator, concurrent));
    }

    private static final <A> Collection<A> createLazyCollection(final Iterator<A> iterator, final boolean concurrent) {
        return new AbstractCollection<A>(){
            List<A> data = new ArrayList();
            volatile boolean complete = false;
            Object lock = new Object();
            ReentrantLock rlock = new ReentrantLock();

            @Override
            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof Collection)) {
                    return false;
                }
                Collection c = (Collection)o;
                Iterator it1 = this.iterator();
                Iterator it2 = c.iterator();
                while (it1.hasNext()) {
                    if (!it2.hasNext()) {
                        return false;
                    }
                    if (Objects.equals(it1.next(), it2.next())) continue;
                    return false;
                }
                return !it2.hasNext();
            }

            @Override
            public int hashCode() {
                Iterator it1 = this.iterator();
                ArrayList arrayList = new ArrayList();
                while (it1.hasNext()) {
                    arrayList.add(it1.next());
                }
                return Objects.hashCode(arrayList.toArray());
            }

            @Override
            public Iterator<A> iterator() {
                if (this.complete) {
                    return this.data.iterator();
                }
                return new Iterator<A>(){
                    int current = -1;

                    @Override
                    public boolean hasNext() {
                        if (concurrent) {
                            rlock.lock();
                        }
                        try {
                            if (this.current == data.size() - 1 && !complete) {
                                boolean result = iterator.hasNext();
                                complete = !result;
                                boolean bl = result;
                                return bl;
                            }
                            if (this.current + 1 < data.size()) {
                                boolean bl = true;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            if (concurrent) {
                                rlock.unlock();
                            }
                        }
                    }

                    @Override
                    public A next() {
                        if (concurrent) {
                            rlock.lock();
                        }
                        try {
                            if (this.current < data.size() && !complete) {
                                if (iterator.hasNext()) {
                                    data.add(iterator.next());
                                }
                                Object a = data.get(++this.current);
                                return a;
                            }
                            ++this.current;
                            Object a = data.get(this.current);
                            return a;
                        }
                        finally {
                            if (concurrent) {
                                rlock.unlock();
                            }
                        }
                    }
                };
            }

            @Override
            public int size() {
                if (this.complete) {
                    return this.data.size();
                }
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    it.next();
                }
                return this.data.size();
            }
        };
    }
}

