/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.internal.react.stream.StreamWrapper;
import com.aol.cyclops.types.futurestream.BlockingStreamHelper;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.util.ExceptionSoftener;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EagerStreamWrapper
implements StreamWrapper {
    private final List<CompletableFuture> list;
    private final Stream<CompletableFuture> stream;
    private final AsyncList async;
    private final Optional<Consumer<Throwable>> errorHandler;

    public EagerStreamWrapper(List<CompletableFuture> list, Optional<Consumer<Throwable>> errorHandler) {
        this.list = list;
        this.stream = null;
        this.errorHandler = errorHandler;
        this.async = null;
    }

    public EagerStreamWrapper(AsyncList async, Optional<Consumer<Throwable>> errorHandler) {
        this.list = null;
        this.stream = null;
        this.async = async;
        this.errorHandler = errorHandler;
    }

    public EagerStreamWrapper(Stream<CompletableFuture> stream, Optional<Consumer<Throwable>> errorHandler) {
        this.stream = stream;
        this.list = stream.collect(Collectors.toList());
        this.errorHandler = errorHandler;
        this.async = null;
    }

    public EagerStreamWrapper(Stream<CompletableFuture> stream, Collector c, Optional<Consumer<Throwable>> errorHandler) {
        this.stream = stream;
        this.async = null;
        this.errorHandler = errorHandler;
        this.list = (List)stream.collect(c);
    }

    public void collect() {
        if (this.list != null) {
            EagerStreamWrapper.collect(this.list.stream(), Collectors.toList(), this.errorHandler);
        } else {
            EagerStreamWrapper.collect(this.stream, Collectors.toList(), this.errorHandler);
        }
    }

    static List<CompletableFuture> collect(Stream<CompletableFuture> stream, Collector c, Optional<Consumer<Throwable>> errorHandler) {
        Function<Throwable, Object> captureFn = t -> {
            BlockingStreamHelper.captureUnwrap(t, errorHandler);
            throw ExceptionSoftener.throwSoftenedException(t);
        };
        if (errorHandler.isPresent()) {
            return (List)stream.map(cf -> cf.exceptionally(captureFn)).collect(c);
        }
        return (List)stream.filter(cf -> cf.isCompletedExceptionally()).collect(c);
    }

    public EagerStreamWrapper(CompletableFuture cf, Optional<Consumer<Throwable>> errorHandler) {
        this.async = null;
        this.list = Arrays.asList(cf);
        this.errorHandler = errorHandler;
        this.stream = null;
    }

    public EagerStreamWrapper withNewStream(Stream<CompletableFuture> stream, SimpleReact simple) {
        return new EagerStreamWrapper(new AsyncList(stream, simple.getQueueService()), this.errorHandler);
    }

    public EagerStreamWrapper stream(Function<Stream<CompletableFuture>, Stream<CompletableFuture>> action) {
        if (this.async != null) {
            return new EagerStreamWrapper(this.async.stream(action), this.errorHandler);
        }
        return new EagerStreamWrapper(action.apply(this.list.stream()), this.errorHandler);
    }

    public Stream<CompletableFuture> stream() {
        if (this.async != null) {
            return ((List)this.async.async.join()).stream();
        }
        return this.list.stream();
    }

    public List<CompletableFuture> list() {
        if (this.async != null) {
            return (List)this.async.async.join();
        }
        return this.list;
    }

    public EagerStreamWrapper withList(List<CompletableFuture> list) {
        return this.list == list ? this : new EagerStreamWrapper(list, this.stream, this.async, this.errorHandler);
    }

    public EagerStreamWrapper withStream(Stream<CompletableFuture> stream) {
        return this.stream == stream ? this : new EagerStreamWrapper(this.list, stream, this.async, this.errorHandler);
    }

    public EagerStreamWrapper withAsync(AsyncList async) {
        return this.async == async ? this : new EagerStreamWrapper(this.list, this.stream, async, this.errorHandler);
    }

    public EagerStreamWrapper withErrorHandler(Optional<Consumer<Throwable>> errorHandler) {
        return this.errorHandler == errorHandler ? this : new EagerStreamWrapper(this.list, this.stream, this.async, errorHandler);
    }

    @ConstructorProperties(value={"list", "stream", "async", "errorHandler"})
    public EagerStreamWrapper(List<CompletableFuture> list, Stream<CompletableFuture> stream, AsyncList async, Optional<Consumer<Throwable>> errorHandler) {
        this.list = list;
        this.stream = stream;
        this.async = async;
        this.errorHandler = errorHandler;
    }

    static class AsyncList {
        private final Executor service;
        private final CompletableFuture<List<CompletableFuture>> async;

        public AsyncList(Stream<CompletableFuture> stream, Executor service) {
            this.async = stream instanceof SimpleReactStream ? CompletableFuture.completedFuture(stream.collect(Collectors.toList())) : CompletableFuture.supplyAsync(() -> stream.collect(Collectors.toList()), service);
            this.service = service;
        }

        public AsyncList(CompletableFuture<Stream<CompletableFuture>> cf, Executor service) {
            this.async = cf.thenApplyAsync(st -> st.collect(Collectors.toList()), service);
            this.service = service;
        }

        public AsyncList stream(Function<Stream<CompletableFuture>, Stream<CompletableFuture>> action) {
            return new AsyncList((CompletableFuture<Stream<CompletableFuture>>)this.async.thenApply(list -> (Stream)action.apply(list.stream())), this.service);
        }
    }
}

