/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.react.async.subscription.Continueable;
import java.beans.ConstructorProperties;
import java.util.Iterator;

public class CloseableIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Continueable subscription;
    private final Queue queue;

    @Override
    public boolean hasNext() {
        if (!this.iterator.hasNext()) {
            this.close();
        }
        return this.iterator.hasNext();
    }

    public void close() {
        this.subscription.closeAll(this.queue);
    }

    @Override
    public T next() {
        T next = this.iterator.next();
        return next;
    }

    @ConstructorProperties(value={"iterator", "subscription", "queue"})
    public CloseableIterator(Iterator<T> iterator, Continueable subscription, Queue queue) {
        this.iterator = iterator;
        this.subscription = subscription;
        this.queue = queue;
    }
}

