/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.monads;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.internal.monads.AnyMSeqImpl;
import com.aol.cyclops.internal.monads.AnyMValueImpl;
import com.aol.cyclops.types.Decomposable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.anyM.AnyMValue;

public class MonadWrapper<T>
implements Monad<T>,
Decomposable {
    private final Object monad;
    private final Class orgType;

    public MonadWrapper(Object monad) {
        this.monad = monad;
        this.orgType = monad.getClass();
    }

    public static <T> Monad<T> of(Object of) {
        return new MonadWrapper<T>(of);
    }

    @Override
    public Object unwrap() {
        return this.monad;
    }

    @Override
    public <X> AnyMValue<X> anyMValue() {
        if (this.monad instanceof AnyMValue) {
            return (AnyMValue)this.monad;
        }
        return new AnyMValueImpl(this, this.orgType);
    }

    @Override
    public <X> AnyMSeq<X> anyMSeq() {
        if (this.monad instanceof AnyMSeq) {
            return (AnyMSeq)this.monad;
        }
        return new AnyMSeqImpl(this, this.orgType);
    }

    @Override
    public ReactiveSeq<T> sequence() {
        if (this.monad instanceof ReactiveSeq) {
            return (ReactiveSeq)this.monad;
        }
        return ReactiveSeq.fromStream(this.stream());
    }

    public String toString() {
        return this.monad.toString();
    }

    public MonadWrapper(Object monad, Class orgType) {
        this.monad = monad;
        this.orgType = orgType;
    }

    @Override
    public MonadWrapper<T> withMonad(Object monad) {
        return this.monad == monad ? this : new MonadWrapper<T>(monad, this.orgType);
    }
}

