/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.matcher2;

import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.internal.matcher2.Case;
import com.aol.cyclops.types.Convertable;
import com.aol.cyclops.types.Decomposable;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public class Cases<T, R>
implements Function<T, Maybe<R>> {
    private final PStack<Case<T, R>> cases;
    private final boolean sequential;

    Cases() {
        this.cases = ConsPStack.empty();
        this.sequential = true;
    }

    public PStack<Case<T, R>> get() {
        return this.cases;
    }

    public static <T, R> Cases<T, R> ofPStack(PStack<Case<T, R>> cases) {
        return new Cases<T, R>(cases, true);
    }

    public static <T, R> Cases<T, R> ofList(List<Case<T, R>> cases) {
        return new Cases<T, R>((PStack)cases.stream().map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))), true);
    }

    public static <T, R> Cases<T, R> of(Case<T, R> ... cazes) {
        return Cases.ofPStack((PStack)Stream.of(cazes).map(ConsPStack::singleton).reduce(ConsPStack.empty(), (acc, next) -> acc.plus(acc.size(), next.get(0))));
    }

    public Cases<T, R> append(int index, Case<T, R> pattern) {
        return this.withCases(this.cases.plus(index, pattern));
    }

    public int size() {
        return this.cases.size();
    }

    public <T1, X> Function<T1, X> asUnwrappedFunction() {
        return t -> this.apply(t).get();
    }

    @Override
    public Maybe<R> apply(T t) {
        return this.match(t);
    }

    public <R> Stream<R> matchFromStream(Stream<T> s) {
        Stream<Maybe> results = s.map(this::match);
        return results.filter(Maybe::isPresent).map(Convertable::get);
    }

    public <R> CompletableFuture<Stream<R>> matchFromStreamAsync(Executor executor, Stream<T> s) {
        return CompletableFuture.supplyAsync(() -> this.matchFromStream(s), executor);
    }

    public <R> Maybe<R> match(Object ... t) {
        return this.match((T)Arrays.asList(t));
    }

    public <R> CompletableFuture<Maybe<R>> matchAsync(Executor executor, Object ... t) {
        return CompletableFuture.supplyAsync(() -> this.match((T)t), executor);
    }

    public <R> Maybe<R> unapply(Decomposable t) {
        return this.match((T)t.unapply());
    }

    public <R> Maybe<R> match(T t) {
        return Maybe.fromOptional(this.stream().map(pattern -> pattern.match(t)).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    public Stream<Case<T, R>> stream() {
        return this.cases.stream();
    }

    @ConstructorProperties(value={"cases", "sequential"})
    public Cases(PStack<Case<T, R>> cases, boolean sequential) {
        this.cases = cases;
        this.sequential = sequential;
    }

    public Cases<T, R> withCases(PStack<Case<T, R>> cases) {
        return this.cases == cases ? this : new Cases<T, R>(cases, this.sequential);
    }

    private Cases<T, R> withSequential(boolean sequential) {
        return this.sequential == sequential ? this : new Cases<T, R>(this.cases, sequential);
    }
}

