/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.comprehensions.comprehenders;

import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.internal.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.types.extensability.Comprehender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListComprehender
implements Comprehender<List> {
    @Override
    public Object resolveForCrossTypeFlatMap(Comprehender comp, List apply) {
        List list = apply.stream().collect(Collectors.toCollection(MaterializedList::new));
        return list.size() > 0 ? comp.of(list) : comp.empty();
    }

    @Override
    public Class getTargetClass() {
        return List.class;
    }

    @Override
    public Object filter(List t, Predicate p) {
        return ListX.fromIterable(t).filter(p);
    }

    @Override
    public Object map(List t, Function fn) {
        return ListX.fromIterable(t).map(fn);
    }

    @Override
    public Object executeflatMap(List t, Function fn) {
        return this.flatMap(t, (T input) -> ListComprehender.unwrapOtherMonadTypesLC(this, fn.apply(input)));
    }

    @Override
    public Object flatMap(List t, Function fn) {
        return ListX.fromIterable(t).flatMap(fn);
    }

    @Override
    public boolean instanceOfT(Object apply) {
        return apply instanceof List;
    }

    @Override
    public List empty() {
        return Arrays.asList(new Object[0]);
    }

    @Override
    public List of(Object o) {
        return Arrays.asList(o);
    }

    @Override
    public List fromIterator(Iterator it) {
        ArrayList list = new ArrayList();
        for (Object next : () -> it) {
            list.add(next);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List unwrap(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        return ((Stream)o).collect(Collectors.toList());
    }

    static List unwrapOtherMonadTypesLC(Comprehender comp, Object apply) {
        if (apply instanceof Collection) {
            return ListX.fromIterable((Collection)apply);
        }
        if (apply instanceof Iterable) {
            return ListX.fromIterable((Iterable)apply);
        }
        if (apply instanceof BaseStream) {
            return ListX.fromIterable(() -> ((BaseStream)apply).iterator());
        }
        Object o = Comprehender.unwrapOtherMonadTypes(comp, apply);
        if (o instanceof Collection) {
            return ListX.fromIterable((Collection)o);
        }
        if (o instanceof Iterable) {
            return ListX.fromIterable((Iterable)o);
        }
        if (o instanceof BaseStream) {
            return ListX.fromIterable(() -> ((BaseStream)o).iterator());
        }
        return (List)o;
    }
}

