/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.persistent.PVectorXImpl;
import com.aol.cyclops.data.collections.extensions.persistent.PersistentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.PVector;
import org.pcollections.TreePVector;
import org.reactivestreams.Publisher;

public interface PVectorX<T>
extends PVector<T>,
PersistentCollectionX<T> {
    public static PVectorX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toPVectorX();
    }

    public static PVectorX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toPVectorX();
    }

    public static <U, T> PVectorX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toPVectorX();
    }

    public static <T> PVectorX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toPVectorX();
    }

    public static <T> PVectorX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toPVectorX();
    }

    public static <T> PVectorX<T> of(T ... values) {
        return new PVectorXImpl(TreePVector.from(Arrays.asList(values)));
    }

    public static <T> PVectorX<T> empty() {
        return new PVectorXImpl(TreePVector.empty());
    }

    public static <T> PVectorX<T> singleton(T value) {
        return new PVectorXImpl(TreePVector.singleton(value));
    }

    public static <T> PVectorX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toPVectorX();
    }

    public static <T> PVectorX<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof PVectorX) {
            return (PVectorX)iterable;
        }
        if (iterable instanceof PVector) {
            return new PVectorXImpl((PVector)iterable);
        }
        TreePVector res = TreePVector.empty();
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            res = res.plus(it.next());
        }
        return new PVectorXImpl(res);
    }

    public static <T> PVectorX<T> fromCollection(Collection<T> values) {
        if (values instanceof PVectorX) {
            return (PVectorX)values;
        }
        if (values instanceof PVector) {
            return new PVectorXImpl((PVector)values);
        }
        return new PVectorXImpl(TreePVector.from(values));
    }

    public static <T> PVectorX<T> fromStream(Stream<T> stream) {
        return Reducers.toPVectorX().mapReduce(stream);
    }

    @Override
    default public PVectorX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (PVectorX)PersistentCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    default public PVector<T> toPVector() {
        return this;
    }

    @Override
    default public <X> PVectorX<X> from(Collection<X> col) {
        return PVectorX.fromCollection(col);
    }

    @Override
    default public <T> Reducer<PVector<T>> monoid() {
        return Reducers.toPVector();
    }

    @Override
    default public PVectorX<T> toPVectorX() {
        return this;
    }

    @Override
    default public PVectorX<T> reverse() {
        return (PVectorX)PersistentCollectionX.super.reverse();
    }

    @Override
    default public PVectorX<T> filter(Predicate<? super T> pred) {
        return (PVectorX)PersistentCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> PVectorX<R> map(Function<? super T, ? extends R> mapper) {
        return (PVectorX)PersistentCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> PVectorX<R> unit(Collection<R> col) {
        return PVectorX.fromCollection(col);
    }

    @Override
    default public <R> PVectorX<R> unit(R value) {
        return PVectorX.singleton(value);
    }

    @Override
    default public <R> PVectorX<R> emptyUnit() {
        return PVectorX.empty();
    }

    @Override
    default public <R> PVectorX<R> unitIterator(Iterator<R> it) {
        return PVectorX.fromIterable(() -> it);
    }

    @Override
    default public <R> PVectorX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (PVectorX)PersistentCollectionX.super.flatMap((Function)mapper);
    }

    @Override
    default public PVectorX<T> limit(long num) {
        return (PVectorX)PersistentCollectionX.super.limit(num);
    }

    @Override
    default public PVectorX<T> skip(long num) {
        return (PVectorX)PersistentCollectionX.super.skip(num);
    }

    @Override
    default public PVectorX<T> takeRight(int num) {
        return (PVectorX)PersistentCollectionX.super.takeRight(num);
    }

    @Override
    default public PVectorX<T> dropRight(int num) {
        return (PVectorX)PersistentCollectionX.super.dropRight(num);
    }

    @Override
    default public PVectorX<T> takeWhile(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public PVectorX<T> dropWhile(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public PVectorX<T> takeUntil(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public PVectorX<T> dropUntil(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> PVectorX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (PVectorX)PersistentCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public PVectorX<T> slice(long from, long to) {
        return (PVectorX)PersistentCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> PVectorX<T> sorted(Function<? super T, ? extends U> function) {
        return (PVectorX)PersistentCollectionX.super.sorted((Function)function);
    }

    @Override
    public PVectorX<T> plus(T var1);

    @Override
    public PVectorX<T> plusAll(Collection<? extends T> var1);

    public PVectorX<T> with(int var1, T var2);

    public PVectorX<T> plus(int var1, T var2);

    public PVectorX<T> plusAll(int var1, Collection<? extends T> var2);

    @Override
    public PVectorX<T> minus(Object var1);

    @Override
    public PVectorX<T> minusAll(Collection<?> var1);

    public PVectorX<T> minus(int var1);

    public PVectorX<T> subList(int var1, int var2);

    @Override
    default public PVectorX<ListX<T>> grouped(int groupSize) {
        return (PVectorX)PersistentCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> PVectorX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (PVectorX)PersistentCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> PVectorX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (PVectorX)PersistentCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> PVectorX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (PVectorX)PersistentCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> PVectorX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PVectorX)PersistentCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PVectorX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PVectorX)PersistentCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PVectorX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PVectorX)PersistentCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public PVectorX<ReactiveSeq<T>> permutations() {
        return (PVectorX)PersistentCollectionX.super.permutations();
    }

    @Override
    default public PVectorX<ReactiveSeq<T>> combinations(int size) {
        return (PVectorX)PersistentCollectionX.super.combinations(size);
    }

    @Override
    default public PVectorX<ReactiveSeq<T>> combinations() {
        return (PVectorX)PersistentCollectionX.super.combinations();
    }

    @Override
    default public PVectorX<ListX<T>> sliding(int windowSize) {
        return (PVectorX)PersistentCollectionX.super.sliding(windowSize);
    }

    @Override
    default public PVectorX<ListX<T>> sliding(int windowSize, int increment) {
        return (PVectorX)PersistentCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public PVectorX<T> scanLeft(Monoid<T> monoid) {
        return (PVectorX)PersistentCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> PVectorX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (PVectorX)PersistentCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public PVectorX<T> scanRight(Monoid<T> monoid) {
        return (PVectorX)PersistentCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> PVectorX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (PVectorX)PersistentCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public PVectorX<T> plusInOrder(T e) {
        return (PVectorX)PersistentCollectionX.super.plusInOrder((Object)e);
    }

    @Override
    default public PVectorX<T> cycle(int times) {
        return (PVectorX)PersistentCollectionX.super.cycle(times);
    }

    @Override
    default public PVectorX<T> cycle(Monoid<T> m, int times) {
        return (PVectorX)PersistentCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public PVectorX<T> cycleWhile(Predicate<? super T> predicate) {
        return (PVectorX)PersistentCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public PVectorX<T> cycleUntil(Predicate<? super T> predicate) {
        return (PVectorX)PersistentCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> PVectorX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (PVectorX)PersistentCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> PVectorX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (PVectorX)PersistentCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> PVectorX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (PVectorX)PersistentCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> PVectorX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (PVectorX)PersistentCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public PVectorX<Tuple2<T, Long>> zipWithIndex() {
        return (PVectorX)PersistentCollectionX.super.zipWithIndex();
    }

    @Override
    default public PVectorX<T> distinct() {
        return (PVectorX)PersistentCollectionX.super.distinct();
    }

    @Override
    default public PVectorX<T> sorted() {
        return (PVectorX)PersistentCollectionX.super.sorted();
    }

    @Override
    default public PVectorX<T> sorted(Comparator<? super T> c) {
        return (PVectorX)PersistentCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public PVectorX<T> skipWhile(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public PVectorX<T> skipUntil(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public PVectorX<T> limitWhile(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public PVectorX<T> limitUntil(Predicate<? super T> p) {
        return (PVectorX)PersistentCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public PVectorX<T> intersperse(T value) {
        return (PVectorX)PersistentCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public PVectorX<T> shuffle() {
        return (PVectorX)PersistentCollectionX.super.shuffle();
    }

    @Override
    default public PVectorX<T> skipLast(int num) {
        return (PVectorX)PersistentCollectionX.super.skipLast(num);
    }

    @Override
    default public PVectorX<T> limitLast(int num) {
        return (PVectorX)PersistentCollectionX.super.limitLast(num);
    }

    @Override
    default public PVectorX<T> onEmpty(T value) {
        return (PVectorX)PersistentCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public PVectorX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (PVectorX)PersistentCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> PVectorX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (PVectorX)PersistentCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public PVectorX<T> shuffle(Random random) {
        return (PVectorX)PersistentCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> PVectorX<U> ofType(Class<? extends U> type) {
        return (PVectorX)PersistentCollectionX.super.ofType((Class)type);
    }

    @Override
    default public PVectorX<T> filterNot(Predicate<? super T> fn) {
        return (PVectorX)PersistentCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public PVectorX<T> notNull() {
        return (PVectorX)PersistentCollectionX.super.notNull();
    }

    @Override
    default public PVectorX<T> removeAll(Stream<? extends T> stream) {
        return (PVectorX)PersistentCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public PVectorX<T> removeAll(Iterable<? extends T> it) {
        return (PVectorX)PersistentCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public PVectorX<T> removeAll(T ... values) {
        return (PVectorX)PersistentCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public PVectorX<T> retainAll(Iterable<? extends T> it) {
        return (PVectorX)PersistentCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public PVectorX<T> retainAll(Stream<? extends T> seq) {
        return (PVectorX)PersistentCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public PVectorX<T> retainAll(T ... values) {
        return (PVectorX)PersistentCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> PVectorX<U> cast(Class<? extends U> type) {
        return (PVectorX)PersistentCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> PVectorX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (PVectorX)PersistentCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> PVectorX<C> grouped(int size, Supplier<C> supplier) {
        return (PVectorX)PersistentCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public PVectorX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (PVectorX)PersistentCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public PVectorX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (PVectorX)PersistentCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public PVectorX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (PVectorX)PersistentCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> PVectorX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PVectorX)PersistentCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> PVectorX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PVectorX)PersistentCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public PVectorX<T> removeAll(Seq<? extends T> stream) {
        return (PVectorX)PersistentCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public PVectorX<T> retainAll(Seq<? extends T> stream) {
        return (PVectorX)PersistentCollectionX.super.retainAll((Seq)stream);
    }
}

