/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.persistent.PSetXImpl;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.persistent.PersistentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.HashTreePSet;
import org.pcollections.MapPSet;
import org.pcollections.PSet;
import org.reactivestreams.Publisher;

public interface PSetX<T>
extends PSet<T>,
PersistentCollectionX<T> {
    public static PSetX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toPSetX();
    }

    public static PSetX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toPSetX();
    }

    public static <U, T> PSetX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toPSetX();
    }

    public static <T> PSetX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toPSetX();
    }

    public static <T> PSetX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toPSetX();
    }

    public static <T> PSetX<T> of(T ... values) {
        return new PSetXImpl(HashTreePSet.from(Arrays.asList(values)));
    }

    public static <T> PSetX<T> empty() {
        return new PSetXImpl(HashTreePSet.empty());
    }

    public static <T> PSetX<T> singleton(T value) {
        return new PSetXImpl(HashTreePSet.singleton(value));
    }

    public static <T> PSetX<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof PSetX) {
            return (PSetX)iterable;
        }
        if (iterable instanceof PSet) {
            return new PSetXImpl((PSet)iterable);
        }
        MapPSet res = HashTreePSet.empty();
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            res = res.plus(it.next());
        }
        return new PSetXImpl(res);
    }

    public static <T> PSetX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toPSetX();
    }

    public static <T> PSetX<T> fromCollection(Collection<T> stream) {
        if (stream instanceof PSetX) {
            return (PSetX)stream;
        }
        if (stream instanceof PSet) {
            return new PSetXImpl((PSet)stream);
        }
        return new PSetXImpl(HashTreePSet.from(stream));
    }

    public static <T> PSetX<T> fromStream(Stream<T> stream) {
        return Reducers.toPSetX().mapReduce(stream);
    }

    @Override
    default public PSetX<T> toPSetX() {
        return this;
    }

    @Override
    default public PSetX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (PSetX)PersistentCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <R> PSetX<R> unit(Collection<R> col) {
        return PSetX.fromCollection(col);
    }

    @Override
    default public <R> PSetX<R> unit(R value) {
        return PSetX.singleton(value);
    }

    @Override
    default public <R> PSetX<R> unitIterator(Iterator<R> it) {
        return PSetX.fromIterable(() -> it);
    }

    @Override
    default public <R> PSetX<R> emptyUnit() {
        return PSetX.empty();
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public PSet<T> toPSet() {
        return this;
    }

    @Override
    default public <X> PSetX<X> from(Collection<X> col) {
        return PSetX.fromCollection(col);
    }

    @Override
    default public <T> Reducer<PSet<T>> monoid() {
        return Reducers.toPSet();
    }

    @Override
    public PSetX<T> plus(T var1);

    @Override
    public PSetX<T> plusAll(Collection<? extends T> var1);

    @Override
    public PSetX<T> minus(Object var1);

    @Override
    public PSetX<T> minusAll(Collection<?> var1);

    @Override
    default public PSetX<T> reverse() {
        return (PSetX)PersistentCollectionX.super.reverse();
    }

    @Override
    default public PSetX<T> filter(Predicate<? super T> pred) {
        return (PSetX)PersistentCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> PSetX<R> map(Function<? super T, ? extends R> mapper) {
        return (PSetX)PersistentCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> PSetX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (PSetX)PersistentCollectionX.super.flatMap((Function)mapper);
    }

    @Override
    default public PSetX<T> limit(long num) {
        return (PSetX)PersistentCollectionX.super.limit(num);
    }

    @Override
    default public PSetX<T> skip(long num) {
        return (PSetX)PersistentCollectionX.super.skip(num);
    }

    @Override
    default public PSetX<T> takeRight(int num) {
        return (PSetX)PersistentCollectionX.super.takeRight(num);
    }

    @Override
    default public PSetX<T> dropRight(int num) {
        return (PSetX)PersistentCollectionX.super.dropRight(num);
    }

    @Override
    default public PSetX<T> takeWhile(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public PSetX<T> dropWhile(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public PSetX<T> takeUntil(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public PSetX<T> dropUntil(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> PSetX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (PSetX)PersistentCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public PSetX<T> slice(long from, long to) {
        return (PSetX)PersistentCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> PSetX<T> sorted(Function<? super T, ? extends U> function) {
        return (PSetX)PersistentCollectionX.super.sorted((Function)function);
    }

    @Override
    default public PSetX<ListX<T>> grouped(int groupSize) {
        return (PSetX)PersistentCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> PSetX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (PSetX)PersistentCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> PSetX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (PSetX)PersistentCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> PSetX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (PSetX)PersistentCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> PSetX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PSetX)PersistentCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PSetX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PSetX)PersistentCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> PSetX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PSetX)PersistentCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public PSetX<ReactiveSeq<T>> permutations() {
        return (PSetX)PersistentCollectionX.super.permutations();
    }

    @Override
    default public PSetX<ReactiveSeq<T>> combinations(int size) {
        return (PSetX)PersistentCollectionX.super.combinations(size);
    }

    @Override
    default public PSetX<ReactiveSeq<T>> combinations() {
        return (PSetX)PersistentCollectionX.super.combinations();
    }

    @Override
    default public PSetX<ListX<T>> sliding(int windowSize) {
        return (PSetX)PersistentCollectionX.super.sliding(windowSize);
    }

    @Override
    default public PSetX<ListX<T>> sliding(int windowSize, int increment) {
        return (PSetX)PersistentCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public PSetX<T> scanLeft(Monoid<T> monoid) {
        return (PSetX)PersistentCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> PSetX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (PSetX)PersistentCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public PSetX<T> scanRight(Monoid<T> monoid) {
        return (PSetX)PersistentCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> PSetX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (PSetX)PersistentCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public PSetX<T> plusInOrder(T e) {
        return (PSetX)PersistentCollectionX.super.plusInOrder((Object)e);
    }

    @Override
    default public PStackX<T> cycle(int times) {
        return this.stream().cycle(times).toPStackX();
    }

    @Override
    default public PStackX<T> cycle(Monoid<T> m, int times) {
        return this.stream().cycle(m, times).toPStackX();
    }

    @Override
    default public PStackX<T> cycleWhile(Predicate<? super T> predicate) {
        return this.stream().cycleWhile(predicate).toPStackX();
    }

    @Override
    default public PStackX<T> cycleUntil(Predicate<? super T> predicate) {
        return this.stream().cycleUntil(predicate).toPStackX();
    }

    @Override
    default public <U> PSetX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (PSetX)PersistentCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> PSetX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (PSetX)PersistentCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> PSetX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (PSetX)PersistentCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> PSetX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (PSetX)PersistentCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public PSetX<Tuple2<T, Long>> zipWithIndex() {
        return (PSetX)PersistentCollectionX.super.zipWithIndex();
    }

    @Override
    default public PSetX<T> distinct() {
        return (PSetX)PersistentCollectionX.super.distinct();
    }

    @Override
    default public PSetX<T> sorted() {
        return (PSetX)PersistentCollectionX.super.sorted();
    }

    @Override
    default public PSetX<T> sorted(Comparator<? super T> c) {
        return (PSetX)PersistentCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public PSetX<T> skipWhile(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public PSetX<T> skipUntil(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public PSetX<T> limitWhile(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public PSetX<T> limitUntil(Predicate<? super T> p) {
        return (PSetX)PersistentCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public PSetX<T> intersperse(T value) {
        return (PSetX)PersistentCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public PSetX<T> shuffle() {
        return (PSetX)PersistentCollectionX.super.shuffle();
    }

    @Override
    default public PSetX<T> skipLast(int num) {
        return (PSetX)PersistentCollectionX.super.skipLast(num);
    }

    @Override
    default public PSetX<T> limitLast(int num) {
        return (PSetX)PersistentCollectionX.super.limitLast(num);
    }

    @Override
    default public PSetX<T> onEmpty(T value) {
        return (PSetX)PersistentCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public PSetX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (PSetX)PersistentCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> PSetX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (PSetX)PersistentCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public PSetX<T> shuffle(Random random) {
        return (PSetX)PersistentCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> PSetX<U> ofType(Class<? extends U> type) {
        return (PSetX)PersistentCollectionX.super.ofType((Class)type);
    }

    @Override
    default public PSetX<T> filterNot(Predicate<? super T> fn) {
        return (PSetX)PersistentCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public PSetX<T> notNull() {
        return (PSetX)PersistentCollectionX.super.notNull();
    }

    @Override
    default public PSetX<T> removeAll(Stream<? extends T> stream) {
        return (PSetX)PersistentCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public PSetX<T> removeAll(Iterable<? extends T> it) {
        return (PSetX)PersistentCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public PSetX<T> removeAll(T ... values) {
        return (PSetX)PersistentCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public PSetX<T> retainAll(Iterable<? extends T> it) {
        return (PSetX)PersistentCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public PSetX<T> retainAll(Stream<? extends T> seq) {
        return (PSetX)PersistentCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public PSetX<T> retainAll(T ... values) {
        return (PSetX)PersistentCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> PSetX<U> cast(Class<? extends U> type) {
        return (PSetX)PersistentCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> PSetX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (PSetX)PersistentCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> PSetX<C> grouped(int size, Supplier<C> supplier) {
        return (PSetX)PersistentCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public PSetX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (PSetX)PersistentCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public PSetX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (PSetX)PersistentCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public PSetX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (PSetX)PersistentCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> PSetX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PSetX)PersistentCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> PSetX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PSetX)PersistentCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public PSetX<T> removeAll(Seq<? extends T> stream) {
        return (PSetX)PersistentCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public PSetX<T> retainAll(Seq<? extends T> stream) {
        return (PSetX)PersistentCollectionX.super.retainAll((Seq)stream);
    }
}

