/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.For;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionXImpl;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.types.ExtendedTraversable;
import com.aol.cyclops.types.IterableFilterable;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.IterableFunctor;
import com.aol.cyclops.types.Sequential;
import com.aol.cyclops.types.Unit;
import com.aol.cyclops.types.applicative.zipping.ZippingApplicativable;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.types.stream.HeadAndTail;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public interface CollectionX<T>
extends ExtendedTraversable<T>,
Iterable<T>,
Sequential<T>,
IterableFunctor<T>,
IterableFoldable<T>,
IterableFilterable<T>,
ZippingApplicativable<T>,
Unit<T>,
Collection<T>,
CyclopsCollectable<T> {
    public static <T> CollectionX<T> fromCollection(Collection<T> col) {
        return new CollectionXImpl<T>(col);
    }

    @Override
    public <U> CollectionX<Tuple2<T, U>> zip(Seq<? extends U> var1);

    @Override
    public <C extends Collection<? super T>> CollectionX<C> grouped(int var1, Supplier<C> var2);

    @Override
    public CollectionX<ListX<T>> groupedUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> var1);

    @Override
    public CollectionX<ListX<T>> groupedWhile(Predicate<? super T> var1);

    @Override
    public <C extends Collection<? super T>> CollectionX<C> groupedWhile(Predicate<? super T> var1, Supplier<C> var2);

    @Override
    public <C extends Collection<? super T>> CollectionX<C> groupedUntil(Predicate<? super T> var1, Supplier<C> var2);

    @Override
    public CollectionX<T> intersperse(T var1);

    @Override
    public CollectionX<T> shuffle();

    @Override
    public CollectionX<T> shuffle(Random var1);

    @Override
    public <S, U> CollectionX<Tuple3<T, S, U>> zip3(Stream<? extends S> var1, Stream<? extends U> var2);

    @Override
    public <T2, T3, T4> CollectionX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> var1, Stream<? extends T3> var2, Stream<? extends T4> var3);

    @Override
    public CollectionX<T> limitWhile(Predicate<? super T> var1);

    @Override
    public CollectionX<T> limitUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<T> limitLast(int var1);

    @Override
    public CollectionX<T> skipWhile(Predicate<? super T> var1);

    @Override
    public CollectionX<T> skipUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<T> skipLast(int var1);

    @Override
    public CollectionX<T> cycle(int var1);

    @Override
    public CollectionX<T> cycle(Monoid<T> var1, int var2);

    @Override
    public CollectionX<T> cycleWhile(Predicate<? super T> var1);

    @Override
    public CollectionX<T> cycleUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<T> onEmpty(T var1);

    @Override
    public CollectionX<T> onEmptyGet(Supplier<? extends T> var1);

    @Override
    public <X extends Throwable> CollectionX<T> onEmptyThrow(Supplier<? extends X> var1);

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public CyclopsCollectable<T> collectable() {
        return this.stream();
    }

    default public Optional<T> getAtIndex(int index) {
        return this.stream().get(index);
    }

    @Override
    default public HeadAndTail<T> headAndTail() {
        return new HeadAndTail(this.iterator());
    }

    default public T head() {
        return this.iterator().next();
    }

    public <T1> CollectionX<T1> from(Collection<T1> var1);

    @Override
    public CollectionX<T> reverse();

    @Override
    default public T single() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return result;
            }
        }
        throw new UnsupportedOperationException("single only works for Streams with a single value");
    }

    @Override
    default public T single(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).single();
    }

    @Override
    default public Optional<T> singleOptional() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return Optional.of(result);
            }
        }
        return Optional.empty();
    }

    @Override
    default public Optional<T> findFirst() {
        return this.stream().findFirst();
    }

    @Override
    default public Optional<T> findAny() {
        return this.stream().findAny();
    }

    @Override
    default public <K> MapX<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.stream().groupBy(classifier);
    }

    @Override
    public CollectionX<T> filter(Predicate<? super T> var1);

    @Override
    public <R> CollectionX<R> map(Function<? super T, ? extends R> var1);

    public <R> CollectionX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> var1);

    @Override
    public CollectionX<T> limit(long var1);

    @Override
    public CollectionX<T> skip(long var1);

    @Override
    public CollectionX<T> takeWhile(Predicate<? super T> var1);

    @Override
    public CollectionX<T> dropWhile(Predicate<? super T> var1);

    @Override
    public CollectionX<T> takeUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<T> dropUntil(Predicate<? super T> var1);

    @Override
    public CollectionX<T> dropRight(int var1);

    @Override
    public CollectionX<T> takeRight(int var1);

    @Override
    default public CollectionX<T> peek(Consumer<? super T> c) {
        return (CollectionX)ZippingApplicativable.super.peek(c);
    }

    @Override
    public CollectionX<ListX<T>> grouped(int var1);

    @Override
    public <K, A, D> CollectionX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> var1, Collector<? super T, A, D> var2);

    @Override
    public <K> CollectionX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> var1);

    @Override
    public CollectionX<T> combine(BiPredicate<? super T, ? super T> var1, BinaryOperator<T> var2);

    @Override
    public <U> CollectionX<Tuple2<T, U>> zip(Iterable<? extends U> var1);

    @Override
    public <U, R> CollectionX<R> zip(Iterable<? extends U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    @Override
    public <U, R> CollectionX<R> zip(Seq<? extends U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    @Override
    public <U, R> CollectionX<R> zip(Stream<? extends U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    @Override
    public <U> CollectionX<Tuple2<T, U>> zip(Stream<? extends U> var1);

    @Override
    public CollectionX<Tuple2<T, Long>> zipWithIndex();

    @Override
    public CollectionX<ListX<T>> sliding(int var1);

    @Override
    public CollectionX<ListX<T>> sliding(int var1, int var2);

    @Override
    public CollectionX<T> scanLeft(Monoid<T> var1);

    @Override
    public <U> CollectionX<U> scanLeft(U var1, BiFunction<? super U, ? super T, ? extends U> var2);

    @Override
    public CollectionX<T> scanRight(Monoid<T> var1);

    @Override
    public <U> CollectionX<U> scanRight(U var1, BiFunction<? super T, ? super U, ? extends U> var2);

    @Override
    public CollectionX<T> distinct();

    @Override
    public CollectionX<T> sorted();

    @Override
    public CollectionX<T> removeAll(Stream<? extends T> var1);

    @Override
    public CollectionX<T> removeAll(Iterable<? extends T> var1);

    @Override
    public CollectionX<T> removeAll(Seq<? extends T> var1);

    @Override
    public CollectionX<T> removeAll(T ... var1);

    @Override
    public CollectionX<T> retainAll(Iterable<? extends T> var1);

    @Override
    public CollectionX<T> retainAll(Seq<? extends T> var1);

    @Override
    public CollectionX<T> retainAll(Stream<? extends T> var1);

    @Override
    public CollectionX<T> retainAll(T ... var1);

    @Override
    public CollectionX<T> filterNot(Predicate<? super T> var1);

    @Override
    public CollectionX<T> notNull();

    @Override
    public <R> CollectionX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> var1);

    default public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, Iterable<R1>> stream1, Function<? super T, Function<? super R1, Iterable<R2>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (ReactiveSeq)For.iterable(this.stream()).iterable(stream1).iterable(stream2).yield(yieldingFunction).unwrap();
    }

    default public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, Iterable<R1>> stream1, Function<? super T, Function<? super R1, Iterable<R2>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (ReactiveSeq)For.iterable(this.stream()).iterable(stream1).iterable(stream2).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    default public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, Iterable<R1>> stream1, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (ReactiveSeq)For.iterable(this.stream()).iterable(stream1).yield(yieldingFunction).unwrap();
    }

    default public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, Iterable<R1>> stream1, Function<? super T, Function<? super R1, Boolean>> filterFunction, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (ReactiveSeq)For.iterable(this.stream()).iterable(stream1).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    @Override
    public CollectionX<T> slice(long var1, long var3);

    @Override
    public <U extends Comparable<? super U>> CollectionX<T> sorted(Function<? super T, ? extends U> var1);

    @Override
    public CollectionX<T> sorted(Comparator<? super T> var1);

    @Override
    public CollectionX<ReactiveSeq<T>> permutations();

    @Override
    public CollectionX<ReactiveSeq<T>> combinations(int var1);

    @Override
    public CollectionX<ReactiveSeq<T>> combinations();

    @Override
    default public <U> CollectionX<U> cast(Class<? extends U> type) {
        return (CollectionX)ZippingApplicativable.super.cast(type);
    }

    @Override
    default public <R> CollectionX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (CollectionX)ZippingApplicativable.super.patternMatch(case1, otherwise);
    }
}

