/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data;

import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.Unit;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazyImmutable<T>
implements Supplier<T>,
Consumer<T>,
Matchable.ValueAndOptionalMatcher<T>,
Functor<T>,
ApplicativeFunctor<T> {
    private static final Object UNSET = new Object();
    private AtomicReference value = new AtomicReference<Object>(UNSET);
    private final AtomicBoolean set = new AtomicBoolean(false);

    @Override
    public T get() {
        return (T)this.value.get();
    }

    public static <T> LazyImmutable<T> unbound() {
        return new LazyImmutable<T>();
    }

    public static <T> LazyImmutable<T> of(T value) {
        LazyImmutable<T> v = new LazyImmutable<T>();
        v.setOnce(value);
        return v;
    }

    public static <T> LazyImmutable<T> def() {
        return new LazyImmutable<T>();
    }

    @Override
    public <R> LazyImmutable<R> map(Function<? super T, ? extends R> fn) {
        T val2 = this.get();
        if (val2 == UNSET) {
            return this;
        }
        return LazyImmutable.of(fn.apply(val2));
    }

    @Override
    public <R> LazyImmutable<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (LazyImmutable)ApplicativeFunctor.super.patternMatch(case1, otherwise);
    }

    public <R> LazyImmutable<? extends R> flatMap(Function<? super T, ? extends LazyImmutable<? extends R>> fn) {
        T val2 = this.get();
        if (val2 == UNSET) {
            return this;
        }
        return fn.apply(val2);
    }

    public LazyImmutable<T> setOnce(T val2) {
        this.value.compareAndSet(UNSET, val2);
        this.set.set(true);
        return this;
    }

    private T setOnceFromSupplier(Supplier<T> lazy) {
        this.value.compareAndSet(UNSET, lazy.get());
        return (T)this.value.get();
    }

    public T computeIfAbsent(Supplier<T> lazy) {
        T val2 = this.get();
        if (val2 == UNSET) {
            return this.setOnceFromSupplier(lazy);
        }
        return val2;
    }

    public boolean isSet() {
        return this.set.get();
    }

    @Override
    public void accept(T t) {
        this.setOnce(t);
    }

    @Override
    public ReactiveSeq<T> stream() {
        return ReactiveSeq.generate(this).limit(1L);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <T> Unit<T> unit(T unit) {
        return LazyImmutable.of(unit);
    }

    @Override
    public LazyImmutable<T> toLazyImmutable() {
        return this;
    }

    @Override
    public <U> LazyImmutable<U> cast(Class<? extends U> type) {
        return (LazyImmutable)ApplicativeFunctor.super.cast(type);
    }

    @Override
    public LazyImmutable<T> peek(Consumer<? super T> c) {
        return (LazyImmutable)ApplicativeFunctor.super.peek(c);
    }

    @Override
    public <R> LazyImmutable<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (LazyImmutable)ApplicativeFunctor.super.trampoline(mapper);
    }

    public int hashCode() {
        return this.value.get().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LazyImmutable)) {
            return false;
        }
        return Objects.equals(this.value.get(), ((LazyImmutable)obj).value.get());
    }

    public String toString() {
        return "LazyImmutable(value=" + this.value + ", set=" + this.set + ")";
    }
}

