/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.monads.transformers.TryT;
import com.aol.cyclops.control.monads.transformers.values.MaybeTValue;
import com.aol.cyclops.control.monads.transformers.values.TransformerValue;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class TryTValue<T, X extends Throwable>
implements TryT<T, X>,
TransformerValue<T>,
MonadicValue<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
ApplicativeFunctor<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private final AnyMValue<Try<T, X>> run;

    private TryTValue(AnyMValue<Try<T, X>> run) {
        this.run = run;
    }

    public Try<T, X> value() {
        return (Try)this.run.get();
    }

    @Override
    public boolean isValuePresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMValue<Try<T, X>> unwrap() {
        return this.run;
    }

    @Override
    public TryTValue<T, X> peek(Consumer<? super T> peek) {
        return TryTValue.of(this.run.peek((T opt) -> opt.map((T a) -> {
            peek.accept(a);
            return a;
        })));
    }

    @Override
    public MaybeTValue<T> filter(Predicate<? super T> test) {
        return MaybeTValue.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> TryTValue<B, X> map(Function<? super T, ? extends B> f) {
        return new TryTValue<T, X>(this.run.map((T o) -> o.map(f)));
    }

    public <T2, R> TryTValue<R, X> ap(Value<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return new TryTValue<T, X>(this.run.map((T o) -> o.ap(app, fn)));
    }

    public <T2, R> TryTValue<R, X> zip(Iterable<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return new TryTValue<T, X>(this.run.map((T o) -> o.zip(app, fn)));
    }

    public <T2, R> TryTValue<R, X> zip(BiFunction<? super T, ? super T2, ? extends R> fn, Publisher<? extends T2> app) {
        return new TryTValue<T, X>(this.run.map((T o) -> o.zip(fn, app)));
    }

    public <B> TryTValue<B, X> flatMapT(Function<? super T, TryTValue<B, X>> f) {
        return TryTValue.of(this.run.bind((T opt) -> {
            if (opt.isSuccess()) {
                return ((TryTValue)f.apply(opt.get())).run.unwrap();
            }
            Try ret = opt;
            return this.run.unit((Object)ret).unwrap();
        }));
    }

    @Override
    public <B> TryTValue<B, X> flatMap(Function<? super T, ? extends Try<B, X>> f) {
        return new TryTValue<T, X>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <U, R, X extends Throwable> Function<TryTValue<U, X>, TryTValue<R, X>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R, X extends Throwable> BiFunction<TryTValue<U1, X>, TryTValue<U2, X>, TryTValue<R, X>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A, X extends Throwable> TryTValue<A, X> fromAnyM(AnyMValue<A> anyM) {
        return TryTValue.of(anyM.map(Try::success));
    }

    public static <A, X extends Throwable> TryTValue<A, X> of(AnyMValue<Try<A, X>> monads) {
        return new TryTValue(monads);
    }

    public static <A, X extends Throwable> TryTValue<A, X> of(Try<A, X> monads) {
        return TryT.fromOptional(Optional.of(monads));
    }

    public static <A, X extends Throwable, V extends MonadicValue<Try<A, X>>> TryTValue<A, X> fromValue(V monadicValue) {
        return TryTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("TryTValue[%s]", this.run);
    }

    @Override
    public T get() {
        return ((Try)this.run.get()).get();
    }

    public boolean isSuccess() {
        return ((Try)this.run.orElse(Try.failure(null))).isSuccess();
    }

    public boolean isFailure() {
        return ((Try)this.run.orElse(Try.success(null))).isFailure();
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.orElseGet(() -> Try.failure(null)).stream();
    }

    @Override
    public Iterator<T> iterator() {
        return ((Try)this.run.orElse(Try.failure(null))).iterator();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        ((Try)this.run.orElse(Try.failure(null))).subscribe(s);
    }

    @Override
    public boolean test(T t) {
        return ((Try)this.run.get()).test(t);
    }

    public <R> R visit(Function<? super T, ? extends R> success, Function<? super X, ? extends R> failure, Supplier<R> none) {
        if (!this.isFailure() && !this.isSuccess()) {
            return none.get();
        }
        return ((Try)this.run.get()).visit(success, failure);
    }

    @Override
    public <R> TryTValue<R, X> unit(R value) {
        return TryTValue.of(this.run.unit((Object)Try.success(value)));
    }

    @Override
    public <R> TryTValue<R, X> empty() {
        return TryTValue.of(this.run.unit((Object)Try.failure(null)));
    }

    public static <T, X extends Throwable> TryTValue<T, X> emptyOptional() {
        return TryT.fromOptional(Optional.empty());
    }

    @Override
    public <U> TryTValue<U, X> cast(Class<? extends U> type) {
        return (TryTValue)TryT.super.cast((Class)type);
    }

    @Override
    public <R> TryTValue<R, X> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (TryTValue)TryT.super.trampoline((Function)mapper);
    }

    @Override
    public <R> TryTValue<R, X> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (TryTValue)TryT.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    public <U> MaybeTValue<U> ofType(Class<? extends U> type) {
        return (MaybeTValue)TryT.super.ofType((Class)type);
    }

    @Override
    public MaybeTValue<T> filterNot(Predicate<? super T> fn) {
        return (MaybeTValue)TryT.super.filterNot((Predicate)fn);
    }

    @Override
    public MaybeTValue<T> notNull() {
        return (MaybeTValue)TryT.super.notNull();
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TryTValue) {
            return this.run.equals(((TryTValue)o).run);
        }
        return false;
    }
}

