/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.monads.transformers.MaybeT;
import com.aol.cyclops.control.monads.transformers.values.TransformerValue;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MaybeTValue<T>
implements MaybeT<T>,
TransformerValue<T>,
MonadicValue<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
ApplicativeFunctor<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private final AnyMValue<Maybe<T>> run;

    private MaybeTValue(AnyMValue<Maybe<T>> run) {
        this.run = run;
    }

    @Override
    public Maybe<T> value() {
        return (Maybe)this.run.get();
    }

    @Override
    public boolean isValuePresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMValue<Maybe<T>> unwrap() {
        return this.run;
    }

    @Override
    public MaybeTValue<T> peek(Consumer<? super T> peek) {
        return this.map((T in) -> {
            peek.accept(in);
            return in;
        });
    }

    @Override
    public MaybeTValue<T> filter(Predicate<? super T> test) {
        return MaybeTValue.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> MaybeTValue<B> map(Function<? super T, ? extends B> f) {
        return new MaybeTValue<T>(this.run.map((T o) -> o.map(f)));
    }

    @Override
    public <T2, R> MaybeTValue<R> ap(Value<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return new MaybeTValue<T>(this.run.map((T o) -> o.ap(app, fn)));
    }

    @Override
    public <T2, R> MaybeTValue<R> zip(Iterable<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return new MaybeTValue<T>(this.run.map((T o) -> o.zip(app, fn)));
    }

    @Override
    public <T2, R> MaybeTValue<R> zip(BiFunction<? super T, ? super T2, ? extends R> fn, Publisher<? extends T2> app) {
        return new MaybeTValue<T>(this.run.map((T o) -> o.zip(fn, app)));
    }

    public <B> MaybeTValue<B> flatMapT(Function<? super T, MaybeTValue<? extends B>> f) {
        return MaybeTValue.of(this.run.bind((T opt) -> {
            if (opt.isPresent()) {
                return ((MaybeTValue)f.apply(opt.get())).run.unwrap();
            }
            return this.run.unit((Object)Maybe.none()).unwrap();
        }));
    }

    @Override
    public <B> MaybeTValue<B> flatMap(Function<? super T, ? extends MonadicValue<? extends B>> f) {
        return new MaybeTValue<T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <U, R> Function<MaybeTValue<U>, MaybeTValue<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<MaybeTValue<U1>, MaybeTValue<U2>, MaybeTValue<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A, V extends MonadicValue<Maybe<A>>> MaybeTValue<A> fromValue(V monadicValue) {
        return MaybeTValue.of(AnyM.ofValue(monadicValue));
    }

    public static <A> MaybeTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return MaybeTValue.of(anyM.map(Maybe::ofNullable));
    }

    public static <A> MaybeTValue<A> of(AnyMValue<Maybe<A>> monads) {
        return new MaybeTValue(monads);
    }

    public static <A> MaybeTValue<A> of(Maybe<A> maybe) {
        return MaybeTValue.fromValue(Maybe.just(maybe));
    }

    public String toString() {
        return String.format("MaybeTValue[%s]", this.run);
    }

    @Override
    public T get() {
        return ((Maybe)this.run.get()).get();
    }

    @Override
    public boolean isPresent() {
        return this.run.orElse(Maybe.none()).isPresent();
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.orElse(Maybe.none()).stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.run.orElse(Maybe.none()).iterator();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.run.orElse(Maybe.none()).subscribe(s);
    }

    @Override
    public boolean test(T t) {
        return ((Maybe)this.run.get()).test(t);
    }

    @Override
    public <R> MaybeTValue<R> unit(R value) {
        return MaybeTValue.of(this.run.unit((Object)Maybe.of(value)));
    }

    @Override
    public <R> MaybeTValue<R> empty() {
        return MaybeTValue.of(this.run.unit((Object)Maybe.none()));
    }

    public static <T> MaybeTValue<T> emptyOptional() {
        return MaybeT.fromOptional(Optional.empty());
    }

    @Override
    public <U> MaybeTValue<U> cast(Class<? extends U> type) {
        return (MaybeTValue)TransformerValue.super.cast((Class)type);
    }

    @Override
    public <R> MaybeTValue<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (MaybeTValue)TransformerValue.super.trampoline((Function)mapper);
    }

    @Override
    public <R> MaybeTValue<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (MaybeTValue)TransformerValue.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    public <U> MaybeTValue<U> ofType(Class<? extends U> type) {
        return (MaybeTValue)MaybeT.super.ofType((Class)type);
    }

    @Override
    public MaybeTValue<T> filterNot(Predicate<? super T> fn) {
        return (MaybeTValue)MaybeT.super.filterNot((Predicate)fn);
    }

    @Override
    public MaybeTValue<T> notNull() {
        return (MaybeTValue)MaybeT.super.notNull();
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MaybeTValue) {
            return this.run.equals(((MaybeTValue)o).run);
        }
        return false;
    }
}

