/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.internal.react.SimpleReactStreamImpl;
import com.aol.cyclops.internal.react.stream.ReactBuilder;
import com.aol.cyclops.react.RetryBuilder;
import com.aol.cyclops.react.ThreadPools;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.types.stream.reactive.SeqSubscriber;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

public class SimpleReact
implements ReactBuilder {
    private final Executor queueService;
    private final Executor executor;
    private final RetryExecutor retrier;
    private final Boolean async;

    public <U> SimpleReactStream<U> construct(Stream s) {
        return new SimpleReactStreamImpl(this, s);
    }

    public SimpleReact() {
        this(ThreadPools.getStandard());
    }

    public SimpleReact(Executor executor, RetryExecutor retrier, Boolean async) {
        this.queueService = ThreadPools.getQueueCopyExecutor();
        this.executor = Optional.ofNullable(executor).orElse(new ForkJoinPool(Runtime.getRuntime().availableProcessors()));
        this.retrier = retrier;
        this.async = Optional.ofNullable(async).orElse(true);
    }

    public SimpleReact(Executor executor) {
        this.queueService = ThreadPools.getQueueCopyExecutor();
        this.executor = executor;
        this.retrier = null;
        this.async = true;
    }

    public SimpleReact(Executor executor, RetryExecutor retrier) {
        this.queueService = ThreadPools.getQueueCopyExecutor();
        this.executor = executor;
        this.retrier = retrier;
        this.async = true;
    }

    public SimpleReact(Executor executor, RetryExecutor retrier, Executor queueCopier) {
        this.queueService = ThreadPools.getQueueCopyExecutor();
        this.executor = executor;
        this.retrier = retrier;
        this.async = true;
    }

    public SimpleReact withQueueCopyExecutor(Executor queueCopyExecutor) {
        return new SimpleReact(this.executor, this.retrier, queueCopyExecutor);
    }

    public <U> SimpleReactStream<U> fromStreamAsync(Stream<Supplier<U>> actions) {
        return new SimpleReactStreamImpl(this, actions.map(next -> CompletableFuture.supplyAsync(next, this.executor)));
    }

    public <T> SimpleReactStream<T> fromPublisher(Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher);
        SeqSubscriber sub = SeqSubscriber.subscriber();
        publisher.subscribe(sub);
        return sub.toSimpleReact(this);
    }

    public <U> SimpleReactStream<U> fromIteratorAsync(Iterator<Supplier<U>> actions) {
        return new SimpleReactStreamImpl(this, StreamSupport.stream(Spliterators.spliteratorUnknownSize(actions, 16), false).map(next -> CompletableFuture.supplyAsync(next, this.executor)));
    }

    public <U> SimpleReactStream<U> fromIterableAsync(Iterable<Supplier<U>> actions) {
        return new SimpleReactStreamImpl(this, StreamSupport.stream(Spliterators.spliteratorUnknownSize(actions.iterator(), 16), false).map(next -> CompletableFuture.supplyAsync(next, this.executor)));
    }

    @SafeVarargs
    public final <U> SimpleReactStream<U> ofAsync(Supplier<U> ... actions) {
        return this.reactI(actions);
    }

    @SafeVarargs
    private final <U> SimpleReactStream<U> reactI(Supplier<U> ... actions) {
        return new SimpleReactStreamImpl(this, Stream.of(actions).map(next -> CompletableFuture.supplyAsync(next, this.executor)));
    }

    public <U> SimpleReactStream<U> from(Stream<U> stream) {
        Stream<CompletableFuture> s = stream.map(it -> CompletableFuture.completedFuture(it));
        return this.construct(s);
    }

    public <R> SimpleReactStream<R> from(Collection<R> collection) {
        return this.from(collection.stream());
    }

    public boolean isAsync() {
        return this.async;
    }

    public static SimpleReact parallelBuilder() {
        return new SimpleReact();
    }

    public static SimpleReact parallelBuilder(int parallelism) {
        return SimpleReact.builder().executor(new ForkJoinPool(parallelism)).async(true).retrier((RetryExecutor)new RetryBuilder().parallelism(parallelism)).build();
    }

    public static SimpleReact parallelCommonBuilder() {
        return SimpleReact.builder().executor(ThreadPools.getStandard()).async(true).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getCommonFreeThreadRetry())).build();
    }

    public static SimpleReact sequentialBuilder() {
        return SimpleReact.builder().async(false).executor(new ForkJoinPool(1)).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(Executors.newScheduledThreadPool(1))).build();
    }

    public static SimpleReact sequentialCommonBuilder() {
        return SimpleReact.builder().async(false).executor(ThreadPools.getCommonFreeThread()).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getCommonFreeThreadRetry())).build();
    }

    public SimpleReactStream<Integer> range(int startInclusive, int endExclusive) {
        return this.from(IntStream.range(startInclusive, endExclusive));
    }

    public <U> SimpleReactStream<U> from(Iterator<U> iterator) {
        return this.from(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public <U> SimpleReactStream<U> fromIterable(Iterable<U> iter) {
        return this.from(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter.iterator(), 16), false));
    }

    public <U> SimpleReactStream<U> fromStream(Stream<CompletableFuture<U>> stream) {
        Stream<CompletableFuture<U>> s = stream;
        return this.construct(s);
    }

    public <U> SimpleReactStream<Integer> from(IntStream stream) {
        return this.from(stream.boxed());
    }

    public <U> SimpleReactStream<Double> from(DoubleStream stream) {
        return this.from(stream.boxed());
    }

    public <U> SimpleReactStream<Long> from(LongStream stream) {
        return this.from(stream.boxed());
    }

    public <U> SimpleReactStream<U> of(U ... array) {
        return this.from(Stream.of(array));
    }

    public <U> SimpleReactStream<U> from(CompletableFuture<U> cf) {
        return this.construct(Stream.of(cf));
    }

    public <U> SimpleReactStream<U> from(CompletableFuture<U> ... cf) {
        return this.construct(Stream.of(cf));
    }

    public SimpleReact(Executor queueService, Executor executor, RetryExecutor retrier, Boolean async) {
        this.queueService = Optional.ofNullable(queueService).orElse(ThreadPools.getQueueCopyExecutor());
        this.executor = Optional.ofNullable(executor).orElse(ThreadPools.getCurrentThreadExecutor());
        this.retrier = retrier;
        this.async = Optional.ofNullable(async).orElse(true);
    }

    public static SimpleReactBuilder builder() {
        return new SimpleReactBuilder();
    }

    public SimpleReact withQueueService(Executor queueService) {
        return this.queueService == queueService ? this : new SimpleReact(queueService, this.executor, this.retrier, this.async);
    }

    public SimpleReact withExecutor(Executor executor) {
        return this.executor == executor ? this : new SimpleReact(this.queueService, executor, this.retrier, this.async);
    }

    public SimpleReact withRetrier(RetryExecutor retrier) {
        return this.retrier == retrier ? this : new SimpleReact(this.queueService, this.executor, retrier, this.async);
    }

    public SimpleReact withAsync(Boolean async) {
        return this.async == async ? this : new SimpleReact(this.queueService, this.executor, this.retrier, async);
    }

    public Executor getQueueService() {
        return this.queueService;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RetryExecutor getRetrier() {
        return this.retrier;
    }

    public static class SimpleReactBuilder {
        private Executor queueService;
        private Executor executor;
        private RetryExecutor retrier;
        private Boolean async;

        SimpleReactBuilder() {
        }

        public SimpleReactBuilder queueService(Executor queueService) {
            this.queueService = queueService;
            return this;
        }

        public SimpleReactBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public SimpleReactBuilder retrier(RetryExecutor retrier) {
            this.retrier = retrier;
            return this;
        }

        public SimpleReactBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public SimpleReact build() {
            return new SimpleReact(this.queueService, this.executor, this.retrier, this.async);
        }

        public String toString() {
            return "SimpleReact.SimpleReactBuilder(queueService=" + this.queueService + ", executor=" + this.executor + ", retrier=" + this.retrier + ", async=" + this.async + ")";
        }
    }
}

