/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.internal.stream.spliterators.ReversableSpliterator;
import com.aol.cyclops.internal.stream.spliterators.ReversingArraySpliterator;
import com.aol.cyclops.internal.stream.spliterators.ReversingListSpliterator;
import com.aol.cyclops.internal.stream.spliterators.ReversingRangeIntSpliterator;
import com.aol.cyclops.internal.stream.spliterators.ReversingRangeLongSpliterator;
import com.aol.cyclops.types.ExtendedTraversable;
import com.aol.cyclops.types.FilterableFunctor;
import com.aol.cyclops.types.IterableFilterable;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.Unit;
import com.aol.cyclops.types.Unwrapable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.applicative.zipping.ApplyingZippingApplicativeBuilder;
import com.aol.cyclops.types.applicative.zipping.ZippingApplicativable;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.types.stream.HeadAndTail;
import com.aol.cyclops.types.stream.HotStream;
import com.aol.cyclops.types.stream.JoolManipulation;
import com.aol.cyclops.types.stream.JoolWindowing;
import com.aol.cyclops.types.stream.PausableHotStream;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.types.stream.reactive.ReactiveStreamsTerminalOperations;
import com.aol.cyclops.types.stream.reactive.SeqSubscriber;
import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.cyclops.util.stream.StreamUtils;
import com.aol.cyclops.util.stream.Streamable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface ReactiveSeq<T>
extends Unwrapable,
Stream<T>,
JoolManipulation<T>,
IterableFilterable<T>,
FilterableFunctor<T>,
ExtendedTraversable<T>,
IterableFoldable<T>,
CyclopsCollectable<T>,
JoolWindowing<T>,
Seq<T>,
Iterable<T>,
Publisher<T>,
ReactiveStreamsTerminalOperations<T>,
ZippingApplicativable<T>,
Unit<T>,
ConvertableSequence<T> {
    @Override
    public <T> ReactiveSeq<T> unitIterator(Iterator<T> var1);

    @Override
    public <T> ReactiveSeq<T> unit(T var1);

    @Override
    default public <U> U foldRight(U identity, BiFunction<? super T, ? super U, ? extends U> accumulator) {
        return (U)JoolWindowing.super.foldRight(identity, accumulator);
    }

    @Override
    default public void printOut() {
        JoolWindowing.super.printOut();
    }

    @Override
    default public <R> ApplyingZippingApplicativeBuilder<T, R, ZippingApplicativable<R>> applicatives() {
        Streamable<T> streamable = this.toStreamable();
        return new ApplyingZippingApplicativeBuilder(streamable, streamable);
    }

    @Override
    default public <R> ZippingApplicativable<R> ap1(Function<? super T, ? extends R> fn) {
        Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> dup = this.duplicateSequence();
        Streamable<T> streamable = ((ReactiveSeq)dup.v1).toStreamable();
        return (ZippingApplicativable)new ApplyingZippingApplicativeBuilder(streamable, streamable).applicative(fn).ap((Iterable)dup.v2);
    }

    @Override
    default public <U, R> ReactiveSeq<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return ReactiveSeq.fromStream(Seq.zip((Iterable)this, other, zipper));
    }

    @Override
    default public <U, R> ReactiveSeq<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> ReactiveSeq<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.zip(ReactiveSeq.fromStream(other), (BiFunction)zipper);
    }

    @Override
    public <R> R unwrap();

    public <T1> ReactiveSeq<T1> flatten();

    @Override
    public ReactiveSeq<T> cycle(int var1);

    public ReactiveSeq<T> cycle();

    public Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> duplicateSequence();

    public Tuple3<ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>> triplicate();

    public Tuple4<ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>> quadruplicate();

    public Tuple2<Optional<T>, ReactiveSeq<T>> splitSequenceAtHead();

    public Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> splitAt(int var1);

    public Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> splitBy(Predicate<T> var1);

    public Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> partitionSequence(Predicate<T> var1);

    @Override
    public ReactiveSeq<T> cycle(Monoid<T> var1, int var2);

    @Override
    public ReactiveSeq<T> cycleWhile(Predicate<? super T> var1);

    @Override
    public ReactiveSeq<T> cycleUntil(Predicate<? super T> var1);

    @Override
    default public <U> ReactiveSeq<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return this.zip(Seq.seq(other));
    }

    @Override
    default public <U> ReactiveSeq<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return this.zip(Seq.seq(other));
    }

    @Override
    default public <U> ReactiveSeq<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return ReactiveSeq.fromStream(JoolManipulation.super.zip(other));
    }

    @Override
    public <S, U> ReactiveSeq<Tuple3<T, S, U>> zip3(Stream<? extends S> var1, Stream<? extends U> var2);

    @Override
    public <T2, T3, T4> ReactiveSeq<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> var1, Stream<? extends T3> var2, Stream<? extends T4> var3);

    @Override
    default public ReactiveSeq<Tuple2<T, Long>> zipWithIndex() {
        return ReactiveSeq.fromStream(JoolManipulation.super.zipWithIndex());
    }

    public <S, R> ReactiveSeq<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> var1, BiFunction<? super T, ? super S, ? extends R> var2);

    @Override
    public ReactiveSeq<ListX<T>> sliding(int var1);

    @Override
    public ReactiveSeq<ListX<T>> sliding(int var1, int var2);

    @Override
    public ReactiveSeq<ListX<T>> grouped(int var1);

    @Override
    public ReactiveSeq<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> var1);

    public ReactiveSeq<ListX<T>> groupedBySizeAndTime(int var1, long var2, TimeUnit var4);

    public <C extends Collection<? super T>> ReactiveSeq<C> groupedBySizeAndTime(int var1, long var2, TimeUnit var4, Supplier<C> var5);

    public ReactiveSeq<ListX<T>> groupedByTime(long var1, TimeUnit var3);

    public <C extends Collection<? super T>> ReactiveSeq<C> groupedByTime(long var1, TimeUnit var3, Supplier<C> var4);

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> grouped(int var1, Supplier<C> var2);

    @Override
    public ReactiveSeq<ListX<T>> groupedUntil(Predicate<? super T> var1);

    @Override
    public ReactiveSeq<ListX<T>> groupedWhile(Predicate<? super T> var1);

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedWhile(Predicate<? super T> var1, Supplier<C> var2);

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedUntil(Predicate<? super T> var1, Supplier<C> var2);

    @Override
    default public <K, A, D> ReactiveSeq<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return ReactiveSeq.fromStream(JoolManipulation.super.grouped(classifier, downstream));
    }

    @Override
    default public <K> ReactiveSeq<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return ReactiveSeq.fromStream(JoolManipulation.super.grouped(classifier));
    }

    @Override
    default public <K> MapX<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return MapX.fromMap(JoolManipulation.super.groupBy(classifier));
    }

    @Override
    public ReactiveSeq<T> distinct();

    @Override
    public ReactiveSeq<T> scanLeft(Monoid<T> var1);

    @Override
    public <U> ReactiveSeq<U> scanLeft(U var1, BiFunction<? super U, ? super T, ? extends U> var2);

    @Override
    public ReactiveSeq<T> scanRight(Monoid<T> var1);

    @Override
    public <U> ReactiveSeq<U> scanRight(U var1, BiFunction<? super T, ? super U, ? extends U> var2);

    @Override
    public ReactiveSeq<T> sorted();

    @Override
    default public ReactiveSeq<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return ReactiveSeq.fromStream(StreamUtils.combine(this, predicate, op));
    }

    @Override
    public ReactiveSeq<T> sorted(Comparator<? super T> var1);

    @Override
    default public ReactiveSeq<T> takeWhile(Predicate<? super T> p) {
        return (ReactiveSeq)ExtendedTraversable.super.takeWhile(p);
    }

    @Override
    default public ReactiveSeq<T> dropWhile(Predicate<? super T> p) {
        return (ReactiveSeq)ExtendedTraversable.super.dropWhile(p);
    }

    @Override
    default public ReactiveSeq<T> takeUntil(Predicate<? super T> p) {
        return (ReactiveSeq)ExtendedTraversable.super.takeUntil(p);
    }

    @Override
    default public ReactiveSeq<T> dropUntil(Predicate<? super T> p) {
        return (ReactiveSeq)ExtendedTraversable.super.dropUntil(p);
    }

    @Override
    default public ReactiveSeq<T> dropRight(int num) {
        return (ReactiveSeq)ExtendedTraversable.super.dropRight(num);
    }

    @Override
    default public ReactiveSeq<T> takeRight(int num) {
        return (ReactiveSeq)ExtendedTraversable.super.takeRight(num);
    }

    @Override
    public ReactiveSeq<T> skip(long var1);

    @Override
    public ReactiveSeq<T> skipWhile(Predicate<? super T> var1);

    @Override
    public ReactiveSeq<T> skipUntil(Predicate<? super T> var1);

    default public ReactiveSeq<T> skipUntilClosed(Predicate<? super T> p) {
        return ReactiveSeq.fromStream(JoolManipulation.super.skipUntilClosed(p));
    }

    @Override
    public ReactiveSeq<T> limit(long var1);

    @Override
    public ReactiveSeq<T> limitWhile(Predicate<? super T> var1);

    @Override
    public ReactiveSeq<T> limitUntil(Predicate<? super T> var1);

    default public ReactiveSeq<T> limitUntilClosed(Predicate<? super T> p) {
        return ReactiveSeq.fromStream(JoolManipulation.super.limitUntilClosed(p));
    }

    @Override
    public ReactiveSeq<T> parallel();

    @Override
    public boolean allMatch(Predicate<? super T> var1);

    @Override
    public boolean anyMatch(Predicate<? super T> var1);

    @Override
    public boolean xMatch(int var1, Predicate<? super T> var2);

    @Override
    public boolean noneMatch(Predicate<? super T> var1);

    @Override
    public String join();

    @Override
    public String join(String var1);

    @Override
    public String join(String var1, String var2, String var3);

    @Override
    public HeadAndTail<T> headAndTail();

    @Override
    public Optional<T> findFirst();

    @Override
    public Optional<T> findAny();

    @Override
    default public <R> ReactiveSeq<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return this.map((T in) -> ((Trampoline)mapper.apply(in)).result());
    }

    @Override
    public <R> R mapReduce(Reducer<R> var1);

    @Override
    public <R> R mapReduce(Function<? super T, ? extends R> var1, Monoid<R> var2);

    @Override
    public T reduce(Monoid<T> var1);

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    public ListX<T> reduce(Stream<? extends Monoid<T>> var1);

    @Override
    public ListX<T> reduce(Iterable<? extends Monoid<T>> var1);

    @Override
    public T foldRight(Monoid<T> var1);

    @Override
    public T foldRight(T var1, BinaryOperator<T> var2);

    @Override
    public <T> T foldRightMapToType(Reducer<T> var1);

    @Override
    public Streamable<T> toStreamable();

    @Override
    public Set<T> toSet();

    @Override
    public List<T> toList();

    @Override
    public <C extends Collection<T>> C toCollection(Supplier<C> var1);

    public <T> Stream<T> toStream();

    @Override
    public ReactiveSeq<T> stream();

    @Override
    public boolean startsWithIterable(Iterable<T> var1);

    @Override
    public boolean startsWith(Stream<T> var1);

    public AnyMSeq<T> anyM();

    @Override
    public <R> ReactiveSeq<R> map(Function<? super T, ? extends R> var1);

    @Override
    public ReactiveSeq<T> peek(Consumer<? super T> var1);

    @Override
    public <R> ReactiveSeq<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public <R> ReactiveSeq<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> var1);

    public <R> ReactiveSeq<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> var1);

    public <R> ReactiveSeq<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> var1);

    @Override
    public ReactiveSeq<T> filter(Predicate<? super T> var1);

    @Override
    public ReactiveSeq<T> sequential();

    @Override
    public ReactiveSeq<T> unordered();

    @Override
    public ReactiveSeq<T> intersperse(T var1);

    @Override
    public <U> ReactiveSeq<U> ofType(Class<? extends U> var1);

    @Override
    public <U> ReactiveSeq<U> cast(Class<? extends U> var1);

    @Override
    public CollectionX<T> toLazyCollection();

    @Override
    public CollectionX<T> toConcurrentLazyCollection();

    @Override
    public Streamable<T> toConcurrentLazyStreamable();

    @Override
    public ReactiveSeq<T> reverse();

    @Override
    public ReactiveSeq<T> onClose(Runnable var1);

    @Override
    public ReactiveSeq<T> shuffle();

    public ReactiveSeq<T> appendStream(Stream<T> var1);

    public ReactiveSeq<T> prependStream(Stream<T> var1);

    public ReactiveSeq<T> append(T ... var1);

    public ReactiveSeq<T> append(T var1);

    public ReactiveSeq<T> prepend(T var1);

    public ReactiveSeq<T> prepend(T ... var1);

    public ReactiveSeq<T> insertAt(int var1, T ... var2);

    public ReactiveSeq<T> deleteBetween(int var1, int var2);

    public ReactiveSeq<T> insertStreamAt(int var1, Stream<T> var2);

    @Override
    public FutureOperations<T> futureOperations(Executor var1);

    @Override
    public boolean endsWithIterable(Iterable<T> var1);

    @Override
    public boolean endsWith(Stream<T> var1);

    public ReactiveSeq<T> skip(long var1, TimeUnit var3);

    public ReactiveSeq<T> limit(long var1, TimeUnit var3);

    @Override
    public ReactiveSeq<T> skipLast(int var1);

    @Override
    public ReactiveSeq<T> limitLast(int var1);

    public HotStream<T> hotStream(Executor var1);

    public HotStream<T> primedHotStream(Executor var1);

    public PausableHotStream<T> pausableHotStream(Executor var1);

    public PausableHotStream<T> primedPausableHotStream(Executor var1);

    @Override
    public T firstValue();

    @Override
    default public T single() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return result;
            }
        }
        throw new UnsupportedOperationException("single only works for Streams with a single value");
    }

    @Override
    default public T single(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).single();
    }

    @Override
    default public Optional<T> singleOptional() {
        Iterator it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return Optional.of(result);
            }
        }
        return Optional.empty();
    }

    @Override
    default public Optional<T> get(long index) {
        return this.zipWithIndex().filter((T t) -> (Long)t.v2 == index).findFirst().map((? super T t) -> t.v1());
    }

    default public Tuple2<T, ReactiveSeq<T>> elementAt(long index) {
        Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> tuple = this.duplicateSequence();
        return tuple.map1(s -> s.zipWithIndex().filter((T t) -> (Long)t.v2 == index).findFirst().map((? super T t) -> t.v1()).get());
    }

    default public ReactiveSeq<Tuple2<T, Long>> elapsed() {
        AtomicLong last = new AtomicLong(System.currentTimeMillis());
        return this.zip(ReactiveSeq.generate(() -> {
            long now = System.currentTimeMillis();
            long result = now - last.get();
            last.set(now);
            return result;
        }));
    }

    default public ReactiveSeq<Tuple2<T, Long>> timestamp() {
        return this.zip(ReactiveSeq.generate(() -> System.currentTimeMillis()));
    }

    public static <T> SeqSubscriber<T> subscriber() {
        return SeqSubscriber.subscriber();
    }

    public static <T> ReactiveSeq<T> empty() {
        return ReactiveSeq.fromStream(Stream.empty());
    }

    @SafeVarargs
    public static <T> ReactiveSeq<T> of(T ... elements) {
        ReversingArraySpliterator array = new ReversingArraySpliterator(elements, false, 0);
        return StreamUtils.reactiveSeq(StreamSupport.stream(array, false), Optional.ofNullable(array));
    }

    @SafeVarargs
    public static <T> ReactiveSeq<T> reversedOf(T ... elements) {
        ReversableSpliterator array = new ReversingArraySpliterator(elements, false, 0).invert();
        return StreamUtils.reactiveSeq(StreamSupport.stream(array, false), Optional.ofNullable(array));
    }

    public static <T> ReactiveSeq<T> reversedListOf(List<T> elements) {
        Objects.requireNonNull(elements);
        ReversableSpliterator list = new ReversingListSpliterator<T>(elements, false).invert();
        return StreamUtils.reactiveSeq(StreamSupport.stream(list, false), Optional.ofNullable(list));
    }

    public static ReactiveSeq<Integer> range(int start, int end) {
        ReversingRangeIntSpliterator range = new ReversingRangeIntSpliterator(start, end, false);
        return StreamUtils.reactiveSeq(StreamSupport.stream(range, false), Optional.ofNullable(range));
    }

    public static ReactiveSeq<Long> rangeLong(long start, long end) {
        ReversingRangeLongSpliterator range = new ReversingRangeLongSpliterator(start, end, false);
        return StreamUtils.reactiveSeq(StreamSupport.stream(range, false), Optional.ofNullable(range));
    }

    public static <T> ReactiveSeq<T> fromStream(Stream<T> stream) {
        Objects.requireNonNull(stream);
        if (stream instanceof ReactiveSeq) {
            return (ReactiveSeq)stream;
        }
        return StreamUtils.reactiveSeq(stream, Optional.empty());
    }

    public static ReactiveSeq<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return StreamUtils.reactiveSeq(stream.boxed(), Optional.empty());
    }

    public static ReactiveSeq<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return StreamUtils.reactiveSeq(stream.boxed(), Optional.empty());
    }

    public static ReactiveSeq<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return StreamUtils.reactiveSeq(stream.boxed(), Optional.empty());
    }

    public static <T> ReactiveSeq<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        ReversingListSpliterator<T> array = new ReversingListSpliterator<T>(list, false);
        return StreamUtils.reactiveSeq(StreamSupport.stream(array, false), Optional.ofNullable(array));
    }

    public static <T> ReactiveSeq<T> fromPublisher(Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher);
        SeqSubscriber sub = SeqSubscriber.subscriber();
        publisher.subscribe(sub);
        return sub.stream();
    }

    public static <T> ReactiveSeq<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return StreamUtils.reactiveSeq(StreamSupport.stream(iterable.spliterator(), false), Optional.empty());
    }

    public static <T> ReactiveSeq<T> fromIterator(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return ReactiveSeq.fromIterable(() -> iterator);
    }

    public static <T> ReactiveSeq<T> iterate(T seed, UnaryOperator<T> f) {
        return StreamUtils.reactiveSeq(Stream.iterate(seed, f), Optional.empty());
    }

    public static <U, T> ReactiveSeq<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.fromStream(Seq.unfold(seed, unfolder));
    }

    public static <T> ReactiveSeq<T> generate(Supplier<T> s) {
        return StreamUtils.reactiveSeq(Stream.generate(s), Optional.empty());
    }

    public static <T, U> Tuple2<ReactiveSeq<T>, ReactiveSeq<U>> unzip(ReactiveSeq<Tuple2<T, U>> sequence) {
        Tuple2<ReactiveSeq<Tuple2<T, U>>, ReactiveSeq<Tuple2<T, U>>> tuple2 = sequence.duplicateSequence();
        return new Tuple2((Object)((ReactiveSeq)tuple2.v1).map(Tuple2::v1), (Object)((ReactiveSeq)tuple2.v2).map(Tuple2::v2));
    }

    public static <T1, T2, T3> Tuple3<ReactiveSeq<T1>, ReactiveSeq<T2>, ReactiveSeq<T3>> unzip3(ReactiveSeq<Tuple3<T1, T2, T3>> sequence) {
        Tuple3<ReactiveSeq<Tuple3<T1, T2, T3>>, ReactiveSeq<Tuple3<T1, T2, T3>>, ReactiveSeq<Tuple3<T1, T2, T3>>> tuple3 = sequence.triplicate();
        return new Tuple3((Object)((ReactiveSeq)tuple3.v1).map(Tuple3::v1), (Object)((ReactiveSeq)tuple3.v2).map(Tuple3::v2), (Object)((ReactiveSeq)tuple3.v3).map(Tuple3::v3));
    }

    public static <T1, T2, T3, T4> Tuple4<ReactiveSeq<T1>, ReactiveSeq<T2>, ReactiveSeq<T3>, ReactiveSeq<T4>> unzip4(ReactiveSeq<Tuple4<T1, T2, T3, T4>> sequence) {
        Tuple4<ReactiveSeq<Tuple4<T1, T2, T3, T4>>, ReactiveSeq<Tuple4<T1, T2, T3, T4>>, ReactiveSeq<Tuple4<T1, T2, T3, T4>>, ReactiveSeq<Tuple4<T1, T2, T3, T4>>> quad = sequence.quadruplicate();
        return new Tuple4((Object)((ReactiveSeq)quad.v1).map(Tuple4::v1), (Object)((ReactiveSeq)quad.v2).map(Tuple4::v2), (Object)((ReactiveSeq)quad.v3).map(Tuple4::v3), (Object)((ReactiveSeq)quad.v4).map(Tuple4::v4));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> crossJoin(Stream<? extends U> other) {
        return ReactiveSeq.fromStream(JoolManipulation.super.crossJoin(other));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> crossJoin(Seq<? extends U> other) {
        return ReactiveSeq.fromStream(JoolManipulation.super.crossJoin(other));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> crossJoin(Iterable<? extends U> other) {
        return ReactiveSeq.fromStream(JoolManipulation.super.crossJoin(other));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> innerJoin(Stream<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromStream(ReactiveSeq.fromStream(other));
        return this.innerJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> innerJoin(Iterable<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromIterable(other);
        return this.innerJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> innerJoin(Seq<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromStream(ReactiveSeq.fromStream(other));
        return this.innerJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> innerJoin(Streamable<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        return this.flatMap((T t) -> other.stream().filter(u -> predicate.test(t, u)).map((T u) -> Tuple.tuple((Object)t, (Object)u)));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> leftOuterJoin(Stream<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromIterable(ReactiveSeq.fromStream(other).toLazyCollection());
        return this.leftOuterJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> leftOuterJoin(Seq<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromIterable(ReactiveSeq.fromStream(other));
        return this.leftOuterJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> leftOuterJoin(Iterable<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        Streamable<? extends U> s = Streamable.fromIterable(other);
        return this.leftOuterJoin(s, predicate);
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> leftOuterJoin(Streamable<? extends U> s, BiPredicate<? super T, ? super U> predicate) {
        return this.flatMap((T t) -> Seq.seq(s.stream()).filter(u -> predicate.test(t, u)).onEmpty(null).map(u -> Tuple.tuple((Object)t, (Object)u)));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> rightOuterJoin(Stream<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        return ReactiveSeq.fromStream(JoolManipulation.super.rightOuterJoin(other, predicate));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> rightOuterJoin(Iterable<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        return ReactiveSeq.fromStream(JoolManipulation.super.rightOuterJoin(other, predicate));
    }

    default public <U> ReactiveSeq<Tuple2<T, U>> rightOuterJoin(Seq<? extends U> other, BiPredicate<? super T, ? super U> predicate) {
        return ReactiveSeq.fromStream(JoolManipulation.super.rightOuterJoin(other, predicate));
    }

    default public ReactiveSeq<T> onEmptySwitch(Supplier<? extends Stream<T>> switchTo) {
        AtomicBoolean called = new AtomicBoolean(false);
        return ReactiveSeq.fromStream(this.onEmptyGet(() -> {
            called.set(true);
            return switchTo.get();
        }).flatMap((T s) -> {
            if (called.get()) {
                return (Stream)s;
            }
            return Stream.of(s);
        }));
    }

    @Override
    public ReactiveSeq<T> onEmpty(T var1);

    @Override
    public ReactiveSeq<T> onEmptyGet(Supplier<? extends T> var1);

    @Override
    default public <X extends Throwable> ReactiveSeq<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return ReactiveSeq.fromStream(JoolManipulation.super.onEmptyThrow(supplier));
    }

    public ReactiveSeq<T> concat(Stream<? extends T> var1);

    public ReactiveSeq<T> concat(T var1);

    public ReactiveSeq<T> concat(T ... var1);

    public <U> ReactiveSeq<T> distinct(Function<? super T, ? extends U> var1);

    @Override
    public ReactiveSeq<T> shuffle(Random var1);

    @Override
    public ReactiveSeq<T> slice(long var1, long var3);

    @Override
    public <U extends Comparable<? super U>> ReactiveSeq<T> sorted(Function<? super T, ? extends U> var1);

    public ReactiveSeq<T> xPer(int var1, long var2, TimeUnit var4);

    public ReactiveSeq<T> onePer(long var1, TimeUnit var3);

    public ReactiveSeq<T> debounce(long var1, TimeUnit var3);

    public ReactiveSeq<T> fixedDelay(long var1, TimeUnit var3);

    public ReactiveSeq<T> jitter(long var1);

    public ReactiveSeq<T> recover(Function<Throwable, ? extends T> var1);

    public <EX extends Throwable> ReactiveSeq<T> recover(Class<EX> var1, Function<EX, ? extends T> var2);

    default public <R> ReactiveSeq<R> retry(Function<? super T, ? extends R> fn) {
        return this.retry(fn, 7, 2L, TimeUnit.SECONDS);
    }

    default public <R> ReactiveSeq<R> retry(Function<? super T, ? extends R> fn, int retries, long delay, TimeUnit timeUnit) {
        Function<Object, Object> retry = t -> {
            int count = retries;
            long[] sleep = new long[]{timeUnit.toMillis(delay)};
            Throwable exception = null;
            while (count-- > 0) {
                ExceptionSoftener.softenRunnable(() -> Thread.sleep(sleep[0])).run();
                try {
                    return fn.apply(t);
                }
                catch (Throwable e) {
                    exception = e;
                    sleep[0] = sleep[0] * 2L;
                }
            }
            ExceptionSoftener.throwSoftenedException(exception);
            return null;
        };
        return this.map(retry);
    }

    default public ReactiveSeq<T> remove(T t) {
        return this.filter((T v) -> v != t);
    }

    @Override
    default public ReactiveSeq<ReactiveSeq<T>> permutations() {
        Streamable streamable = Streamable.fromStream(this).permutations();
        return streamable.map((T s) -> s.reactiveSeq()).reactiveSeq();
    }

    default public ReactiveSeq<T> subStream(int start, int end) {
        return this.limit(end).deleteBetween(0, start);
    }

    @Override
    default public ReactiveSeq<ReactiveSeq<T>> combinations(int size) {
        Streamable streamable = Streamable.fromStream(this).combinations(size);
        return streamable.map((T s) -> s.reactiveSeq()).reactiveSeq();
    }

    @Override
    default public ReactiveSeq<ReactiveSeq<T>> combinations() {
        Streamable streamable = Streamable.fromStream(this).combinations();
        return streamable.map((T s) -> s.reactiveSeq()).reactiveSeq();
    }

    @Override
    public HotStream<T> schedule(String var1, ScheduledExecutorService var2);

    @Override
    public HotStream<T> scheduleFixedDelay(long var1, ScheduledExecutorService var3);

    @Override
    public HotStream<T> scheduleFixedRate(long var1, ScheduledExecutorService var3);

    default public int size() {
        return this.toList().size();
    }

    public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> var1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> var2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var3);

    public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> var1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> var2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> var3, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var4);

    public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> var1, Function<? super T, Function<? super R1, ? extends R>> var2);

    public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> var1, Function<? super T, Function<? super R1, Boolean>> var2, Function<? super T, Function<? super R1, ? extends R>> var3);

    @Override
    default public long count() {
        return CyclopsCollectable.super.count();
    }

    @Override
    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return CyclopsCollectable.super.collect(collector);
    }

    @Override
    default public Collectable<T> collectable() {
        return this;
    }

    @Override
    default public <R> ReactiveSeq<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (ReactiveSeq)ZippingApplicativable.super.patternMatch(case1, otherwise);
    }

    @Override
    default public long count(Predicate<? super T> predicate) {
        return CyclopsCollectable.super.count(predicate);
    }

    @Override
    default public long countDistinct(Predicate<? super T> predicate) {
        return CyclopsCollectable.super.countDistinct(predicate);
    }

    @Override
    default public <U> long countDistinctBy(Function<? super T, ? extends U> function, Predicate<? super U> predicate) {
        return CyclopsCollectable.super.countDistinctBy(function, predicate);
    }

    @Override
    default public long countDistinct() {
        return CyclopsCollectable.super.countDistinct();
    }

    @Override
    default public <U> long countDistinctBy(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.countDistinctBy(function);
    }

    @Override
    default public Optional<T> mode() {
        return CyclopsCollectable.super.mode();
    }

    @Override
    default public Optional<T> sum() {
        return CyclopsCollectable.super.sum();
    }

    @Override
    default public <U> Optional<U> sum(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.sum(function);
    }

    @Override
    default public int sumInt(ToIntFunction<? super T> function) {
        return CyclopsCollectable.super.sumInt(function);
    }

    @Override
    default public long sumLong(ToLongFunction<? super T> function) {
        return CyclopsCollectable.super.sumLong(function);
    }

    @Override
    default public double sumDouble(ToDoubleFunction<? super T> function) {
        return CyclopsCollectable.super.sumDouble(function);
    }

    @Override
    default public Optional<T> avg() {
        return CyclopsCollectable.super.avg();
    }

    @Override
    default public <U> Optional<U> avg(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.avg(function);
    }

    @Override
    default public double avgInt(ToIntFunction<? super T> function) {
        return CyclopsCollectable.super.avgInt(function);
    }

    @Override
    default public double avgLong(ToLongFunction<? super T> function) {
        return CyclopsCollectable.super.avgLong(function);
    }

    @Override
    default public double avgDouble(ToDoubleFunction<? super T> function) {
        return CyclopsCollectable.super.avgDouble(function);
    }

    @Override
    default public Optional<T> min() {
        return CyclopsCollectable.super.min();
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<U> min(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.min(function);
    }

    @Override
    default public <U> Optional<U> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.min(function, comparator);
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<T> minBy(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.minBy(function);
    }

    @Override
    default public <U> Optional<T> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.minBy(function, comparator);
    }

    @Override
    default public Optional<T> max() {
        return CyclopsCollectable.super.max();
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<U> max(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.max(function);
    }

    @Override
    default public <U> Optional<U> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.max(function, comparator);
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<T> maxBy(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.maxBy(function);
    }

    @Override
    default public <U> Optional<T> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.maxBy(function, comparator);
    }

    @Override
    default public Optional<T> median() {
        return CyclopsCollectable.super.median();
    }

    @Override
    default public Optional<T> median(Comparator<? super T> comparator) {
        return CyclopsCollectable.super.median(comparator);
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<T> medianBy(Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.medianBy(function);
    }

    @Override
    default public <U> Optional<T> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.medianBy(function, comparator);
    }

    @Override
    default public Optional<T> percentile(double percentile) {
        return CyclopsCollectable.super.percentile(percentile);
    }

    @Override
    default public Optional<T> percentile(double percentile, Comparator<? super T> comparator) {
        return CyclopsCollectable.super.percentile(percentile, comparator);
    }

    @Override
    default public <U extends Comparable<? super U>> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return CyclopsCollectable.super.percentileBy(percentile, function);
    }

    @Override
    default public <U> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return CyclopsCollectable.super.percentileBy(percentile, function, comparator);
    }

    @Override
    default public <L extends List<T>> L toList(Supplier<L> factory2) {
        return CyclopsCollectable.super.toList(factory2);
    }

    @Override
    default public <S extends Set<T>> S toSet(Supplier<S> factory2) {
        return CyclopsCollectable.super.toSet(factory2);
    }

    @Override
    default public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return CyclopsCollectable.super.toMap(keyMapper, valueMapper);
    }

    @Override
    default public String toString(CharSequence delimiter) {
        return CyclopsCollectable.super.toString(delimiter);
    }

    @Override
    default public String toString(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return CyclopsCollectable.super.toString(delimiter, prefix, suffix);
    }

    @Override
    default public Optional<T> max(Comparator<? super T> comparator) {
        return StreamUtils.max(this, comparator);
    }

    @Override
    default public Optional<T> min(Comparator<? super T> comparator) {
        return StreamUtils.min(this, comparator);
    }

    @Override
    default public void printErr() {
        JoolWindowing.super.printErr();
    }

    @Override
    default public void print(PrintWriter writer) {
        JoolWindowing.super.print(writer);
    }

    @Override
    default public void print(PrintStream stream) {
        JoolWindowing.super.print(stream);
    }
}

