/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.util.validation;

import com.aol.cyclops.Reducer;
import com.aol.cyclops.Semigroup;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.util.validation.ValidationResult;
import java.beans.ConstructorProperties;

public class ValidationResults<T, E> {
    private final ListX<ValidationResult<T, E>> results;

    public String toString() {
        return this.results.toString();
    }

    public ListX<Xor<E, T>> toXors() {
        return this.results.map(v -> v.toXor());
    }

    public Xor<ListX<T>, ListX<E>> toErrorSequence() {
        return Xor.sequenceSecondary(this.toXors());
    }

    public <R> Xor<?, R> accumulateErrors(Reducer<R> reducer) {
        return Xor.accumulateSecondary(this.toXors(), reducer);
    }

    public <R> Xor<?, E> accumulateErrors(Semigroup<E> combiner) {
        return Xor.accumulateSecondary(this.toXors(), combiner);
    }

    public Xor<ListX<E>, ListX<T>> toSuccessSequence() {
        return Xor.sequencePrimary(this.toXors());
    }

    public <R> Xor<?, R> accumulateSuccess(Reducer<R> reducer) {
        return Xor.accumulateSecondary(this.toXors(), reducer);
    }

    public <R> Xor<?, E> accumulateSuccess(Semigroup<E> combiner) {
        return Xor.accumulateSecondary(this.toXors(), combiner);
    }

    public ListX<ValidationResult<T, E>> getResults() {
        return this.results;
    }

    @ConstructorProperties(value={"results"})
    public ValidationResults(ListX<ValidationResult<T, E>> results) {
        this.results = results;
    }
}

