/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.reactive;

import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.cyclops.util.function.Memoize;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ValueSubscriber<T>
implements Subscriber<T>,
Value<T> {
    private final Object UNSET = new Object();
    private final AtomicReference firstValue = new AtomicReference<Object>(this.UNSET);
    private final AtomicReference firstError = new AtomicReference<Object>(this.UNSET);
    private final Runnable onComplete;
    private volatile Subscription s;
    private final Runnable requestOne = Memoize.memoizeRunnable(() -> this.s.request(1L));

    private ValueSubscriber(Runnable onComplete) {
        this.onComplete = onComplete;
    }

    public static <T> ValueSubscriber<T> subscriber(Runnable onComplete) {
        return new ValueSubscriber<T>(onComplete);
    }

    public static <T> ValueSubscriber<T> subscriber() {
        return new ValueSubscriber<T>(() -> {});
    }

    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s);
        if (this.s == null) {
            this.s = s;
            s.request(1L);
        } else {
            s.cancel();
        }
    }

    public void onNext(T t) {
        Objects.requireNonNull(t);
        this.firstValue.compareAndSet(this.UNSET, t);
    }

    public void onError(Throwable t) {
        Objects.requireNonNull(t);
        this.firstError.compareAndSet(this.UNSET, t);
    }

    public void onComplete() {
        this.onComplete.run();
        this.firstError.set(new NoSuchElementException("publisher has no elements"));
    }

    public void requestOne() {
        this.firstValue.set(this.UNSET);
        this.firstError.set(this.UNSET);
        this.s.request(1L);
    }

    @Override
    public T get() {
        while (this.firstValue.get() == this.UNSET && this.firstError.get() == this.UNSET) {
            LockSupport.parkNanos(1000000L);
        }
        if (this.firstValue.get() == this.UNSET) {
            return null;
        }
        return (T)this.firstValue.get();
    }

    @Override
    public Xor<Throwable, T> toXor() {
        if (this.get() == null && this.firstError.get() != this.UNSET) {
            return Xor.secondary((Throwable)this.firstError.get());
        }
        return Xor.primary(this.get());
    }

    private T throwingGet() {
        while (this.firstValue.get() == this.UNSET && this.firstError.get() == this.UNSET) {
            LockSupport.parkNanos(1000000L);
        }
        if (this.firstValue.get() == this.UNSET) {
            throw ExceptionSoftener.throwSoftenedException((Throwable)this.firstError.get());
        }
        return (T)this.firstValue.get();
    }

    @Override
    public <X extends Throwable> Try<T, X> toTry(Class<X> ... classes) {
        return Try.withCatch(() -> this.throwingGet(), classes);
    }

    @Override
    public Ior<Throwable, T> toIor() {
        this.get();
        Ior secondary = null;
        Ior primary = null;
        if (this.firstError.get() != this.UNSET) {
            secondary = Ior.secondary((Throwable)this.firstError.get());
        }
        if (this.firstValue.get() != this.UNSET) {
            primary = Ior.primary(this.firstValue.get());
        }
        if (secondary != null && primary != null) {
            return Ior.both(secondary, primary);
        }
        if (primary != null) {
            return primary;
        }
        return secondary;
    }
}

