/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.lazy;

import com.aol.cyclops.control.Eval;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.lazy.DoubleOperators;
import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;

public interface DoubleOperatorsMixin<T>
extends DoubleOperators<T>,
HasStream<T> {
    @Override
    default public Eval<Double> sumDouble(ToDoubleFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).sum());
    }

    @Override
    default public Eval<OptionalDouble> maxDouble(ToDoubleFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).max());
    }

    @Override
    default public Eval<OptionalDouble> minDouble(ToDoubleFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).min());
    }

    @Override
    default public Eval<OptionalDouble> averageDouble(ToDoubleFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).average());
    }

    @Override
    default public Eval<DoubleSummaryStatistics> summaryStatisticsDouble(ToDoubleFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).summaryStatistics());
    }
}

