/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream;

import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.util.function.Memoize;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;

public class HeadAndTail<T> {
    private final Supplier<T> head;
    private final Supplier<ReactiveSeq<T>> tail;
    private final Supplier<Boolean> isHead;

    public HeadAndTail(Iterator<T> it) {
        this.isHead = Memoize.memoizeSupplier(() -> it.hasNext());
        this.head = Memoize.memoizeSupplier(() -> {
            if (this.isHead.get().booleanValue()) {
                return it.next();
            }
            throw new NoSuchElementException();
        });
        this.tail = Memoize.memoizeSupplier(() -> {
            if (!this.isHead.get().booleanValue()) {
                return ReactiveSeq.empty();
            }
            this.head.get();
            return ReactiveSeq.fromIterator(it);
        });
    }

    public boolean isHeadPresent() {
        return this.isHead.get();
    }

    public T head() {
        return this.head.get();
    }

    public Optional<T> headOptional() {
        return this.isHeadPresent() ? Optional.of(this.head()) : Optional.empty();
    }

    public Maybe<T> headMaybe() {
        return this.isHeadPresent() ? Maybe.fromEvalOf(Eval.later(this.head)) : Maybe.none();
    }

    public ReactiveSeq<T> headStream() {
        return this.isHeadPresent() ? ReactiveSeq.of(new Supplier[]{this.head}).map(Supplier::get) : ReactiveSeq.empty();
    }

    public ReactiveSeq<T> tail() {
        return this.tail.get();
    }

    @ConstructorProperties(value={"head", "tail", "isHead"})
    public HeadAndTail(Supplier<T> head, Supplier<ReactiveSeq<T>> tail, Supplier<Boolean> isHead) {
        this.head = head;
        this.tail = tail;
        this.isHead = isHead;
    }
}

