/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream;

import com.aol.cyclops.control.ReactiveSeq;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import org.jooq.lambda.Collectable;

public interface CyclopsCollectable<T>
extends Collectable<T>,
Iterable<T> {
    default public <U> Optional<T> modeBy(Function<? super T, ? extends U> function) {
        return this.collectable().modeBy(function);
    }

    default public ReactiveSeq<T> modeAll() {
        return ReactiveSeq.fromStream(this.collectable().modeAll());
    }

    default public <U> ReactiveSeq<T> modeAllBy(Function<? super T, ? extends U> function) {
        return ReactiveSeq.fromStream(this.collectable().modeAllBy(function));
    }

    default public ReactiveSeq<T> minAll() {
        return ReactiveSeq.fromStream(this.collectable().minAll());
    }

    default public ReactiveSeq<T> minAll(Comparator<? super T> comparator) {
        return ReactiveSeq.fromStream(this.collectable().minAll(comparator));
    }

    default public <U extends Comparable<? super U>> ReactiveSeq<U> minAll(Function<? super T, ? extends U> function) {
        return ReactiveSeq.fromStream(this.collectable().minAll(function));
    }

    default public <U> ReactiveSeq<U> minAll(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return ReactiveSeq.fromStream(this.collectable().minAll(function, comparator));
    }

    default public <U extends Comparable<? super U>> ReactiveSeq<T> minAllBy(Function<? super T, ? extends U> function) {
        return ReactiveSeq.fromStream(this.collectable().minAllBy(function));
    }

    default public <U> ReactiveSeq<T> minAllBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return ReactiveSeq.fromStream(this.collectable().minAllBy(function, comparator));
    }

    default public ReactiveSeq<T> maxAll() {
        return ReactiveSeq.fromStream(this.collectable().maxAll());
    }

    default public ReactiveSeq<T> maxAll(Comparator<? super T> comparator) {
        return ReactiveSeq.fromStream(this.collectable().maxAll(comparator));
    }

    default public <U extends Comparable<? super U>> ReactiveSeq<U> maxAll(Function<? super T, ? extends U> function) {
        return ReactiveSeq.fromStream(this.collectable().maxAll(function));
    }

    default public <U> ReactiveSeq<U> maxAll(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return ReactiveSeq.fromStream(this.collectable().maxAll(function, comparator));
    }

    default public <U extends Comparable<? super U>> ReactiveSeq<T> maxAllBy(Function<? super T, ? extends U> function) {
        return ReactiveSeq.fromStream(this.collectable().maxAllBy(function));
    }

    default public <U> ReactiveSeq<T> maxAllBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return ReactiveSeq.fromStream(this.collectable().maxAllBy(function, comparator));
    }

    default public Optional<T> bitAnd() {
        return this.collectable().bitAnd();
    }

    default public <U> Optional<U> bitAnd(Function<? super T, ? extends U> function) {
        return this.collectable().bitAnd(function);
    }

    default public int bitAndInt(ToIntFunction<? super T> function) {
        return this.collectable().bitAndInt(function);
    }

    default public long bitAndLong(ToLongFunction<? super T> function) {
        return this.collectable().bitAndLong(function);
    }

    default public Optional<T> bitOr() {
        return this.collectable().bitOr();
    }

    default public <U> Optional<U> bitOr(Function<? super T, ? extends U> function) {
        return this.collectable().bitOr(function);
    }

    default public int bitOrInt(ToIntFunction<? super T> function) {
        return this.collectable().bitOrInt(function);
    }

    default public long bitOrLong(ToLongFunction<? super T> function) {
        return this.collectable().bitOrLong(function);
    }

    default public <K> Map<K, T> toMap(Function<? super T, ? extends K> keyMapper) {
        return this.collectable().toMap(keyMapper);
    }

    default public String commonPrefix() {
        return this.collectable().commonPrefix();
    }

    default public String commonSuffix() {
        return this.collectable().commonSuffix();
    }

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return (R)this.collectable().collect(collector);
    }

    default public long count() {
        return this.collectable().count();
    }

    default public long count(Predicate<? super T> predicate) {
        return this.collectable().count(predicate);
    }

    default public long countDistinct(Predicate<? super T> predicate) {
        return this.collectable().countDistinct(predicate);
    }

    default public <U> long countDistinctBy(Function<? super T, ? extends U> function, Predicate<? super U> predicate) {
        return this.collectable().countDistinctBy(function, predicate);
    }

    public Collectable<T> collectable();

    default public long countDistinct() {
        return this.collectable().countDistinct();
    }

    default public <U> long countDistinctBy(Function<? super T, ? extends U> function) {
        return this.collectable().countDistinctBy(function);
    }

    default public Optional<T> mode() {
        return this.collectable().mode();
    }

    default public Optional<T> sum() {
        return this.collectable().sum();
    }

    default public <U> Optional<U> sum(Function<? super T, ? extends U> function) {
        return this.collectable().sum(function);
    }

    default public int sumInt(ToIntFunction<? super T> function) {
        return this.collectable().sumInt(function);
    }

    default public long sumLong(ToLongFunction<? super T> function) {
        return this.collectable().sumLong(function);
    }

    default public double sumDouble(ToDoubleFunction<? super T> function) {
        return this.collectable().sumDouble(function);
    }

    default public Optional<T> avg() {
        return this.collectable().avg();
    }

    default public <U> Optional<U> avg(Function<? super T, ? extends U> function) {
        return this.collectable().avg(function);
    }

    default public double avgInt(ToIntFunction<? super T> function) {
        return this.collectable().avgInt(function);
    }

    default public double avgLong(ToLongFunction<? super T> function) {
        return this.collectable().avgLong(function);
    }

    default public double avgDouble(ToDoubleFunction<? super T> function) {
        return this.collectable().avgDouble(function);
    }

    default public Optional<T> min() {
        return this.collectable().min();
    }

    default public Optional<T> min(Comparator<? super T> comparator) {
        return this.collectable().min(comparator);
    }

    default public <U extends Comparable<? super U>> Optional<U> min(Function<? super T, ? extends U> function) {
        return this.collectable().min(function);
    }

    default public <U> Optional<U> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().min(function, comparator);
    }

    default public <U extends Comparable<? super U>> Optional<T> minBy(Function<? super T, ? extends U> function) {
        return this.collectable().minBy(function);
    }

    default public <U> Optional<T> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().minBy(function, comparator);
    }

    default public Optional<T> max() {
        return this.collectable().max();
    }

    default public Optional<T> max(Comparator<? super T> comparator) {
        return this.collectable().max(comparator);
    }

    default public <U extends Comparable<? super U>> Optional<U> max(Function<? super T, ? extends U> function) {
        return this.collectable().max(function);
    }

    default public <U> Optional<U> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().max(function, comparator);
    }

    default public <U extends Comparable<? super U>> Optional<T> maxBy(Function<? super T, ? extends U> function) {
        return this.collectable().maxBy(function);
    }

    default public <U> Optional<T> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().maxBy(function, comparator);
    }

    default public Optional<T> median() {
        return this.collectable().median();
    }

    default public Optional<T> median(Comparator<? super T> comparator) {
        return this.collectable().median(comparator);
    }

    default public <U extends Comparable<? super U>> Optional<T> medianBy(Function<? super T, ? extends U> function) {
        return this.collectable().medianBy(function);
    }

    default public <U> Optional<T> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().medianBy(function, comparator);
    }

    default public Optional<T> percentile(double percentile) {
        return this.collectable().percentile(percentile);
    }

    default public Optional<T> percentile(double percentile, Comparator<? super T> comparator) {
        return this.collectable().percentile(percentile, comparator);
    }

    default public <U extends Comparable<? super U>> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return this.collectable().percentileBy(percentile, function);
    }

    default public <U> Optional<T> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.collectable().percentileBy(percentile, function, comparator);
    }

    default public boolean allMatch(Predicate<? super T> c) {
        return this.collectable().allMatch(c);
    }

    default public boolean anyMatch(Predicate<? super T> c) {
        return this.collectable().anyMatch(c);
    }

    default public boolean noneMatch(Predicate<? super T> c) {
        return this.collectable().noneMatch(c);
    }

    default public List<T> toList() {
        if (this instanceof List) {
            return (List)((Object)this);
        }
        return this.collectable().toList();
    }

    default public <L extends List<T>> L toList(Supplier<L> factory2) {
        return (L)this.collectable().toList(factory2);
    }

    default public Set<T> toSet() {
        if (this instanceof Set) {
            return (Set)((Object)this);
        }
        return this.collectable().toSet();
    }

    default public <S extends Set<T>> S toSet(Supplier<S> factory2) {
        return (S)this.collectable().toSet(factory2);
    }

    default public <C extends Collection<T>> C toCollection(Supplier<C> factory2) {
        return (C)this.collectable().toCollection(factory2);
    }

    default public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.collectable().toMap(keyMapper, valueMapper);
    }

    default public String toString(CharSequence delimiter) {
        return this.collectable().toString(delimiter);
    }

    default public String toString(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collectable().toString(delimiter, prefix, suffix);
    }
}

