/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.internal.react.stream.CloseableIterator;
import com.aol.cyclops.types.futurestream.NullValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public class LazyFutureStreamFunctions {
    static <T1, T2> Seq<Tuple2<T1, T2>> zip(Stream<T1> left, Stream<? extends T2> right) {
        return LazyFutureStreamFunctions.zip(left, right, Tuple::tuple);
    }

    static <T1, T2, R> Seq<R> zip(Stream<T1> left, Stream<T2> right, final BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        final Iterator it1 = left.iterator();
        final Iterator it2 = right.iterator();
        class Zip
        implements Iterator<R> {
            Zip() {
            }

            @Override
            public boolean hasNext() {
                if (!it1.hasNext()) {
                    LazyFutureStreamFunctions.close(it2);
                }
                if (!it2.hasNext()) {
                    LazyFutureStreamFunctions.close(it1);
                }
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next());
            }
        }
        return Seq.seq((Iterator)new Zip()).onClose(() -> {
            left.close();
            right.close();
        });
    }

    static void close(Iterator it) {
        if (it instanceof CloseableIterator) {
            ((CloseableIterator)it).close();
        }
    }

    static <T> Seq<T> limitWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return LazyFutureStreamFunctions.limitUntil(stream, predicate.negate());
    }

    static <T> Seq<T> limitUntil(Stream<T> stream, final Predicate<? super T> predicate) {
        final Iterator it = stream.iterator();
        class LimitUntil
        implements Iterator<T> {
            T next = NullValue.NULL;
            boolean test = false;

            LimitUntil() {
            }

            void test() {
                if (!this.test && this.next == NullValue.NULL && it.hasNext()) {
                    this.next = it.next();
                    this.test = predicate.test(this.next);
                    if (this.test) {
                        this.next = NullValue.NULL;
                        LazyFutureStreamFunctions.close(it);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                this.test();
                return this.next != NullValue.NULL;
            }

            @Override
            public T next() {
                if (this.next == NullValue.NULL) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.next = NullValue.NULL;
                }
            }
        }
        return Seq.seq((Iterator)new LimitUntil()).onClose(() -> stream.close());
    }
}

