/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.Matchables;
import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactories;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.internal.react.LazyFutureStreamImpl;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.stream.CloseableIterator;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.internal.react.stream.traits.future.operators.LazyFutureStreamUtils;
import com.aol.cyclops.internal.react.stream.traits.future.operators.OperationsOnFuturesImpl;
import com.aol.cyclops.internal.stream.LazyFutureStreamFutureOpterationsImpl;
import com.aol.cyclops.react.RetryBuilder;
import com.aol.cyclops.react.SimpleReactFailedStageException;
import com.aol.cyclops.react.ThreadPools;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import com.aol.cyclops.react.collectors.lazy.MaxActive;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.IterableFunctor;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.applicative.zipping.ApplyingZippingApplicativeBuilder;
import com.aol.cyclops.types.applicative.zipping.ZippingApplicativable;
import com.aol.cyclops.types.futurestream.ConfigurableStream;
import com.aol.cyclops.types.futurestream.LazyFutureStreamFunctions;
import com.aol.cyclops.types.futurestream.LazySimpleReactStream;
import com.aol.cyclops.types.futurestream.LazyStream;
import com.aol.cyclops.types.futurestream.LazyToQueue;
import com.aol.cyclops.types.futurestream.OperationsOnFutures;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.types.stream.HotStream;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.types.stream.reactive.FutureStreamSynchronousPublisher;
import com.aol.cyclops.util.stream.StreamUtils;
import com.aol.cyclops.util.stream.Streamable;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface LazyFutureStream<U>
extends Functor<U>,
Filterable<U>,
LazySimpleReactStream<U>,
LazyStream<U>,
ReactiveSeq<U>,
LazyToQueue<U>,
ConfigurableStream<U, FastFuture<U>>,
FutureStreamSynchronousPublisher<U> {
    @Override
    default public LazyFutureStream<U> filterNot(Predicate<? super U> fn) {
        return (LazyFutureStream)ReactiveSeq.super.filterNot(fn);
    }

    @Override
    default public LazyFutureStream<U> notNull() {
        return (LazyFutureStream)ReactiveSeq.super.notNull();
    }

    @Override
    default public <R> LazyFutureStream<R> trampoline(Function<? super U, ? extends Trampoline<? extends R>> mapper) {
        return (LazyFutureStream)ReactiveSeq.super.trampoline(mapper);
    }

    @Override
    default public <R> R foldRight(R identity, BiFunction<? super U, ? super R, ? extends R> accumulator) {
        return ReactiveSeq.super.foldRight(identity, accumulator);
    }

    @Override
    default public <R> ApplyingZippingApplicativeBuilder<U, R, ZippingApplicativable<R>> applicatives() {
        Streamable<U> streamable = this.toStreamable();
        return new ApplyingZippingApplicativeBuilder(streamable, streamable);
    }

    @Override
    default public <R> ZippingApplicativable<R> ap1(Function<? super U, ? extends R> fn) {
        Tuple2<ReactiveSeq<U>, ReactiveSeq<U>> dup = this.duplicateSequence();
        Streamable streamable = ((ReactiveSeq)dup.v1).toStreamable();
        return (ZippingApplicativable)new ApplyingZippingApplicativeBuilder(streamable, streamable).applicative(fn).ap((IterableFunctor)dup.v2);
    }

    @Override
    default public LazyFutureStream<Tuple2<U, Long>> elapsed() {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.stream()).elapsed());
    }

    @Override
    default public LazyFutureStream<U> combine(BiPredicate<? super U, ? super U> predicate, BinaryOperator<U> op) {
        return this.fromStream(StreamUtils.combine(this, predicate, op));
    }

    @Override
    default public LazyFutureStream<U> onEmptySwitch(Supplier<? extends Stream<U>> switchTo) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.stream()).onEmptySwitch(switchTo));
    }

    @Override
    default public <R1, R2, R> LazyFutureStream<R> forEach3(Function<? super U, ? extends BaseStream<R1, ?>> stream1, Function<? super U, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super U, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return this.fromStream(ReactiveSeq.fromStream(this.stream()).forEach3(stream1, stream2, yieldingFunction));
    }

    @Override
    default public <R1, R2, R> LazyFutureStream<R> forEach3(Function<? super U, ? extends BaseStream<R1, ?>> stream1, Function<? super U, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super U, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super U, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return this.fromStream(ReactiveSeq.fromStream(this.stream()).forEach3(stream1, stream2, filterFunction, yieldingFunction));
    }

    @Override
    default public <R1, R> LazyFutureStream<R> forEach2(Function<? super U, ? extends BaseStream<R1, ?>> stream1, Function<? super U, Function<? super R1, ? extends R>> yieldingFunction) {
        return this.fromStream(ReactiveSeq.fromStream(this.stream()).forEach2(stream1, yieldingFunction));
    }

    @Override
    default public <R1, R> LazyFutureStream<R> forEach2(Function<? super U, ? extends BaseStream<R1, ?>> stream1, Function<? super U, Function<? super R1, Boolean>> filterFunction, Function<? super U, Function<? super R1, ? extends R>> yieldingFunction) {
        return this.fromStream(ReactiveSeq.fromStream(this.stream()).forEach2(stream1, filterFunction, yieldingFunction));
    }

    @Override
    default public <R> LazyFutureStream<R> patternMatch(Function<Matchable.CheckValue1<U, R>, Matchable.CheckValue1<U, R>> case1, Supplier<? extends R> otherwise) {
        return this.map((T u) -> Matchables.supplier(() -> u).matches(case1, otherwise).get());
    }

    @Override
    default public LazyFutureStream<U> remove(U t) {
        return (LazyFutureStream)ReactiveSeq.super.remove(t);
    }

    @Override
    default public LazyFutureStream<U> subStream(int start, int end) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).subStream(start, end));
    }

    @Override
    default public LazyFutureStream<ReactiveSeq<U>> permutations() {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).permutations()));
    }

    @Override
    default public LazyFutureStream<ReactiveSeq<U>> combinations() {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).combinations()));
    }

    default public OperationsOnFutures<U> actOnFutures() {
        return new OperationsOnFuturesImpl(this);
    }

    @Override
    default public CloseableIterator<U> iterator() {
        return (CloseableIterator)LazySimpleReactStream.super.iterator();
    }

    @Override
    public Continueable getSubscription();

    @Override
    public <R> LazyFutureStream<R> withLastActive(LazyStreamWrapper<R> var1);

    @Override
    public LazyReact getSimpleReact();

    @Override
    default public void subscribe(Subscriber<? super U> s) {
        FutureStreamSynchronousPublisher.super.subscribe(s);
    }

    default public Iterator<Collection<U>> chunkLastReadIterator() {
        final Queue.QueueReader<Object> reader = new Queue.QueueReader<Object>(this.withQueueFactory(QueueFactories.unboundedQueue()).toQueue(q -> q.withTimeout(100).withTimeUnit(TimeUnit.MICROSECONDS)), null);
        class Chunker
        implements Iterator<Collection<U>> {
            volatile boolean open = true;

            Chunker() {
            }

            @Override
            public boolean hasNext() {
                return this.open && reader.isOpen();
            }

            @Override
            public Collection<U> next() {
                while (this.hasNext()) {
                    try {
                        return reader.drainToOrBlock();
                    }
                    catch (Queue.ClosedQueueException e) {
                        this.open = false;
                        return new ArrayList();
                    }
                    catch (Queue.QueueTimeoutException e) {
                        LockSupport.parkNanos(0L);
                    }
                }
                return new ArrayList();
            }
        }
        return new Chunker();
    }

    default public LazyFutureStream<Collection<U>> chunkSinceLastRead() {
        Queue<U> queue = this.withQueueFactory(QueueFactories.unboundedQueue()).toQueue();
        final Queue.QueueReader<Object> reader = new Queue.QueueReader<Object>(queue, null);
        class Chunker
        implements Iterator<Collection<U>> {
            Chunker() {
            }

            @Override
            public boolean hasNext() {
                return reader.isOpen();
            }

            @Override
            public Collection<U> next() {
                return reader.drainToOrBlock();
            }
        }
        Chunker chunker = new Chunker();
        Function fn = s -> () -> {
            try {
                return chunker.next();
            }
            catch (Queue.ClosedQueueException e) {
                throw new Queue.ClosedQueueException();
            }
        };
        return this.fromStream(queue.streamBatchNoTimeout(this.getSubscription(), fn));
    }

    @Override
    default public long count() {
        return ((LazyStreamWrapper)this.getLastActive()).stream().count();
    }

    @Override
    public LazyFutureStream<U> withTaskExecutor(Executor var1);

    @Override
    public LazyFutureStream<U> withRetrier(RetryExecutor var1);

    public LazyFutureStream<U> withLazyCollector(Supplier<LazyResultConsumer<U>> var1);

    @Override
    public LazyFutureStream<U> withQueueFactory(QueueFactory<U> var1);

    @Override
    public LazyFutureStream<U> withSubscription(Continueable var1);

    @Override
    public LazyFutureStream<U> withAsync(boolean var1);

    @Override
    default public void forEach(Consumer<? super U> c) {
        LazyStream.super.forEach(c);
    }

    @Override
    default public Queue<U> toQueue() {
        return LazyToQueue.super.toQueue();
    }

    @Override
    default public <T> T reduce(T identity, BiFunction<T, ? super U, T> accumulator) {
        return LazyStream.super.reduce(identity, accumulator, (a, b) -> a);
    }

    @Override
    default public U reduce(U identity, BinaryOperator<U> accumulator) {
        return LazyStream.super.reduce(identity, accumulator);
    }

    @Override
    default public <T> T reduce(T identity, BiFunction<T, ? super U, T> accumulator, BinaryOperator<T> combiner) {
        return LazyStream.super.reduce(identity, accumulator, combiner);
    }

    @Override
    default public Optional<U> reduce(BinaryOperator<U> accumulator) {
        return LazyStream.super.reduce(accumulator);
    }

    @Override
    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super U> accumulator, BiConsumer<R, R> combiner) {
        return LazyStream.super.collect(supplier, accumulator, combiner);
    }

    @Override
    default public LazyFutureStream<U> sync() {
        return this.withAsync(false);
    }

    @Override
    default public LazyFutureStream<U> async() {
        return this.withAsync(true);
    }

    default public LazyFutureStream<U> unboundedWaitFree() {
        return this.withQueueFactory(QueueFactories.unboundedNonBlockingQueue());
    }

    default public LazyFutureStream<U> boundedWaitFree(int size) {
        return this.withQueueFactory(QueueFactories.boundedNonBlockingQueue(size));
    }

    public LazyFutureStream<U> maxActive(int var1);

    @Override
    default public <R> LazyFutureStream<R> thenSync(Function<? super U, ? extends R> fn) {
        return (LazyFutureStream)LazySimpleReactStream.super.thenSync((Function)fn);
    }

    @Override
    default public LazyFutureStream<U> peekSync(Consumer<? super U> consumer) {
        return (LazyFutureStream)LazySimpleReactStream.super.peekSync((Consumer)consumer);
    }

    default public void closeAll() {
        this.getSubscription().closeAll();
    }

    default public HotStream<U> hotStream() {
        return StreamUtils.hotStream(this, this.getTaskExecutor());
    }

    @Override
    default public Optional<U> findFirst() {
        List results = this.run(Collectors.toList());
        if (results.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(results.get(0));
    }

    default public SimpleReactStream<U> convertToSimpleReact() {
        return new SimpleReact(this.getTaskExecutor()).withRetrier(this.getRetrier()).fromStream(((LazyStreamWrapper)this.getLastActive()).injectFutures().map((? super T f) -> {
            try {
                return CompletableFuture.completedFuture(f.join());
            }
            catch (Throwable t) {
                return new CompletableFuture().completeExceptionally(t);
            }
        }));
    }

    @Override
    default public <R> LazyFutureStream<R> map(Function<? super U, ? extends R> mapper) {
        return (LazyFutureStream)LazySimpleReactStream.super.then((Function)mapper);
    }

    default public <K> Map<K, LazyFutureStream<U>> shard(Map<K, Queue<U>> shards, Function<? super U, ? extends K> sharder) {
        this.toQueue(shards, sharder);
        Map<Object, LazyFutureStream> res = shards.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> this.fromStream((Stream)((Queue)e.getValue()).stream(this.getSubscription()))));
        return res;
    }

    @Override
    default public LazyFutureStream<U> debounce(long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).debounce(time, unit));
    }

    default public LazyFutureStream<U> control(Function<Supplier<U>, Supplier<U>> fn) {
        Queue<U> queue = this.toQueue();
        return this.fromStream(queue.streamControl(this.getSubscription(), fn));
    }

    default public <C extends Collection<U>> LazyFutureStream<C> group(Function<Supplier<U>, Supplier<C>> fn) {
        Queue<U> queue = this.toQueue();
        return this.fromStream(queue.streamBatchNoTimeout(this.getSubscription(), fn));
    }

    @Override
    default public LazyFutureStream<ListX<U>> groupedBySizeAndTime(int size, long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedBySizeAndTime(size, time, unit));
    }

    @Override
    default public <C extends Collection<? super U>> LazyFutureStream<C> grouped(int size, Supplier<C> supplier) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).grouped(size, (Supplier)supplier)));
    }

    @Override
    default public LazyFutureStream<U> jitter(long jitterInNanos) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).jitter(jitterInNanos));
    }

    @Override
    default public LazyFutureStream<U> fixedDelay(long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).fixedDelay(time, unit));
    }

    @Override
    default public LazyFutureStream<U> onePer(long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).onePer(time, unit));
    }

    @Override
    default public LazyFutureStream<U> xPer(int x, long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).xPer(x, time, unit));
    }

    @Override
    default public LazyFutureStream<ListX<U>> groupedByTime(long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedByTime(time, unit));
    }

    @Override
    default public <C extends Collection<? super U>> LazyFutureStream<C> groupedByTime(long time, TimeUnit unit, Supplier<C> factory2) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedByTime(time, unit, factory2));
    }

    @Override
    default public <R> LazyFutureStream<R> then(Function<? super U, ? extends R> fn, Executor service) {
        return (LazyFutureStream)LazySimpleReactStream.super.then((Function)fn, service);
    }

    @Override
    default public <R> LazyFutureStream<R> then(Function<? super U, ? extends R> fn) {
        return (LazyFutureStream)LazySimpleReactStream.super.then((Function)fn);
    }

    default public List<LazyFutureStream<U>> copy(int times) {
        return LazySimpleReactStream.super.copySimpleReactStream(times);
    }

    default public <R> LazyFutureStream<R> switchOnNextValue(Stream<LazyFutureStream> streams) {
        Queue queue = Queue.createMergeQueue();
        this.addToQueue(queue);
        streams.forEach((? super T s) -> s.addToQueue(queue));
        return this.fromStream((Stream)queue.stream(this.getSubscription()));
    }

    default public <R> LazyFutureStream<R> mergeLatest(LazyFutureStream<?> ... streams) {
        Queue queue = Queue.createMergeQueue();
        this.addToQueue(queue);
        Seq.of((Object[])streams).forEach(s -> s.addToQueue(queue));
        return this.fromStream((Stream)queue.stream(this.getSubscription()));
    }

    @Override
    default public LazyFutureStream<U> onFail(Function<? super SimpleReactFailedStageException, ? extends U> fn) {
        return (LazyFutureStream)LazySimpleReactStream.super.onFail((Function)fn);
    }

    @Override
    default public LazyFutureStream<U> onFail(Class<? extends Throwable> exceptionClass, Function<? super SimpleReactFailedStageException, ? extends U> fn) {
        return (LazyFutureStream)LazySimpleReactStream.super.onFail((Class)exceptionClass, (Function)fn);
    }

    @Override
    default public LazyFutureStream<U> capture(Consumer<Throwable> errorHandler) {
        return (LazyFutureStream)LazySimpleReactStream.super.capture((Consumer)errorHandler);
    }

    @Override
    default public LazyFutureStream<U> peek(Consumer<? super U> consumer) {
        return (LazyFutureStream)LazySimpleReactStream.super.peek((Consumer)consumer);
    }

    @Override
    default public LazyFutureStream<U> filter(Predicate<? super U> p) {
        return (LazyFutureStream)LazySimpleReactStream.super.filter((Predicate)p);
    }

    @Override
    default public <R> LazyFutureStream<R> flatMap(Function<? super U, ? extends Stream<? extends R>> flatFn) {
        return (LazyFutureStream)LazySimpleReactStream.super.flatMap((Function)flatFn);
    }

    @Override
    default public <R> LazyFutureStream<R> flatMapAnyM(Function<? super U, AnyM<? extends R>> flatFn) {
        return (LazyFutureStream)LazySimpleReactStream.super.flatMap(flatFn.andThen(anyM -> anyM.stream()));
    }

    default public <R> LazyFutureStream<R> flatMapCompletableFuture(Function<? super U, CompletableFuture<? extends R>> flatFn) {
        return this.fromStream(StreamUtils.flatMapCompletableFuture(this.toQueue().stream(this.getSubscription()), flatFn));
    }

    @Override
    default public <R> LazyFutureStream<R> retry(Function<? super U, ? extends R> fn) {
        return (LazyFutureStream)LazySimpleReactStream.super.retry((Function)fn);
    }

    @Override
    default public <R> LazyFutureStream<R> fromStream(Stream<R> stream) {
        return this.withLastActive((LazyStreamWrapper)((LazyStreamWrapper)this.getLastActive()).withNewStream(stream, this.getSimpleReact()));
    }

    default public <R> LazyFutureStream<R> fromStreamOfFutures(Stream<FastFuture<R>> stream) {
        return this.withLastActive(((LazyStreamWrapper)this.getLastActive()).withNewStreamFutures(stream.map((? super T f) -> f.toCompletableFuture())));
    }

    @Override
    default public LazyFutureStream<U> concat(Stream<? extends U> other) {
        return this.fromStream(Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false), StreamSupport.stream(Spliterators.spliteratorUnknownSize(other.iterator(), 16), false)));
    }

    @Override
    default public LazyFutureStream<U> concat(U other) {
        return this.concat(Stream.of(other));
    }

    @Override
    default public LazyFutureStream<U> concat(U ... other) {
        return this.concat(Stream.of(other));
    }

    @Override
    default public <U> LazyFutureStream<U> cast(Class<? extends U> type) {
        return (LazyFutureStream)LazySimpleReactStream.super.cast(type);
    }

    @Override
    default public <U> LazyFutureStream<U> ofType(Class<? extends U> type) {
        return (LazyFutureStream)LazySimpleReactStream.super.ofType(type);
    }

    @Override
    default public LazyFutureStream<U> intersperse(U value) {
        return (LazyFutureStream)LazySimpleReactStream.super.intersperse(value);
    }

    @Override
    default public LazyFutureStream<U> limit(long maxSize) {
        Continueable sub = this.getSubscription();
        sub.registerLimit(maxSize);
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(sub)).limit(maxSize));
    }

    @Override
    default public LazyFutureStream<U> takeWhile(Predicate<? super U> p) {
        return this.limitWhile((Predicate)p);
    }

    @Override
    default public LazyFutureStream<U> dropWhile(Predicate<? super U> p) {
        return this.skipWhile((Predicate)p);
    }

    @Override
    default public LazyFutureStream<U> takeUntil(Predicate<? super U> p) {
        return this.limitUntil((Predicate)p);
    }

    @Override
    default public LazyFutureStream<U> dropUntil(Predicate<? super U> p) {
        return this.skipUntil((Predicate)p);
    }

    @Override
    default public LazyFutureStream<U> dropRight(int num) {
        return this.skipLast(num);
    }

    @Override
    default public LazyFutureStream<U> takeRight(int num) {
        return this.limitLast(num);
    }

    @Override
    default public LazyFutureStream<U> skip(long n) {
        Continueable sub = this.getSubscription();
        sub.registerSkip(n);
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(sub)).skip(n));
    }

    @Override
    default public LazyFutureStream<U> distinct() {
        return this.fromStream(this.toQueue().stream(this.getSubscription()).distinct());
    }

    @Override
    default public LazyFutureStream<ListX<U>> sliding(int size) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).sliding(size)));
    }

    @Override
    default public LazyFutureStream<ListX<U>> sliding(int size, int increment) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).sliding(size, increment)));
    }

    default public Tuple2<Seq<U>, Seq<U>> duplicate() {
        return ReactiveSeq.super.duplicate();
    }

    default public Tuple2<LazyFutureStream<U>, LazyFutureStream<U>> duplicateFutureStream() {
        Tuple2<Seq<U>, Seq<U>> duplicated = this.duplicate();
        return new Tuple2((Object)this.fromStream((Stream)duplicated.v1), (Object)this.fromStream((Stream)duplicated.v2));
    }

    default public Tuple2<Seq<U>, Seq<U>> partition(Predicate<? super U> predicate) {
        return ReactiveSeq.super.partition(predicate);
    }

    default public Tuple2<LazyFutureStream<U>, LazyFutureStream<U>> partitionFutureStream(Predicate<? super U> predicate) {
        Tuple2<Seq<? super U>, Seq<? super U>> partition = this.partition(predicate);
        return new Tuple2((Object)this.fromStream((Stream)partition.v1), (Object)this.fromStream((Stream)partition.v2));
    }

    @Override
    default public LazyFutureStream<U> slice(long from, long to) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription()).slice(from, to)));
    }

    @Override
    default public LazyFutureStream<Tuple2<U, Long>> zipWithIndex() {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zipWithIndex());
    }

    @Override
    default public <T> LazyFutureStream<Tuple2<U, T>> zip(Seq<? extends T> other) {
        return this.fromStream((Stream)LazyFutureStreamFunctions.zip(this, other));
    }

    @Override
    default public <T, R> LazyFutureStream<R> zip(Seq<? extends T> other, BiFunction<? super U, ? super T, ? extends R> zipper) {
        return this.fromStream((Stream)LazyFutureStreamFunctions.zip(this, other, zipper));
    }

    @Override
    default public <T> LazyFutureStream<T> scanLeft(T seed, BiFunction<? super T, ? super U, ? extends T> function) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).scanLeft(seed, function));
    }

    @Override
    default public <R> LazyFutureStream<R> scanRight(R seed, BiFunction<? super U, ? super R, ? extends R> function) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).scanRight(seed, function));
    }

    @Override
    default public LazyFutureStream<U> scanRight(Monoid<U> monoid) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).scanRight((Monoid)monoid)));
    }

    @Override
    default public LazyFutureStream<U> reverse() {
        return this.fromStream(this.fromStream(this.toQueue().stream(this.getSubscription())).block().reverse().stream());
    }

    @Override
    default public LazyFutureStream<U> shuffle() {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).shuffle());
    }

    @Override
    default public LazyFutureStream<U> shuffle(Random random) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).shuffle(random));
    }

    @Override
    default public LazyFutureStream<U> skipWhile(Predicate<? super U> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).skipWhile(predicate));
    }

    @Override
    default public LazyFutureStream<U> skipUntil(Predicate<? super U> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).skipUntil(predicate));
    }

    @Override
    default public LazyFutureStream<U> limitWhile(Predicate<? super U> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).limitWhile(predicate));
    }

    @Override
    default public LazyFutureStream<U> limitUntil(Predicate<? super U> predicate) {
        return this.fromStream((Stream)LazyFutureStreamFunctions.limitUntil(this, predicate));
    }

    @Override
    default public <T> LazyFutureStream<Tuple2<U, T>> crossJoin(Stream<? extends T> other) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).crossJoin(other));
    }

    @Override
    default public LazyFutureStream<U> onEmpty(U value) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).onEmpty((Object)value));
    }

    @Override
    default public LazyFutureStream<U> onEmptyGet(Supplier<? extends U> supplier) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).onEmptyGet(supplier));
    }

    @Override
    default public <X extends Throwable> LazyFutureStream<U> onEmptyThrow(Supplier<? extends X> supplier) {
        return this.fromStream((Stream)ReactiveSeq.super.onEmptyThrow((Supplier)supplier));
    }

    @Override
    default public <T> LazyFutureStream<Tuple2<U, T>> innerJoin(Stream<? extends T> other, BiPredicate<? super U, ? super T> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).innerJoin(other, (BiPredicate)predicate));
    }

    @Override
    default public <T> LazyFutureStream<Tuple2<U, T>> leftOuterJoin(Stream<? extends T> other, BiPredicate<? super U, ? super T> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).leftOuterJoin(other, (BiPredicate)predicate));
    }

    @Override
    default public <T> LazyFutureStream<Tuple2<U, T>> rightOuterJoin(Stream<? extends T> other, BiPredicate<? super U, ? super T> predicate) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).rightOuterJoin(other, (BiPredicate)predicate));
    }

    @Override
    default public LazyFutureStream<U> cycle() {
        return this.fromStream(StreamUtils.cycle(this));
    }

    @Override
    default public LazyFutureStream<U> cycle(int times) {
        return this.fromStream(StreamUtils.cycle(times, Streamable.fromStream(this)));
    }

    @Override
    default public LazyFutureStream<U> cycleWhile(Predicate<? super U> predicate) {
        return this.cycle().limitWhile(predicate);
    }

    @Override
    default public LazyFutureStream<U> cycleUntil(Predicate<? super U> predicate) {
        return this.cycle().limitUntil(predicate);
    }

    @Override
    default public Foldable<U> foldable() {
        return this;
    }

    @Override
    default public ReactiveSeq<U> stream() {
        return this.toQueue().stream(this.getSubscription());
    }

    @Override
    default public LazyFutureStream<U> parallel() {
        return this.withAsync(true).withTaskExecutor(LazyReact.parallelBuilder().getExecutor());
    }

    @Override
    default public LazyFutureStream<U> sequential() {
        return this.withAsync(false).withTaskExecutor(LazyReact.sequentialBuilder().getExecutor());
    }

    @Override
    default public LazyFutureStream<U> unordered() {
        return this;
    }

    @Override
    default public LazyFutureStream<U> onClose(Runnable closeHandler) {
        ((LazyStreamWrapper)this.getLastActive()).stream().onClose(closeHandler);
        return this;
    }

    @Override
    default public LazyFutureStream<U> sorted() {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).sorted());
    }

    @Override
    default public LazyFutureStream<U> sorted(Comparator<? super U> comparator) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).sorted(comparator));
    }

    default public LazyFutureStream<U> self(Consumer<LazyFutureStream<U>> consumer) {
        return this.then((T t) -> {
            consumer.accept(this);
            return t;
        });
    }

    @Override
    default public <R> R unwrap() {
        return (R)this;
    }

    @Override
    default public <T1> LazyFutureStream<T1> flatten() {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).flatten());
    }

    @Override
    default public Optional<ListX<U>> toOptional() {
        return Optional.of(this.block()).flatMap((? super T list) -> list.size() == 0 ? Optional.empty() : Optional.of(list));
    }

    @Override
    default public CompletableFuture<ListX<U>> toCompletableFuture() {
        return CompletableFuture.completedFuture(this).thenApplyAsync(s -> s.block(), this.getTaskExecutor());
    }

    @Override
    default public Spliterator<U> spliterator() {
        return this.stream().spliterator();
    }

    @Override
    default public boolean isParallel() {
        return false;
    }

    @Override
    default public IntStream mapToInt(ToIntFunction<? super U> mapper) {
        return this.stream().mapToInt(mapper);
    }

    @Override
    default public LongStream mapToLong(ToLongFunction<? super U> mapper) {
        return this.stream().mapToLong(mapper);
    }

    @Override
    default public DoubleStream mapToDouble(ToDoubleFunction<? super U> mapper) {
        return this.stream().mapToDouble(mapper);
    }

    @Override
    default public IntStream flatMapToInt(Function<? super U, ? extends IntStream> mapper) {
        return this.stream().flatMapToInt(mapper);
    }

    @Override
    default public LongStream flatMapToLong(Function<? super U, ? extends LongStream> mapper) {
        return this.stream().flatMapToLong(mapper);
    }

    @Override
    default public DoubleStream flatMapToDouble(Function<? super U, ? extends DoubleStream> mapper) {
        return this.stream().flatMapToDouble(mapper);
    }

    @Override
    default public void forEachOrdered(Consumer<? super U> action) {
        this.stream().forEachOrdered(action);
    }

    @Override
    default public Object[] toArray() {
        return this.stream().toArray();
    }

    @Override
    default public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream().toArray(generator);
    }

    @Override
    default public Optional<U> findAny() {
        return ReactiveSeq.fromStream(this.stream()).findAny();
    }

    @Override
    default public Set<U> toSet() {
        return this.collect(Collectors.toSet());
    }

    @Override
    default public List<U> toList() {
        return this.collect(Collectors.toList());
    }

    @Override
    default public <C extends Collection<U>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.collect(Collectors.toCollection(collectionFactory)));
    }

    @Override
    default public <R> ReactiveSeq<U> distinct(Function<? super U, ? extends R> keyExtractor) {
        return ReactiveSeq.fromStream(this.stream()).distinct();
    }

    @Override
    default public Tuple2<ReactiveSeq<U>, ReactiveSeq<U>> duplicateSequence() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).duplicateSequence();
    }

    @Override
    default public Tuple3<ReactiveSeq<U>, ReactiveSeq<U>, ReactiveSeq<U>> triplicate() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).triplicate();
    }

    @Override
    default public Tuple4<ReactiveSeq<U>, ReactiveSeq<U>, ReactiveSeq<U>, ReactiveSeq<U>> quadruplicate() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).quadruplicate();
    }

    @Override
    default public Tuple2<Optional<U>, ReactiveSeq<U>> splitSequenceAtHead() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).splitSequenceAtHead();
    }

    @Override
    default public Tuple2<ReactiveSeq<U>, ReactiveSeq<U>> splitAt(int where) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).splitAt(where);
    }

    @Override
    default public Tuple2<ReactiveSeq<U>, ReactiveSeq<U>> splitBy(Predicate<U> splitter) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).splitBy(splitter);
    }

    @Override
    default public Tuple2<ReactiveSeq<U>, ReactiveSeq<U>> partitionSequence(Predicate<U> splitter) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).partitionSequence(splitter);
    }

    @Override
    default public LazyFutureStream<U> cycle(Monoid<U> m, int times) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).cycle((Monoid)m, times)));
    }

    @Override
    default public <R> LazyFutureStream<Tuple2<U, R>> zipStream(Stream<? extends R> other) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zipStream(other)));
    }

    @Override
    default public <S, R> LazyFutureStream<Tuple3<U, S, R>> zip3(Stream<? extends S> second, Stream<? extends R> third) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zip3(second, third)));
    }

    @Override
    default public <T2, T3, T4> LazyFutureStream<Tuple4<U, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zip4((Stream)second, (Stream)third, (Stream)fourth)));
    }

    @Override
    default public <S, R> LazyFutureStream<R> zipSequence(ReactiveSeq<? extends S> second, BiFunction<? super U, ? super S, ? extends R> zipper) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zipSequence(second, zipper));
    }

    @Override
    default public <S, R> LazyFutureStream<R> zipAnyM(AnyM<? extends S> second, BiFunction<? super U, ? super S, ? extends R> zipper) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zipAnyM(second, zipper));
    }

    @Override
    default public <S, R> LazyFutureStream<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super U, ? super S, ? extends R> zipper) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).zipStream(second, zipper));
    }

    @Override
    default public LazyFutureStream<ListX<U>> grouped(int groupSize) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).grouped(groupSize)));
    }

    @Override
    default public LazyFutureStream<U> scanLeft(Monoid<U> monoid) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).scanLeft((Monoid)monoid)));
    }

    @Override
    default public Streamable<U> toStreamable() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).toStreamable();
    }

    @Override
    default public <U> Stream<U> toStream() {
        return this.toQueue().stream(this.getSubscription());
    }

    @Override
    default public boolean startsWithIterable(Iterable<U> iterable) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).startsWithIterable(iterable);
    }

    @Override
    default public boolean startsWith(Stream<U> iterator) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).startsWith(iterator);
    }

    @Override
    default public boolean endsWithIterable(Iterable<U> iterable) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).endsWithIterable(iterable);
    }

    @Override
    default public boolean endsWith(Stream<U> stream) {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).endsWith(stream);
    }

    @Override
    default public AnyMSeq<U> anyM() {
        return AnyM.fromStream(this);
    }

    @Override
    default public <R> LazyFutureStream<R> flatMapIterable(Function<? super U, ? extends Iterable<? extends R>> fn) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).flatMapIterable(fn));
    }

    @Override
    default public <R> LazyFutureStream<R> flatMapStream(Function<? super U, BaseStream<? extends R, ?>> fn) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).flatMapStream(fn));
    }

    @Override
    default public CollectionX<U> toLazyCollection() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).toLazyCollection();
    }

    @Override
    default public CollectionX<U> toConcurrentLazyCollection() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).toConcurrentLazyCollection();
    }

    @Override
    default public Streamable<U> toConcurrentLazyStreamable() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).toConcurrentLazyStreamable();
    }

    @Override
    default public LazyFutureStream<U> appendStream(Stream<U> stream) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).appendStream(stream));
    }

    @Override
    default public LazyFutureStream<U> prependStream(Stream<U> stream) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).prependStream(stream));
    }

    @Override
    default public LazyFutureStream<U> append(U ... values) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).append(values));
    }

    @Override
    default public LazyFutureStream<U> prepend(U ... values) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).prepend(values));
    }

    @Override
    default public LazyFutureStream<U> insertAt(int pos, U ... values) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).insertAt(pos, values));
    }

    @Override
    default public LazyFutureStream<U> deleteBetween(int start, int end) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).deleteBetween(start, end));
    }

    @Override
    default public LazyFutureStream<U> insertStreamAt(int pos, Stream<U> stream) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).insertStreamAt(pos, stream));
    }

    default public FutureOperations<U> futureOperations() {
        return new LazyFutureStreamFutureOpterationsImpl(this.getTaskExecutor(), this);
    }

    @Override
    default public FutureOperations<U> futureOperations(Executor exec) {
        return new LazyFutureStreamFutureOpterationsImpl(exec, this);
    }

    @Override
    default public LazyFutureStream<U> skip(long time, TimeUnit unit) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).skip(time, unit));
    }

    @Override
    default public LazyFutureStream<U> limit(long time, TimeUnit unit) {
        this.getSubscription().registerTimeLimit(unit.toNanos(time));
        return this.fromStream(this.toQueue().stream(this.getSubscription()).limit(time, unit));
    }

    @Override
    default public LazyFutureStream<U> skipLast(int num) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).skipLast(num)));
    }

    @Override
    default public LazyFutureStream<U> limitLast(int num) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).limitLast(num)));
    }

    @Override
    default public U firstValue() {
        return ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).firstValue();
    }

    @Override
    default public <C extends Collection<? super U>> LazyFutureStream<C> groupedBySizeAndTime(int size, long time, TimeUnit unit, Supplier<C> factory2) {
        return this.fromStream(ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedBySizeAndTime(size, time, unit, factory2));
    }

    @Override
    default public LazyFutureStream<ListX<U>> groupedStatefullyWhile(BiPredicate<ListX<? super U>, ? super U> predicate) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedStatefullyWhile(predicate)));
    }

    @Override
    default public LazyFutureStream<ListX<U>> groupedUntil(Predicate<? super U> predicate) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedUntil(predicate)));
    }

    @Override
    default public LazyFutureStream<ListX<U>> groupedWhile(Predicate<? super U> predicate) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedWhile(predicate)));
    }

    @Override
    default public <C extends Collection<? super U>> LazyFutureStream<C> groupedWhile(Predicate<? super U> predicate, Supplier<C> factory2) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedWhile(predicate, (Supplier)factory2)));
    }

    @Override
    default public <R extends Comparable<? super R>> LazyFutureStream<U> sorted(Function<? super U, ? extends R> function) {
        return this.fromStream((Stream)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).sorted(function));
    }

    @Override
    default public <C extends Collection<? super U>> LazyFutureStream<C> groupedUntil(Predicate<? super U> predicate, Supplier<C> factory2) {
        return this.fromStream((Stream)((Object)ReactiveSeq.fromStream(this.toQueue().stream(this.getSubscription())).groupedUntil(predicate, (Supplier)factory2)));
    }

    @Override
    default public LazyFutureStream<U> recover(Function<Throwable, ? extends U> fn) {
        return this.onFail((T e) -> fn.apply(e.getCause()));
    }

    @Override
    default public <EX extends Throwable> LazyFutureStream<U> recover(Class<EX> exceptionClass, Function<EX, ? extends U> fn) {
        return this.onFail(exceptionClass, (T e) -> fn.apply(e.getCause()));
    }

    @Override
    default public <X extends Throwable> Subscription forEachX(long numberOfElements, Consumer<? super U> consumer) {
        Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> t2 = LazyFutureStreamUtils.forEachX(this, numberOfElements, consumer);
        ((Runnable)t2.v2).run();
        return (Subscription)((CompletableFuture)t2.v1).join();
    }

    @Override
    default public <X extends Throwable> Subscription forEachXWithError(long numberOfElements, Consumer<? super U> consumer, Consumer<? super Throwable> consumerError) {
        Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> t2 = LazyFutureStreamUtils.forEachXWithError(this, numberOfElements, consumer, consumerError);
        ((Runnable)t2.v2).run();
        return (Subscription)((CompletableFuture)t2.v1).join();
    }

    @Override
    default public <X extends Throwable> Subscription forEachXEvents(long numberOfElements, Consumer<? super U> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> t2 = LazyFutureStreamUtils.forEachXEvents(this, numberOfElements, consumer, consumerError, onComplete);
        ((Runnable)t2.v2).run();
        return (Subscription)((CompletableFuture)t2.v1).join();
    }

    @Override
    default public <X extends Throwable> void forEachWithError(Consumer<? super U> consumerElement, Consumer<? super Throwable> consumerError) {
        Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> t2 = LazyFutureStreamUtils.forEachWithError(this, consumerElement, consumerError);
        ((Runnable)t2.v2).run();
    }

    @Override
    default public <X extends Throwable> void forEachEvent(Consumer<? super U> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> t2 = LazyFutureStreamUtils.forEachEvent(this, consumerElement, consumerError, onComplete);
        ((Runnable)t2.v2).run();
    }

    public static <U> LazyFutureStream<U> parallel(U ... array) {
        return LazyReact.parallelCommonBuilder().of(array);
    }

    public static <T> LazyFutureStream<T> lazyFutureStreamFrom(Stream<CompletableFuture<T>> stream) {
        return new LazyReact(ThreadPools.getSequential()).withRetrier((RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry())).withAsync(false).fromStreamFutures(stream);
    }

    public static <T> LazyFutureStream<T> lazyFutureStream(CompletableFuture<T> value) {
        return new LazyReact(ThreadPools.getSequential()).withRetrier((RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry())).withAsync(false).fromStreamFutures(Stream.of(value));
    }

    public static <T> LazyFutureStream<T> lazyFutureStream(CompletableFuture<T> ... values) {
        return new LazyReact(ThreadPools.getSequential()).withRetrier((RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry())).withAsync(false).fromStreamFutures(Stream.of(values));
    }

    public static <T> LazyFutureStream<T> react(Supplier<T> value) {
        return new LazyReact(ThreadPools.getSequential()).withRetrier((RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry())).withAsync(false).ofAsync(value);
    }

    @SafeVarargs
    public static <T> LazyFutureStream<T> react(Supplier<T> ... values) {
        return new LazyReact(ThreadPools.getSequential()).withRetrier((RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry())).withAsync(false).ofAsync(values);
    }

    public static <T> LazyFutureStream<T> of(T value) {
        return LazyFutureStream.lazyFutureStream(Seq.of(value));
    }

    @SafeVarargs
    public static <T> LazyFutureStream<T> of(T ... values) {
        return LazyFutureStream.lazyFutureStream(Seq.of((Object[])values));
    }

    public static <T> LazyFutureStream<T> freeThread(T value) {
        return LazyFutureStream.freeThread(new Object[]{value});
    }

    @SafeVarargs
    public static <T> LazyFutureStream<T> freeThread(T ... values) {
        LazyReact react = new LazyReact(ThreadPools.getSequential(), RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getSequentialRetry()), false, new MaxActive(1, 1));
        return new LazyFutureStreamImpl<T>(react, Stream.of(values));
    }

    public static <T> LazyFutureStream<T> empty() {
        return LazyFutureStream.lazyFutureStream(Seq.empty());
    }

    public static <T> LazyFutureStream<T> iterate(T seed, UnaryOperator<T> f) {
        return LazyFutureStream.lazyFutureStream(Seq.iterate(seed, f));
    }

    public static LazyFutureStream<Void> generate() {
        return LazyFutureStream.generate(() -> null);
    }

    public static <T> LazyFutureStream<T> generate(T value) {
        return LazyFutureStream.generate(() -> value);
    }

    public static <T> LazyFutureStream<T> generate(Supplier<T> s) {
        return LazyFutureStream.lazyFutureStream(Stream.generate(s));
    }

    public static <T> LazyFutureStream<T> lazyFutureStream(Stream<T> stream) {
        if (stream instanceof LazyFutureStream) {
            return (LazyFutureStream)stream;
        }
        if (stream instanceof LazyFutureStream) {
            stream = ((LazyFutureStream)stream).toQueue().stream(((LazyFutureStream)stream).getSubscription());
        }
        LazyReact react = new LazyReact(ThreadPools.getCurrentThreadExecutor(), RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getSequentialRetry()), false, new MaxActive(1, 1));
        return new LazyFutureStreamImpl<T>(react, stream);
    }

    public static <T> LazyFutureStream<T> lazyFutureStreamFromIterable(Iterable<T> iterable) {
        return LazyFutureStream.lazyFutureStream(iterable.iterator());
    }

    public static <T> LazyFutureStream<T> lazyFutureStream(Iterator<T> iterator) {
        return LazyFutureStream.lazyFutureStream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }
}

