/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.exceptions.FilteredExecutionPathException;
import com.aol.cyclops.internal.react.exceptions.SimpleReactCompletionException;
import com.aol.cyclops.internal.react.stream.EagerStreamWrapper;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.internal.react.stream.MissingValue;
import com.aol.cyclops.react.SimpleReactFailedStageException;
import com.aol.cyclops.types.futurestream.BlockingStream;
import com.aol.cyclops.types.futurestream.LazyStream;
import com.aol.cyclops.util.ExceptionSoftener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class BlockingStreamHelper {
    static <R> R block(BlockingStream blocking, Collector collector, EagerStreamWrapper lastActive) {
        Stream<CompletableFuture> stream = lastActive.stream();
        return stream.map(future -> BlockingStreamHelper.getSafe(future, blocking.getErrorHandler())).filter(v -> v != MissingValue.MISSING_VALUE).collect(collector);
    }

    static <R> R block(BlockingStream blocking, Collector collector, LazyStreamWrapper lastActive) {
        return ((LazyStream)blocking).run(collector);
    }

    static <R> R aggregateResults(Collector collector, List<FastFuture> completedFutures, Optional<Consumer<Throwable>> errorHandler) {
        return completedFutures.stream().map(next -> BlockingStreamHelper.getSafe(next, errorHandler)).filter(v -> v != MissingValue.MISSING_VALUE).collect(collector);
    }

    static <R> R aggregateResultsCompletable(Collector collector, List<CompletableFuture> completedFutures, Optional<Consumer<Throwable>> errorHandler) {
        return completedFutures.stream().map(next -> BlockingStreamHelper.getSafe(next, errorHandler)).filter(v -> v != MissingValue.MISSING_VALUE).collect(collector);
    }

    public static void captureUnwrap(Throwable e, Optional<Consumer<Throwable>> errorHandler) {
        if (e instanceof SimpleReactFailedStageException) {
            BlockingStreamHelper.captureFailedStage((SimpleReactFailedStageException)e, errorHandler);
        } else if (e.getCause() != null) {
            BlockingStreamHelper.capture(e.getCause(), errorHandler);
        } else {
            BlockingStreamHelper.captureGeneral(e, errorHandler);
        }
    }

    static void capture(Throwable t, Optional<Consumer<Throwable>> errorHandler) {
        SimpleReactFailedStageException.matchable(t).visit(general -> BlockingStreamHelper.captureGeneral(general, errorHandler), sr -> BlockingStreamHelper.captureFailedStage(sr, errorHandler));
    }

    static Void captureFailedStage(SimpleReactFailedStageException e, Optional<Consumer<Throwable>> errorHandler) {
        errorHandler.ifPresent(handler -> {
            if (!(e.getCause() instanceof FilteredExecutionPathException)) {
                handler.accept(e.getCause());
            }
        });
        return null;
    }

    static Void captureGeneral(Throwable t, Optional<Consumer<Throwable>> errorHandler) {
        if (t instanceof FilteredExecutionPathException) {
            return null;
        }
        errorHandler.ifPresent(handler -> handler.accept(t));
        return null;
    }

    public static Object getSafe(FastFuture next, Optional<Consumer<Throwable>> errorHandler) {
        try {
            return next.join();
        }
        catch (SimpleReactCompletionException e) {
            BlockingStreamHelper.capture(e.getCause(), errorHandler);
        }
        catch (RuntimeException e) {
            BlockingStreamHelper.capture(e, errorHandler);
        }
        catch (Exception e) {
            BlockingStreamHelper.capture(e, errorHandler);
        }
        return MissingValue.MISSING_VALUE;
    }

    static Object getSafe(CompletableFuture next, Optional<Consumer<Throwable>> errorHandler) {
        try {
            return next.get();
        }
        catch (ExecutionException e) {
            BlockingStreamHelper.capture(e.getCause(), errorHandler);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            BlockingStreamHelper.capture(e, errorHandler);
            throw ExceptionSoftener.throwSoftenedException(e);
        }
        catch (RuntimeException e) {
            BlockingStreamHelper.capture(e, errorHandler);
        }
        catch (Exception e) {
            BlockingStreamHelper.capture(e, errorHandler);
        }
        return MissingValue.MISSING_VALUE;
    }
}

