/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.extensability;

import com.aol.cyclops.internal.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.internal.comprehensions.converters.MonadicConverters;
import com.aol.cyclops.internal.monads.ComprehenderSelector;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface Comprehender<T> {
    default public int priority() {
        return 5;
    }

    default public T unwrap(Object o) {
        return (T)o;
    }

    default public Object filter(T t, Predicate p) {
        return this.flatMap(t, d -> p.test(d) ? this.of(d) : this.empty());
    }

    public Object map(T var1, Function var2);

    default public Object liftAndFlatMap(T t, Function fn) {
        return this.executeflatMap(t, input -> Comprehender.liftObject(this, fn.apply(input)));
    }

    default public Object executeflatMap(T t, Function fn) {
        return this.flatMap(t, input -> Comprehender.unwrapOtherMonadTypes(this, fn.apply(input)));
    }

    public Object flatMap(T var1, Function var2);

    default public boolean instanceOfT(Object apply) {
        return this.getTargetClass().isAssignableFrom(apply.getClass());
    }

    public T of(Object var1);

    public T fromIterator(Iterator var1);

    public T empty();

    public static Object liftObject(Comprehender comp, Object apply) {
        Object o = new MonadicConverters().convertToMonadicForm(apply);
        return o;
    }

    public static <T> T unwrapOtherMonadTypes(Comprehender<T> comp, Object apply) {
        if (comp.instanceOfT(apply)) {
            return (T)apply;
        }
        if (apply instanceof Stream) {
            return comp.of(((Stream)apply).collect(Collectors.toCollection(MaterializedList::new)));
        }
        if (apply instanceof IntStream) {
            return comp.of(((IntStream)apply).boxed().collect(Collectors.toCollection(MaterializedList::new)));
        }
        if (apply instanceof DoubleStream) {
            return comp.of(((DoubleStream)apply).boxed().collect(Collectors.toCollection(MaterializedList::new)));
        }
        if (apply instanceof LongStream) {
            return comp.of(((LongStream)apply).boxed().collect(Collectors.toCollection(MaterializedList::new)));
        }
        if (apply instanceof CompletableFuture) {
            try {
                return comp.of(((CompletableFuture)apply).join());
            }
            catch (Throwable t) {
                return comp.empty();
            }
        }
        return (T)new ComprehenderSelector().selectComprehender(apply).resolveForCrossTypeFlatMap(comp, apply);
    }

    default public Object resolveForCrossTypeFlatMap(Comprehender comp, T apply) {
        return comp.of(apply);
    }

    public Class getTargetClass();
}

