/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;

public class ThreadPools {
    private static final Executor commonFreeThread = Executors.newFixedThreadPool(1);
    private static final Executor currentThreadExecutor = r -> r.run();
    private static final Executor queueCopyExecutor = Executors.newFixedThreadPool(1);
    private static final Executor commonLazyExecutor = new ForkJoinPool(1);
    private static final ScheduledExecutorService commonFreeThreadRetry = Executors.newScheduledThreadPool(1);
    private static final ScheduledExecutorService commonStanardRetry = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static volatile boolean useCommon = true;

    public static Executor getStandard() {
        if (useCommon) {
            return ForkJoinPool.commonPool();
        }
        return new ForkJoinPool(Runtime.getRuntime().availableProcessors());
    }

    public static Executor getSequential() {
        if (useCommon) {
            return commonFreeThread;
        }
        return new ForkJoinPool(1);
    }

    public static ScheduledExecutorService getSequentialRetry() {
        if (useCommon) {
            return commonFreeThreadRetry;
        }
        return Executors.newScheduledThreadPool(1);
    }

    public static ScheduledExecutorService getStandardRetry() {
        if (useCommon) {
            return commonStanardRetry;
        }
        return Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public static Executor getLazyExecutor() {
        if (useCommon) {
            return commonLazyExecutor;
        }
        return new ForkJoinPool(1);
    }

    public static boolean isUseCommon() {
        return useCommon;
    }

    public static void setUseCommon(boolean useCommon) {
        ThreadPools.useCommon = useCommon;
    }

    public static Executor getCommonFreeThread() {
        return commonFreeThread;
    }

    public static Executor getCurrentThreadExecutor() {
        return currentThreadExecutor;
    }

    public static Executor getQueueCopyExecutor() {
        return queueCopyExecutor;
    }

    public static Executor getCommonLazyExecutor() {
        return commonLazyExecutor;
    }

    public static ScheduledExecutorService getCommonFreeThreadRetry() {
        return commonFreeThreadRetry;
    }

    public static ScheduledExecutorService getCommonStanardRetry() {
        return commonStanardRetry;
    }

    public static enum ExecutionMode {
        CURRENT,
        COMMON_FREE,
        NEW_FREE;

    }
}

