/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.spliterators;

import com.aol.cyclops.internal.stream.spliterators.ReversableSpliterator;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongConsumer;

public class ReversingRangeLongSpliterator
implements Spliterator.OfLong,
ReversableSpliterator {
    private long index;
    private final long min;
    private final long max;
    private boolean reverse;

    public ReversingRangeLongSpliterator(long min, long max, boolean reverse) {
        this.min = Math.min(min, max) - 1L;
        this.max = Math.max(min, max);
        this.reverse = this.max >= this.min ? reverse : !reverse;
        this.index = Math.min(min, max);
    }

    @Override
    public ReversableSpliterator invert() {
        this.setReverse(!this.isReverse());
        this.index = this.max - 1L;
        return this;
    }

    @Override
    public boolean tryAdvance(LongConsumer consumer) {
        Objects.requireNonNull(consumer);
        if (!this.reverse && this.index < this.max && this.index > this.min) {
            consumer.accept(this.index++);
            return true;
        }
        if (this.reverse && this.index > this.min && this.index < this.max) {
            consumer.accept(this.index--);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.max;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public Spliterator.OfLong trySplit() {
        return this;
    }

    @Override
    public ReversableSpliterator copy() {
        return new ReversingRangeLongSpliterator(this.index, this.max, this.reverse);
    }

    @ConstructorProperties(value={"index", "min", "max", "reverse"})
    public ReversingRangeLongSpliterator(long index, long min, long max, boolean reverse) {
        this.index = index;
        this.min = min;
        this.max = max;
        this.reverse = reverse;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

