/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class LimitWhileTimeOperator<U> {
    private final Stream<U> stream;

    public Stream<U> limitWhile(long time, TimeUnit unit) {
        final Iterator it = this.stream.iterator();
        final long start = System.nanoTime();
        final long allowed = unit.toNanos(time);
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean stillGoing = true;

            @Override
            public boolean hasNext() {
                boolean bl = this.stillGoing = System.nanoTime() - start < allowed;
                if (!this.stillGoing) {
                    return false;
                }
                return it.hasNext();
            }

            @Override
            public U next() {
                if (!this.stillGoing) {
                    throw new NoSuchElementException();
                }
                Object val2 = it.next();
                this.stillGoing = System.nanoTime() - start < allowed;
                return val2;
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public LimitWhileTimeOperator(Stream<U> stream) {
        this.stream = stream;
    }
}

