/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class DebounceOperator<T> {
    private final Stream<T> stream;
    private static final Object DEBOUNCED = new Object();

    public Stream<T> debounce(long time, TimeUnit t) {
        final Iterator it = this.stream.iterator();
        final long timeNanos = t.toNanos(time);
        return StreamUtils.stream(new Iterator<T>(){
            volatile long last = 0L;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                long elapsedNanos = 1L;
                Object nextValue = null;
                while (elapsedNanos > 0L && it.hasNext()) {
                    nextValue = it.next();
                    if (this.last == 0L) {
                        this.last = System.nanoTime();
                        return nextValue;
                    }
                    elapsedNanos = timeNanos - (System.nanoTime() - this.last);
                }
                this.last = System.nanoTime();
                if (it.hasNext()) {
                    return nextValue;
                }
                if (elapsedNanos <= 0L) {
                    return nextValue;
                }
                return DEBOUNCED;
            }
        }).filter(i -> i != DEBOUNCED);
    }

    @ConstructorProperties(value={"stream"})
    public DebounceOperator(Stream<T> stream) {
        this.stream = stream;
    }
}

