/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.react.async.subscription.Continueable;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class InfiniteClosingSpliteratorFromSupplier<T>
implements Spliterator<T> {
    private long estimate;
    final Supplier<T> it;
    private final Continueable subscription;

    public InfiniteClosingSpliteratorFromSupplier(long estimate, Supplier<T> it, Continueable subscription) {
        this.estimate = estimate;
        this.it = it;
        this.subscription = subscription;
    }

    @Override
    public long estimateSize() {
        return this.estimate;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        try {
            action.accept(this.it.get());
            return !this.subscription.closed();
        }
        catch (Queue.ClosedQueueException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return new InfiniteClosingSpliteratorFromSupplier<T>(this.estimate >>>= 1, this.it, this.subscription);
    }
}

