/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.SortedSetXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface SortedSetX<T>
extends SortedSet<T>,
MutableCollectionX<T> {
    public static <T> Collector<T, ?, SortedSet<T>> defaultCollector() {
        return Collectors.toCollection(() -> new TreeSet(Comparator.naturalOrder()));
    }

    public static <T> Collector<T, ?, SortedSet<T>> immutableCollector() {
        return Collectors.collectingAndThen(SortedSetX.defaultCollector(), d -> Collections.unmodifiableSortedSet(d));
    }

    public static <T> SortedSetX<T> empty() {
        return SortedSetX.fromIterable((SortedSet)SortedSetX.defaultCollector().supplier().get());
    }

    public static <T> SortedSetX<T> of(T ... values) {
        SortedSet res = (SortedSet)SortedSetX.defaultCollector().supplier().get();
        for (T v : values) {
            res.add(v);
        }
        return SortedSetX.fromIterable(res);
    }

    public static <T> SortedSetX<T> singleton(T value) {
        return SortedSetX.of(new Object[]{value});
    }

    public static <T> SortedSetX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toSortedSetX();
    }

    public static <T> SortedSetX<T> fromIterable(Iterable<T> it) {
        return SortedSetX.fromIterable(SortedSetX.defaultCollector(), it);
    }

    public static <T> SortedSetX<T> fromIterable(Collector<T, ?, SortedSet<T>> collector, Iterable<T> it) {
        if (it instanceof SortedSetX) {
            return (SortedSetX)it;
        }
        if (it instanceof SortedSet) {
            return new SortedSetXImpl<T>((SortedSet)it, collector);
        }
        return new SortedSetXImpl<T>(StreamUtils.stream(it).collect(collector), collector);
    }

    @Override
    default public SortedSetX<T> toSortedSetX() {
        return this;
    }

    @Override
    default public SortedSetX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (SortedSetX)MutableCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <R> SortedSetX<R> unit(R value) {
        return SortedSetX.singleton(value);
    }

    @Override
    default public <R> SortedSetX<R> unit(Collection<R> col) {
        return SortedSetX.fromIterable(col);
    }

    @Override
    default public <R> SortedSetX<R> unitIterator(Iterator<R> it) {
        return SortedSetX.fromIterable(() -> it);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public <T1> SortedSetX<T1> from(Collection<T1> c) {
        return SortedSetX.fromIterable(this.getCollector(), c);
    }

    public <T> Collector<T, ?, SortedSet<T>> getCollector();

    @Override
    default public <X> SortedSetX<X> fromStream(Stream<X> stream) {
        return new SortedSetXImpl<T>(stream.collect(this.getCollector()), this.getCollector());
    }

    @Override
    default public SortedSetX<T> reverse() {
        return (SortedSetX)MutableCollectionX.super.reverse();
    }

    @Override
    default public SortedSetX<T> filter(Predicate<? super T> pred) {
        return (SortedSetX)MutableCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> SortedSetX<R> map(Function<? super T, ? extends R> mapper) {
        return (SortedSetX)MutableCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> SortedSetX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (SortedSetX)MutableCollectionX.super.flatMap(mapper);
    }

    @Override
    default public SortedSetX<T> limit(long num) {
        return (SortedSetX)MutableCollectionX.super.limit(num);
    }

    @Override
    default public SortedSetX<T> skip(long num) {
        return (SortedSetX)MutableCollectionX.super.skip(num);
    }

    @Override
    default public SortedSetX<T> takeWhile(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public SortedSetX<T> dropWhile(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public SortedSetX<T> takeUntil(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public SortedSetX<T> dropUntil(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public SortedSetX<T> takeRight(int num) {
        return (SortedSetX)MutableCollectionX.super.takeRight(num);
    }

    @Override
    default public SortedSetX<T> dropRight(int num) {
        return (SortedSetX)MutableCollectionX.super.dropRight(num);
    }

    @Override
    default public <R> SortedSetX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (SortedSetX)MutableCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public SortedSetX<T> slice(long from, long to) {
        return (SortedSetX)MutableCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> SortedSetX<T> sorted(Function<? super T, ? extends U> function) {
        return (SortedSetX)MutableCollectionX.super.sorted((Function)function);
    }

    @Override
    default public SortedSetX<ListX<T>> grouped(int groupSize) {
        return (SortedSetX)MutableCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> SortedSetX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (SortedSetX)MutableCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> SortedSetX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return this.fromStream(this.stream().grouped(classifier).map((T t) -> t.map2(Comparables::comparable)));
    }

    @Override
    default public <U> SortedSetX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (SortedSetX)MutableCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> SortedSetX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (SortedSetX)MutableCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public SortedSetX<ListX<T>> sliding(int windowSize) {
        return (SortedSetX)MutableCollectionX.super.sliding(windowSize);
    }

    @Override
    default public SortedSetX<ListX<T>> sliding(int windowSize, int increment) {
        return (SortedSetX)MutableCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public SortedSetX<T> scanLeft(Monoid<T> monoid) {
        return (SortedSetX)MutableCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> SortedSetX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (SortedSetX)MutableCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public SortedSetX<T> scanRight(Monoid<T> monoid) {
        return (SortedSetX)MutableCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> SortedSetX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (SortedSetX)MutableCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public SortedSetX<T> plus(T e) {
        this.add(e);
        return this;
    }

    @Override
    default public SortedSetX<T> plusAll(Collection<? extends T> list) {
        this.addAll(list);
        return this;
    }

    @Override
    default public SortedSetX<T> minus(Object e) {
        this.remove(e);
        return this;
    }

    @Override
    default public SortedSetX<T> minusAll(Collection<?> list) {
        this.removeAll(list);
        return this;
    }

    @Override
    default public ListX<T> cycle(int times) {
        return this.stream().cycle(times).toListX();
    }

    @Override
    default public ListX<T> cycle(Monoid<T> m, int times) {
        return this.stream().cycle(m, times).toListX();
    }

    @Override
    default public ListX<T> cycleWhile(Predicate<? super T> predicate) {
        return this.stream().cycleWhile(predicate).toListX();
    }

    @Override
    default public ListX<T> cycleUntil(Predicate<? super T> predicate) {
        return this.stream().cycleUntil(predicate).toListX();
    }

    @Override
    default public <U> SortedSetX<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return (SortedSetX)MutableCollectionX.super.zipStream((Stream)other);
    }

    @Override
    default public <U> SortedSetX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (SortedSetX)MutableCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> SortedSetX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (SortedSetX)MutableCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> SortedSetX<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return (SortedSetX)MutableCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public SortedSetX<Tuple2<T, Long>> zipWithIndex() {
        return (SortedSetX)MutableCollectionX.super.zipWithIndex();
    }

    @Override
    default public SortedSetX<T> distinct() {
        return (SortedSetX)MutableCollectionX.super.distinct();
    }

    @Override
    default public SortedSetX<T> sorted() {
        return (SortedSetX)MutableCollectionX.super.sorted();
    }

    @Override
    default public SortedSetX<T> sorted(Comparator<? super T> c) {
        return (SortedSetX)MutableCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public SortedSetX<T> skipWhile(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public SortedSetX<T> skipUntil(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public SortedSetX<T> limitWhile(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public SortedSetX<T> limitUntil(Predicate<? super T> p) {
        return (SortedSetX)MutableCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public SortedSetX<T> intersperse(T value) {
        return (SortedSetX)MutableCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public SortedSetX<T> shuffle() {
        return (SortedSetX)MutableCollectionX.super.shuffle();
    }

    @Override
    default public SortedSetX<T> skipLast(int num) {
        return (SortedSetX)MutableCollectionX.super.skipLast(num);
    }

    @Override
    default public SortedSetX<T> limitLast(int num) {
        return (SortedSetX)MutableCollectionX.super.limitLast(num);
    }

    @Override
    default public SortedSetX<T> onEmpty(T value) {
        return (SortedSetX)MutableCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public SortedSetX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (SortedSetX)MutableCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> SortedSetX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (SortedSetX)MutableCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public SortedSetX<T> shuffle(Random random) {
        return (SortedSetX)MutableCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> SortedSetX<U> ofType(Class<? extends U> type) {
        return (SortedSetX)MutableCollectionX.super.ofType((Class)type);
    }

    @Override
    default public SortedSetX<T> filterNot(Predicate<? super T> fn) {
        return (SortedSetX)MutableCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public SortedSetX<T> notNull() {
        return (SortedSetX)MutableCollectionX.super.notNull();
    }

    @Override
    default public SortedSetX<T> removeAll(Stream<? extends T> stream) {
        return (SortedSetX)MutableCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public SortedSetX<T> removeAll(Iterable<? extends T> it) {
        return (SortedSetX)MutableCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public SortedSetX<T> removeAll(T ... values) {
        return (SortedSetX)MutableCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public SortedSetX<T> retainAll(Iterable<? extends T> it) {
        return (SortedSetX)MutableCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public SortedSetX<T> retainAll(Stream<? extends T> seq) {
        return (SortedSetX)MutableCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public SortedSetX<T> retainAll(T ... values) {
        return (SortedSetX)MutableCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> SortedSetX<U> cast(Class<? extends U> type) {
        return (SortedSetX)MutableCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> SortedSetX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (SortedSetX)MutableCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> SortedSetX<C> grouped(int size, Supplier<C> supplier) {
        return (SortedSetX)MutableCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public SortedSetX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (SortedSetX)MutableCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public SortedSetX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (SortedSetX)MutableCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> SortedSetX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (SortedSetX)MutableCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> SortedSetX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (SortedSetX)MutableCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public SortedSetX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (SortedSetX)MutableCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public SortedSetX<T> removeAll(Seq<? extends T> stream) {
        return (SortedSetX)MutableCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public SortedSetX<T> retainAll(Seq<? extends T> stream) {
        return (SortedSetX)MutableCollectionX.super.retainAll((Seq)stream);
    }

    @Override
    default public SortedSetX<ReactiveSeq<T>> permutations() {
        return this.fromStream(this.stream().permutations().map(Comparables::comparable));
    }

    @Override
    default public SortedSetX<ReactiveSeq<T>> combinations(int size) {
        return this.fromStream(this.stream().combinations(size).map(Comparables::comparable));
    }

    @Override
    default public SortedSetX<ReactiveSeq<T>> combinations() {
        return this.fromStream(this.stream().combinations().map(Comparables::comparable));
    }

    public static class Comparables {
        static <T, R extends ReactiveSeq<T> & Comparable<T>> R comparable(Seq<T> seq) {
            return Comparables.comparable(ReactiveSeq.fromStream(seq));
        }

        static <T, R extends ReactiveSeq<T> & Comparable<T>> R comparable(ReactiveSeq<T> seq) {
            Method compareTo = Stream.of(Comparable.class.getMethods()).filter(m -> m.getName().equals("compareTo")).findFirst().get();
            return (R)((ReactiveSeq)Proxy.newProxyInstance(SortedSetX.class.getClassLoader(), new Class[]{ReactiveSeq.class, Comparable.class}, (proxy, method, args) -> {
                if (compareTo.equals(method)) {
                    return Objects.compare(System.identityHashCode(seq), System.identityHashCode(args[0]), Comparator.naturalOrder());
                }
                return method.invoke((Object)seq, args);
            }));
        }
    }
}

