/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class ListXImpl<T>
implements ListX<T> {
    private final List<T> list;
    private final Collector<T, ?, List<T>> collector;

    public ListXImpl(List<T> list) {
        this.list = list;
        this.collector = ListX.defaultCollector();
    }

    public ListXImpl() {
        this.collector = ListX.defaultCollector();
        this.list = (List)this.collector.supplier().get();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.list.forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean contains(Object e) {
        return this.list.contains(e);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.list.replaceAll(operator);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.list.removeIf(filter);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.list.sort(c);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.list.parallelStream();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public ListX<T> subList(int fromIndex, int toIndex) {
        return new ListXImpl<T>(this.list.subList(fromIndex, toIndex), this.getCollector());
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public int compareTo(T o) {
        if (o instanceof List) {
            List l = (List)o;
            if (this.size() == l.size()) {
                Iterator<T> i1 = this.iterator();
                Iterator i2 = l.iterator();
                if (i1.hasNext()) {
                    int comp;
                    if (i2.hasNext() && (comp = Comparator.naturalOrder().compare((Comparable)i1.next(), (Comparable)i2.next())) != 0) {
                        return comp;
                    }
                    return 1;
                }
                if (i2.hasNext()) {
                    return -1;
                }
                return 0;
            }
            return this.size() - ((List)o).size();
        }
        return 1;
    }

    @ConstructorProperties(value={"list", "collector"})
    public ListXImpl(List<T> list, Collector<T, ?, List<T>> collector) {
        this.list = list;
        this.collector = collector;
    }

    @Override
    public Collector<T, ?, List<T>> getCollector() {
        return this.collector;
    }
}

