/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.FluentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.types.IterableFunctor;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionXImpl<T>
implements MutableCollectionX<T> {
    private final Collection<T> delegate;

    @Override
    public <R> CollectionX<R> unit(R value) {
        return ListX.singleton(value);
    }

    @Override
    public <R> FluentCollectionX<R> unit(Collection<R> col) {
        return ListX.fromIterable(col);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public <T1> CollectionX<T1> from(Collection<T1> c) {
        if (c instanceof CollectionX) {
            return (CollectionX)c;
        }
        return new CollectionXImpl<T1>(c);
    }

    @Override
    public <U> IterableFunctor<U> unitIterator(Iterator<U> u) {
        return ListX.fromIterable(() -> u);
    }

    @Override
    public <X> MutableCollectionX<X> fromStream(Stream<X> stream) {
        return ListX.fromIterable(stream.collect(Collectors.toList()));
    }

    public String toString() {
        return String.format("%s", this.delegate);
    }

    @ConstructorProperties(value={"delegate"})
    public CollectionXImpl(Collection<T> delegate) {
        this.delegate = delegate;
    }
}

