/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.Sequential;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.ToStream;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.types.stream.lazy.LazyOperations;
import com.aol.cyclops.util.stream.Streamable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface TransformerSeq<T>
extends ConvertableSequence<T>,
Traversable<T>,
Sequential<T>,
Iterable<T>,
ToStream<T>,
Publisher<T> {
    public boolean isSeqPresent();

    public <T> TransformerSeq<T> unitAnyM(AnyM<Traversable<T>> var1);

    public AnyM<? extends Traversable<T>> transformerStream();

    @Override
    default public Traversable<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.combine(predicate, op)));
    }

    @Override
    default public void subscribe(Subscriber<? super T> s) {
        this.transformerStream().forEach(n -> n.subscribe(s));
    }

    @Override
    default public Traversable<T> cycle(int times) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.cycle(times)));
    }

    @Override
    default public Traversable<T> cycle(Monoid<T> m, int times) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.cycle(m, times)));
    }

    @Override
    default public Traversable<T> cycleWhile(Predicate<? super T> predicate) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.cycleWhile(predicate)));
    }

    @Override
    default public Traversable<T> cycleUntil(Predicate<? super T> predicate) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.cycleUntil(predicate)));
    }

    @Override
    default public <U, R> Traversable<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        Functor zipped = this.transformerStream().map(s -> s.zip(other, zipper));
        return this.unitAnyM((AnyM<Traversable<T>>)zipped);
    }

    @Override
    default public <U> Traversable<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        Streamable streamable = Streamable.fromStream(other);
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.zipStream(streamable.stream())));
    }

    @Override
    default public <U> Traversable<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return this.zipStream((Stream<? extends U>)other);
    }

    @Override
    default public <S, U> Traversable<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        Streamable streamable2 = Streamable.fromStream(second);
        Streamable streamable3 = Streamable.fromStream(third);
        Functor zipped = this.transformerStream().map(s -> s.zip3(streamable2.stream(), streamable3.stream()));
        return this.unitAnyM((AnyM<Traversable<T>>)zipped);
    }

    @Override
    default public <T2, T3, T4> Traversable<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        Streamable streamable2 = Streamable.fromStream(second);
        Streamable streamable3 = Streamable.fromStream(third);
        Streamable streamable4 = Streamable.fromStream(fourth);
        Functor zipped = this.transformerStream().map(s -> s.zip4(streamable2.stream(), streamable3.stream(), streamable4.stream()));
        return this.unitAnyM((AnyM<Traversable<T>>)zipped);
    }

    @Override
    default public Traversable<Tuple2<T, Long>> zipWithIndex() {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.zipWithIndex()));
    }

    @Override
    default public Traversable<ListX<T>> sliding(int windowSize) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.sliding(windowSize)));
    }

    @Override
    default public Traversable<ListX<T>> sliding(int windowSize, int increment) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.sliding(windowSize, increment)));
    }

    @Override
    default public <C extends Collection<? super T>> Traversable<C> grouped(int size, Supplier<C> supplier) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.grouped(size, supplier)));
    }

    @Override
    default public Traversable<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.groupedUntil(predicate)));
    }

    @Override
    default public Traversable<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.groupedStatefullyWhile(predicate)));
    }

    @Override
    default public Traversable<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.groupedWhile(predicate)));
    }

    @Override
    default public <C extends Collection<? super T>> Traversable<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.groupedWhile(predicate, factory2)));
    }

    @Override
    default public <C extends Collection<? super T>> Traversable<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.groupedUntil(predicate, factory2)));
    }

    @Override
    default public Traversable<ListX<T>> grouped(int groupSize) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.grouped(groupSize)));
    }

    @Override
    default public <K, A, D> Traversable<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.grouped(classifier, downstream)));
    }

    @Override
    default public <K> Traversable<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.grouped(classifier)));
    }

    @Override
    default public Traversable<T> distinct() {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.distinct()));
    }

    @Override
    default public Traversable<T> scanLeft(Monoid<T> monoid) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.scanLeft(monoid)));
    }

    @Override
    default public <U> Traversable<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.scanLeft(seed, function)));
    }

    @Override
    default public Traversable<T> scanRight(Monoid<T> monoid) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.scanRight(monoid)));
    }

    @Override
    default public <U> Traversable<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.scanRight(identity, combiner)));
    }

    @Override
    default public Traversable<T> sorted() {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.sorted()));
    }

    @Override
    default public Traversable<T> sorted(Comparator<? super T> c) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.sorted(c)));
    }

    @Override
    default public Traversable<T> takeWhile(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.takeWhile(p)));
    }

    @Override
    default public Traversable<T> dropWhile(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.dropWhile(p)));
    }

    @Override
    default public Traversable<T> takeUntil(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.takeUntil(p)));
    }

    @Override
    default public Traversable<T> dropUntil(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.dropUntil(p)));
    }

    @Override
    default public Traversable<T> dropRight(int num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.dropRight(num)));
    }

    @Override
    default public Traversable<T> takeRight(int num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.takeRight(num)));
    }

    @Override
    default public Traversable<T> skip(long num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.skip(num)));
    }

    @Override
    default public Traversable<T> skipWhile(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.skipWhile(p)));
    }

    @Override
    default public Traversable<T> skipUntil(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.skipUntil(p)));
    }

    @Override
    default public Traversable<T> limit(long num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.limit(num)));
    }

    @Override
    default public Traversable<T> limitWhile(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.limitWhile(p)));
    }

    @Override
    default public Traversable<T> limitUntil(Predicate<? super T> p) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.limitUntil(p)));
    }

    @Override
    default public Traversable<T> intersperse(T value) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.intersperse(value)));
    }

    @Override
    default public Traversable<T> reverse() {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.reverse()));
    }

    @Override
    default public Traversable<T> shuffle() {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.shuffle()));
    }

    @Override
    default public FutureOperations<T> futureOperations(Executor exec) {
        return Traversable.super.futureOperations(exec);
    }

    @Override
    default public LazyOperations<T> lazyOperations() {
        return Traversable.super.lazyOperations();
    }

    @Override
    default public Traversable<T> skipLast(int num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.skipLast(num)));
    }

    @Override
    default public Traversable<T> limitLast(int num) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.limitLast(num)));
    }

    @Override
    default public Traversable<T> onEmpty(T value) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.onEmpty(value)));
    }

    @Override
    default public Traversable<T> onEmptyGet(Supplier<? extends T> supplier) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.onEmptyGet(supplier)));
    }

    @Override
    default public <X extends Throwable> Traversable<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.onEmptyThrow(supplier)));
    }

    @Override
    default public Traversable<T> shuffle(Random random) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.shuffle(random)));
    }

    @Override
    default public Traversable<T> slice(long from, long to) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.slice(from, to)));
    }

    @Override
    default public <U extends Comparable<? super U>> Traversable<T> sorted(Function<? super T, ? extends U> function) {
        return this.unitAnyM((AnyM<Traversable<T>>)this.transformerStream().map(s -> s.sorted(function)));
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ConvertableSequence.super.stream();
    }
}

