/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.StreamableT;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.util.stream.Streamable;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StreamableTValue<T>
implements StreamableT<T> {
    final AnyMValue<Streamable<T>> run;

    private StreamableTValue(AnyMValue<Streamable<T>> run) {
        this.run = run;
    }

    @Override
    public AnyM<Streamable<T>> unwrap() {
        return this.run;
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public StreamableTValue<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public StreamableTValue<T> filter(Predicate<? super T> test) {
        return StreamableTValue.of(this.run.map((T stream) -> stream.filter(test)));
    }

    @Override
    public <B> StreamableTValue<B> map(Function<? super T, ? extends B> f) {
        return new StreamableTValue<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> StreamableTValue<B> flatMapT(Function<? super T, StreamableTValue<? extends B>> f) {
        return StreamableTValue.of(this.run.map((T stream) -> stream.flatMap((? super T a) -> Streamable.fromStream(((StreamableTValue)f.apply(a)).run.stream())).flatMap((? super T a) -> a)));
    }

    @Override
    public <B> StreamableTValue<B> flatMap(Function<? super T, ? extends Iterable<? extends B>> f) {
        return new StreamableTValue<T>(this.run.map((T o) -> o.flatMapIterable(f)));
    }

    public static <U, R> Function<StreamableTValue<U>, StreamableTValue<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<StreamableTValue<U1>, StreamableTValue<U2>, StreamableTValue<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> StreamableTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return StreamableTValue.of(anyM.map((T xva$0) -> Streamable.of(xva$0)));
    }

    public static <A> StreamableTValue<A> of(AnyMValue<Streamable<A>> monads) {
        return new StreamableTValue(monads);
    }

    public static <A> StreamableTValue<A> of(Streamable<A> monads) {
        return StreamableT.fromOptional(Optional.of(monads));
    }

    public static <A> StreamableTValue<A> fromStream(AnyMValue<Stream<A>> monads) {
        return new StreamableTValue(monads.map(Streamable::fromStream));
    }

    public static <A, V extends MonadicValue<Streamable<A>>> StreamableTValue<A> fromValue(V monadicValue) {
        return StreamableTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("StreamableTValue[%s]", this.run);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <U> StreamableTValue<U> unitIterator(Iterator<U> u) {
        return StreamableTValue.of(this.run.unit((Object)Streamable.fromIterator(u)));
    }

    @Override
    public <T> StreamableTValue<T> unit(T unit) {
        return StreamableTValue.of(this.run.unit((Object)Streamable.of(unit)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMap((T i) -> i.stream());
    }

    @Override
    public <R> StreamableTValue<R> empty() {
        return StreamableTValue.of(this.run.empty());
    }

    public static <T> StreamableTValue<T> emptyOptional() {
        return StreamableT.emptyOptional();
    }

    public boolean isStreamablePresent() {
        return !this.run.isEmpty();
    }

    public Streamable<T> get() {
        return (Streamable)this.run.get();
    }

    @Override
    public AnyM<? extends Foldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> StreamableTValue<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return StreamableTValue.of((AnyMValue)traversable.map((T t) -> Streamable.fromIterable(t)));
    }

    @Override
    public AnyM<? extends Traversable<T>> transformerStream() {
        return this.run;
    }
}

