/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.monads.transformers.EvalT;
import com.aol.cyclops.control.monads.transformers.values.MaybeTValue;
import com.aol.cyclops.control.monads.transformers.values.TransformerValue;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.Applicativable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;

public class EvalTValue<T>
implements EvalT<T>,
TransformerValue<T>,
MonadicValue<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
Applicativable<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private final AnyMValue<Eval<T>> run;

    private EvalTValue(AnyMValue<Eval<T>> run) {
        this.run = run;
    }

    @Override
    public Eval<T> value() {
        return (Eval)this.run.get();
    }

    @Override
    public AnyMValue<Eval<T>> unwrap() {
        return this.run;
    }

    @Override
    public EvalTValue<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public MaybeTValue<T> filter(Predicate<? super T> test) {
        return MaybeTValue.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> EvalTValue<B> map(Function<? super T, ? extends B> f) {
        return new EvalTValue<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> EvalTValue<B> flatMapT(Function<? super T, EvalTValue<? extends B>> f) {
        return EvalTValue.of(this.run.bind((T opt) -> ((EvalTValue)f.apply(opt.get())).run.unwrap()));
    }

    @Override
    public <B> EvalTValue<B> flatMap(Function<? super T, ? extends Eval<? extends B>> f) {
        return new EvalTValue<T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <U, R> Function<EvalTValue<U>, EvalTValue<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<EvalTValue<U1>, EvalTValue<U2>, EvalTValue<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> EvalTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return EvalTValue.of(anyM.map((T a) -> Eval.later(() -> a)));
    }

    public static <A> EvalTValue<A> of(AnyMValue<Eval<A>> monads) {
        return new EvalTValue(monads);
    }

    public static <A, V extends MonadicValue<Eval<A>>> EvalTValue<A> fromValue(V monadicValue) {
        return EvalTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("EvalTValue[%s]", this.run);
    }

    @Override
    public T get() {
        return ((Eval)this.run.get()).get();
    }

    @Override
    public boolean isValuePresent() {
        return !this.run.isEmpty();
    }

    @Override
    public ReactiveSeq<T> stream() {
        Maybe maybeEval = this.run.toMaybe();
        return maybeEval.isPresent() ? ((Eval)maybeEval.get()).stream() : ReactiveSeq.of(new Object[0]);
    }

    @Override
    public Iterator<T> iterator() {
        Maybe maybeEval = this.run.toMaybe();
        return maybeEval.isPresent() ? ((Eval)maybeEval.get()).iterator() : Arrays.asList(new Object[0]).iterator();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.run.toMaybe().forEach(e -> e.subscribe(s));
    }

    @Override
    public boolean test(T t) {
        Maybe maybeEval = this.run.toMaybe();
        return maybeEval.isPresent() ? ((Eval)maybeEval.get()).test(t) : false;
    }

    @Override
    public <R> EvalTValue<R> unit(R value) {
        return EvalTValue.of(this.run.unit((Object)Eval.now(value)));
    }

    @Override
    public <R> EvalTValue<R> empty() {
        return EvalTValue.of(this.run.unit((Object)Eval.later(() -> null)));
    }

    public static <T> EvalTValue<T> of(Eval<T> eval) {
        return EvalTValue.fromValue(Maybe.just(eval));
    }

    public static <T> EvalTValue<T> emptyMaybe() {
        return EvalTValue.fromValue(Maybe.none());
    }

    @Override
    public <U> EvalTValue<U> cast(Class<? extends U> type) {
        return (EvalTValue)TransformerValue.super.cast((Class)type);
    }

    @Override
    public <R> EvalTValue<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (EvalTValue)TransformerValue.super.trampoline((Function)mapper);
    }

    @Override
    public <R> EvalTValue<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (EvalTValue)TransformerValue.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    public <U> MaybeTValue<U> ofType(Class<? extends U> type) {
        return (MaybeTValue)EvalT.super.ofType((Class)type);
    }

    @Override
    public MaybeTValue<T> filterNot(Predicate<? super T> fn) {
        return (MaybeTValue)EvalT.super.filterNot((Predicate)fn);
    }

    @Override
    public MaybeTValue<T> notNull() {
        return (MaybeTValue)EvalT.super.notNull();
    }
}

