/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.FluentFunctions;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Reader;
import com.aol.cyclops.types.anyM.AnyMSeq;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ReaderTSeq<T, R> {
    private final AnyMSeq<Reader<T, R>> run;

    private ReaderTSeq(AnyMSeq<Reader<T, R>> run) {
        this.run = run;
    }

    public AnyMSeq<Reader<T, R>> unwrap() {
        return this.run;
    }

    public ReaderTSeq<T, R> peek(Consumer<? super R> peek) {
        return ReaderTSeq.of(this.run.peek((T opt) -> opt.map((? super R a) -> {
            peek.accept((Object)a);
            return a;
        })));
    }

    public <B> ReaderTSeq<T, B> map(Function<? super R, ? extends B> f) {
        return new ReaderTSeq<T, R>(this.run.map((T o) -> o.map(f)));
    }

    public <B> ReaderTSeq<T, B> flatMapT(Function<? super R, ReaderTSeq<T, B>> mapper) {
        return ReaderTSeq.of(this.run.bind(reader -> reader.flatMap((? super R r) -> (Reader)((ReaderTSeq)mapper.apply(r)).run.unwrap())));
    }

    public <B> ReaderTSeq<T, B> flatMap(Function<? super R, ? extends Reader<T, B>> f) {
        return new ReaderTSeq<T, R>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <T, U, R> Function<ReaderTSeq<T, U>, ReaderTSeq<T, R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map(input -> fn.apply((Object)input));
    }

    public static <T, U1, U2, R> BiFunction<ReaderTSeq<T, U1>, ReaderTSeq<T, U2>, ReaderTSeq<T, R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map(input2 -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <T, A> ReaderTSeq<T, A> fromAnyM(AnyMSeq<Function<T, A>> anyM) {
        return ReaderTSeq.of(anyM.map(FluentFunctions::of));
    }

    public static <T, A> ReaderTSeq<T, A> of(AnyMSeq<Reader<T, A>> monads) {
        return new ReaderTSeq(monads);
    }

    public String toString() {
        return this.run.toString();
    }

    public R apply(T t, Monoid<R> combiner) {
        return this.run.map((T r) -> r.apply(t)).reduce(combiner);
    }

    public ReactiveSeq<R> streamApply(T t) {
        return this.run.map((T fn) -> fn.apply(t)).stream();
    }
}

