/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops;

import com.aol.cyclops.Semigroup;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.FluentCollectionX;
import java.math.BigInteger;
import java.util.Optional;

public interface Semigroups {
    public static final Semigroup<BigInteger> bigIntCount = () -> (a, b) -> a.add(BigInteger.ONE);
    public static final Semigroup<Integer> intCount = () -> (a, b) -> a + 1;
    public static final Semigroup<Long> longCount = () -> (a, b) -> a + 1L;
    public static final Semigroup<Double> doubleCount = () -> (a, b) -> a + 1.0;
    public static final Semigroup<Integer> intSum = () -> (a, b) -> a + b;
    public static final Semigroup<Long> longSum = () -> (a, b) -> a + b;
    public static final Semigroup<Double> doubleSum = () -> (a, b) -> a + b;
    public static final Semigroup<BigInteger> bigIntSum = () -> (a, b) -> a.add((BigInteger)b);
    public static final Semigroup<Integer> intMult = () -> (a, b) -> a * b;
    public static final Semigroup<Long> longMult = () -> (a, b) -> a * b;
    public static final Semigroup<Double> doubleMult = () -> (a, b) -> a * b;
    public static final Semigroup<BigInteger> bigIntMult = () -> (a, b) -> a.multiply((BigInteger)b);
    public static final Semigroup<Integer> intMax = () -> (a, b) -> b > a ? b : a;
    public static final Semigroup<Long> longMax = () -> (a, b) -> b > a ? b : a;
    public static final Semigroup<Double> doubleMax = () -> (a, b) -> b > a ? b : a;
    public static final Semigroup<BigInteger> bigIntMax = () -> (a, b) -> a.max((BigInteger)b);
    public static final Semigroup<Integer> intMin = () -> (a, b) -> a < b ? a : b;
    public static final Semigroup<Long> longMin = () -> (a, b) -> a < b ? a : b;
    public static final Semigroup<Double> doubleMin = () -> (a, b) -> a < b ? a : b;
    public static final Semigroup<BigInteger> bigIntMin = () -> (a, b) -> a.min((BigInteger)b);
    public static final Semigroup<String> stringConcat = () -> (a, b) -> a + b;
    public static final Semigroup<StringBuffer> stringBufferConcat = () -> (a, b) -> a.append((StringBuffer)b);
    public static final Semigroup<StringBuilder> stringBuilderConcat = () -> (a, b) -> a.append((CharSequence)b);
    public static final Semigroup<Boolean> booleanDisjunction = () -> (a, b) -> a != false || b != false;
    public static final Semigroup<Boolean> booleanXDisjunction = () -> (a, b) -> a != false && b == false || b != false && a == false;
    public static final Semigroup<Boolean> booleanConjunction = () -> (a, b) -> a != false && b != false;

    public static <T, C extends FluentCollectionX<T>> Semigroup<C> combineFluentCollection() {
        return () -> (a, b) -> a.plusAll(b);
    }

    public static <T> Semigroup<ReactiveSeq<T>> combineReactiveSeq() {
        return () -> (a, b) -> a.appendStream(b);
    }

    public static <T> Semigroup<T> firstNonNull() {
        return () -> (a, b) -> a != null ? a : b;
    }

    public static <T> Semigroup<Maybe<T>> firstPresentMaybe() {
        return () -> (a, b) -> a.isPresent() ? a : b;
    }

    public static <T> Semigroup<Optional<T>> firstPresentOptional() {
        return () -> (a, b) -> a.isPresent() ? a : b;
    }

    public static <T> Semigroup<Maybe<T>> lastPresentMaybe() {
        return () -> (a, b) -> b.isPresent() ? b : a;
    }

    public static <T> Semigroup<Optional<T>> lastPresentOptional() {
        return () -> (a, b) -> b.isPresent() ? b : a;
    }

    public static Semigroup<String> stringJoin(String joiner) {
        return () -> (a, b) -> a + joiner + b;
    }

    public static Semigroup<StringBuilder> stringBuilderJoin(String joiner) {
        return () -> (a, b) -> a.append(joiner).append((CharSequence)b);
    }

    public static Semigroup<StringBuffer> stringBufferJoin(String joiner) {
        return () -> (a, b) -> a.append(joiner).append((StringBuffer)b);
    }

    public static <T, T2 extends Comparable<T>> Semigroup<T2> minComparable() {
        return () -> (a, b) -> a.compareTo(b) > 0 ? b : a;
    }

    public static <T, T2 extends Comparable<T>> Semigroup<T2> maxComparable() {
        return () -> (a, b) -> a.compareTo(b) > 0 ? a : b;
    }
}

