/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops;

import com.aol.cyclops.Semigroup;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Monoid<T>
extends Semigroup<T> {
    public T zero();

    default public T reduce(Stream<T> toReduce) {
        return toReduce.reduce(this.zero(), this.reducer());
    }

    public static <T> Monoid<T> of(final T zero, final Semigroup<T> group) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return group.combiner();
            }
        };
    }

    public static <T> Monoid<T> of(final T zero, final Function<T, Function<T, T>> combiner) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return (a, b) -> ((Function)combiner.apply(a)).apply(b);
            }
        };
    }

    public static <T> Monoid<T> of(final T zero, final BiFunction<T, T, T> combiner) {
        return new Monoid<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return combiner;
            }
        };
    }
}

