/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring.datasource.hibernate;

import com.aol.micro.server.config.ConfigAccessor;
import com.aol.micro.server.spring.datasource.JdbcConfig;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class SpringDataConfig {
    @Resource(name="mainEnv")
    private JdbcConfig env;
    @Resource(name="mainDataSource")
    private DataSource dataSource;

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        if (this.env.getGenerateDdl().equals("true")) {
            vendorAdapter.setGenerateDdl(true);
        } else {
            vendorAdapter.setGenerateDdl(false);
        }
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        factory.setPackagesToScan(((List)new ConfigAccessor().get().getDataSources().get((Object)new ConfigAccessor().get().getDefaultDataSourceName())).toArray(new String[0]));
        factory.setDataSource(this.dataSource);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }
}

