/*
 * Decompiled with CFR 0.152.
 */
package app.pure.jdbc.com.aol.micro.server;

import app.pure.jdbc.com.aol.micro.server.JdbcEntity;
import com.aol.micro.server.MicroserverApp;
import com.aol.micro.server.config.Microserver;
import com.aol.micro.server.module.Module;
import com.aol.micro.server.rest.client.nio.AsyncRestClient;
import com.aol.micro.server.testing.RestAgent;
import java.util.concurrent.ExecutionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Microserver(properties={"db.connection.driver", "org.hsqldb.jdbcDriver", "db.connection.url", "jdbc:hsqldb:mem:aname", "db.connection.username", "sa"})
public class JdbcRunnerTest {
    private final AsyncRestClient<JdbcEntity> listClient = new AsyncRestClient(1000, 1000).withResponse(JdbcEntity.class);
    RestAgent rest = new RestAgent();
    MicroserverApp server;

    @Before
    public void startServer() {
        this.server = new MicroserverApp(new Module[]{() -> "jdbc-app"});
        this.server.start();
        this.rest.get("http://localhost:8080/jdbc-app/persistence/gen");
    }

    @After
    public void stopServer() {
        this.server.stop();
    }

    @Test
    public void runAppAndBasicTest() throws InterruptedException, ExecutionException {
        Assert.assertThat((Object)this.rest.get("http://localhost:8080/jdbc-app/persistence/create"), (Matcher)CoreMatchers.is((Object)"ok"));
        Assert.assertThat(this.listClient.get("http://localhost:8080/jdbc-app/persistence/get").get(), (Matcher)CoreMatchers.is(JdbcEntity.class));
    }
}

