/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.validation;

import com.aol.cyclops.validation.CumulativeValidator;
import fj.data.Validation;
import java.beans.ConstructorProperties;
import java.util.function.Predicate;

public class Validator<T, R, E> {
    private final Predicate<T> valid;
    final E error;
    final R result;

    public static <T, R, E> Validator<T, R, E> of(Predicate<T> valid, E error, R result) {
        return new Validator<T, R, E>(valid, error, result);
    }

    public static <T, R, E> Validator<T, R, E> convert(Validation<E, R> validation) {
        if (validation.isSuccess()) {
            return Validator.of(t -> true, null, validation.success());
        }
        return Validator.of(t -> false, validation.fail(), null);
    }

    public boolean isValid(T input) {
        return this.valid.test(input);
    }

    public CumulativeValidator<T, R, E> cumulative() {
        return new CumulativeValidator(this, null);
    }

    @ConstructorProperties(value={"valid", "error", "result"})
    public Validator(Predicate<T> valid, E error, R result) {
        this.valid = valid;
        this.error = error;
        this.result = result;
    }
}

