/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.validation;

import com.aol.cyclops.validation.FailedResult;
import com.aol.cyclops.validation.SuccessfulResult;
import com.aol.cyclops.validation.ValidationResult;
import com.aol.cyclops.validation.ValidationResults;
import com.aol.cyclops.validation.Validator;
import fj.data.Validation;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.function.Predicate;

public class CumulativeValidator<T, R, E> {
    private final Validator<T, R, E> validation;
    private final CumulativeValidator<T, R, E> next;

    public CumulativeValidator<T, R, E> isValid(Predicate<T> valid, E error, R result) {
        return this.add(Validator.of(valid, error, result));
    }

    public ValidationResults<R, E> accumulate() {
        return this.accumulate(null);
    }

    public ValidationResults<R, E> accumulate(T input) {
        ArrayList results = new ArrayList();
        ValidationResult result = this.validation.isValid(input) ? SuccessfulResult.success(this.validation.result) : FailedResult.fail(this.validation.error);
        results.add(result);
        if (this.next != null) {
            results.addAll(this.next.accumulate(input).getResults());
        }
        return new ValidationResults(results);
    }

    public ValidationResults<R, E> accumulateUntilFail(T input) {
        ArrayList results = new ArrayList();
        if (!this.validation.isValid(input)) {
            ValidationResult result = FailedResult.fail(this.validation.error);
            results.add(result);
            return new ValidationResults(results);
        }
        ValidationResult result = SuccessfulResult.success(this.validation.result);
        results.add(result);
        if (this.next != null) {
            results.addAll(this.next.accumulate(input).getResults());
        }
        return new ValidationResults(results);
    }

    public CumulativeValidator<T, R, E> add(Validation<E, R> validation) {
        if (this.next == null) {
            return this.withNext(new CumulativeValidator(Validator.convert(validation), null));
        }
        return this.next.add(Validator.convert(validation));
    }

    public CumulativeValidator<T, R, E> add(Validator<T, R, E> validation) {
        if (this.next == null) {
            return this.withNext(new CumulativeValidator<T, R, E>(validation, null));
        }
        return this.next.add(validation);
    }

    public static <T, R, E> CumulativeValidator<T, R, E> of(Predicate<T> valid, E error, R result) {
        return new CumulativeValidator<T, R, E>(Validator.of(valid, error, result), null);
    }

    public static <T, R, E> CumulativeValidator<T, R, E> of(Validation<E, R> validation) {
        return new CumulativeValidator(Validator.convert(validation), null);
    }

    @ConstructorProperties(value={"validation", "next"})
    public CumulativeValidator(Validator<T, R, E> validation, CumulativeValidator<T, R, E> next) {
        this.validation = validation;
        this.next = next;
    }

    public CumulativeValidator<T, R, E> withValidation(Validator<T, R, E> validation) {
        return this.validation == validation ? this : new CumulativeValidator<T, R, E>(validation, this.next);
    }

    public CumulativeValidator<T, R, E> withNext(CumulativeValidator<T, R, E> next) {
        return this.next == next ? this : new CumulativeValidator<T, R, E>(this.validation, next);
    }
}

