/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.tuple;

import com.aol.cyclops.lambda.api.TupleWrapper;
import com.aol.cyclops.lambda.tuple.CachedValues;
import com.aol.cyclops.lambda.tuple.PTuple8;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TupleImpl<T1, T2, T3, T4, T5, T6, T7, T8>
implements PTuple8<T1, T2, T3, T4, T5, T6, T7, T8> {
    private final Object instance;
    private final List<Object> cachedValues;
    private final int arity;
    private final List<Object> empty = Arrays.asList(new Object[0]);

    public TupleImpl(int arity) {
        this.arity = arity;
        this.cachedValues = this.empty;
        this.instance = null;
    }

    public TupleImpl(Object tuple) {
        this(tuple, OptionalInt.empty());
    }

    public TupleImpl(Object tuple, int arity) {
        this(tuple, OptionalInt.of(arity));
    }

    private TupleImpl(Object tuple, OptionalInt arity) {
        this.instance = tuple;
        this.cachedValues = tuple instanceof Collection ? new ArrayList<Object>((List)tuple) : (tuple instanceof Map ? new ArrayList(((Map)tuple).entrySet()) : (tuple instanceof Stream ? ((Stream)tuple).collect(Collectors.toList()) : (tuple instanceof Iterable ? this.loadFromIterable((Iterable)tuple) : (tuple instanceof Iterator ? this.loadFromIterator((Iterator)tuple) : (tuple != null && tuple.getClass().isArray() ? Arrays.asList((Object[])tuple) : ((TupleWrapper)() -> tuple).values())))));
        this.arity = arity.orElse(this.cachedValues.size());
    }

    private List<Object> loadFromIterator(Iterator tuple) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (tuple.hasNext()) {
            result.add(tuple.next());
        }
        return result;
    }

    private List<Object> loadFromIterable(Iterable tuple) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object next : tuple) {
            result.add(next);
        }
        return result;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    public String toString() {
        return this.getCachedValues().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.getCachedValues());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CachedValues)) {
            return false;
        }
        if (this.getCachedValues() == null && ((CachedValues)obj).getCachedValues() == null) {
            return true;
        }
        return this.getCachedValues().equals(((CachedValues)obj).getCachedValues());
    }

    @Override
    public Object getMatchable() {
        return this.getCachedValues();
    }

    private TupleImpl(Object instance, List<Object> cachedValues, int arity) {
        this.instance = instance;
        this.cachedValues = cachedValues;
        this.arity = arity;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Override
    public List<Object> getCachedValues() {
        return this.cachedValues;
    }

    @Override
    public TupleImpl<T1, T2, T3, T4, T5, T6, T7, T8> withArity(int arity) {
        return this.arity == arity ? this : new TupleImpl<T1, T2, T3, T4, T5, T6, T7, T8>(this.instance, this.cachedValues, arity);
    }
}

