/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.tuple;

import com.aol.cyclops.functions.QuadFunction;
import com.aol.cyclops.lambda.tuple.PTuple3;
import com.aol.cyclops.lambda.tuple.PTuple8;
import com.aol.cyclops.lambda.tuple.PowerTuples;
import com.aol.cyclops.lambda.tuple.TupleImpl;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap1PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap2PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap3PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap4PTuple8;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;

public interface PTuple4<T1, T2, T3, T4>
extends PTuple3<T1, T2, T3> {
    default public T4 v4() {
        if (this.arity() < 4) {
            throw new ClassCastException("Attempt to upscale to " + PTuple4.class.getCanonicalName() + " from com.aol.cyclops.lambda.tuple.Tuple" + this.arity());
        }
        return (T4)this.getCachedValues().get(3);
    }

    default public T4 _4() {
        return this.v4();
    }

    default public T4 getT4() {
        return this.v4();
    }

    @Override
    default public int arity() {
        return 4;
    }

    default public <R> R apply4(Function<T1, Function<T2, Function<T3, Function<T4, R>>>> fn) {
        return fn.apply(this.v1()).apply(this.v2()).apply(this.v3()).apply(this.v4());
    }

    default public <R> R call(QuadFunction<T1, T2, T3, T4, R> fn) {
        return (R)fn.apply(this.v1(), this.v2(), this.v3(), this.v4());
    }

    default public <R> CompletableFuture<R> callAsync(QuadFunction<T1, T2, T3, T4, R> fn) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2(), i.v3(), i.v4()));
    }

    default public <R> CompletableFuture<R> applyAsync4(Function<T1, Function<T2, Function<T3, Function<T4, R>>>> fn) {
        return CompletableFuture.completedFuture(this.v4()).thenApplyAsync(fn.apply(this.v1()).apply(this.v2()).apply(this.v3()));
    }

    default public <R> CompletableFuture<R> callAsync(QuadFunction<T1, T2, T3, T4, R> fn, Executor e) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2(), i.v3(), i.v4()), e);
    }

    default public <R> CompletableFuture<R> applyAsync4(Function<T1, Function<T2, Function<T3, Function<T4, R>>>> fn, Executor e) {
        return CompletableFuture.completedFuture(this.v4()).thenApplyAsync(fn.apply(this.v1()).apply(this.v2()).apply(this.v3()), e);
    }

    default public <NT1, NT2, NT3, NT4> PTuple4<NT1, NT2, NT3, NT4> reorder(final Function<PTuple4<T1, T2, T3, T4>, NT1> v1S, final Function<PTuple4<T1, T2, T3, T4>, NT2> v2S, final Function<PTuple4<T1, T2, T3, T4>, NT3> v3S, final Function<PTuple4<T1, T2, T3, T4>, NT4> v4S) {
        final PTuple4 host = this;
        return new TupleImpl(Arrays.asList(new Object[0]), 4){

            @Override
            public NT1 v1() {
                return v1S.apply(host);
            }

            @Override
            public NT2 v2() {
                return v2S.apply(host);
            }

            @Override
            public NT3 v3() {
                return v3S.apply(host);
            }

            @Override
            public NT4 v4() {
                return v4S.apply(host);
            }

            @Override
            public List<Object> getCachedValues() {
                return Arrays.asList(this.v1(), this.v2(), this.v3(), this.v4());
            }

            @Override
            public Iterator iterator() {
                return this.getCachedValues().iterator();
            }
        };
    }

    default public PTuple3<T1, T2, T3> tuple3() {
        return (PTuple3)this.withArity(3);
    }

    default public PTuple4<T4, T3, T2, T1> swap4() {
        return PTuple4.of(this.v4(), this.v3(), this.v2(), this.v1());
    }

    default public <T> PTuple4<T, T2, T3, T4> map1(Function<T1, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.map1(fn);
        }
        return PowerTuples.tuple(fn.apply(this.v1()), this.v2(), this.v3(), this.v4());
    }

    default public <T> PTuple4<T, T2, T3, T4> lazyMap1(Function<T1, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.lazyMap1((Function)fn);
        }
        return new LazyMap1PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple4<T1, T, T3, T4> lazyMap2(Function<T2, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.lazyMap2((Function)fn);
        }
        return new LazyMap2PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple4<T1, T, T3, T4> map2(Function<T2, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.map2(fn);
        }
        return PTuple4.of(this.v1(), fn.apply(this.v2()), this.v3(), this.v4());
    }

    default public <T> PTuple4<T1, T2, T, T4> lazyMap3(Function<T3, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.lazyMap3(fn);
        }
        return new LazyMap3PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple4<T1, T2, T, T4> map3(Function<T3, T> fn) {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.map3(fn);
        }
        return PTuple4.of(this.v1(), this.v2(), fn.apply(this.v3()), this.v4());
    }

    default public <T> PTuple4<T1, T2, T3, T> lazyMap4(Function<T4, T> fn) {
        return new LazyMap4PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple4<T1, T2, T3, T> map4(Function<T4, T> fn) {
        return PTuple4.of(this.v1(), this.v2(), this.v3(), fn.apply(this.v4()));
    }

    @Override
    default public PTuple4<T1, T2, T3, T4> memo() {
        if (this.arity() != 4) {
            return (PTuple4)PTuple3.super.memo();
        }
        final PTuple4 host = this;
        final ConcurrentHashMap values = new ConcurrentHashMap();
        return new TupleImpl(Arrays.asList(new Object[0]), 4){

            @Override
            public T1 v1() {
                return values.computeIfAbsent(new Integer(0), key -> host.v1());
            }

            @Override
            public T2 v2() {
                return values.computeIfAbsent(new Integer(1), key -> host.v2());
            }

            @Override
            public T3 v3() {
                return values.computeIfAbsent(new Integer(2), key -> host.v3());
            }

            @Override
            public T4 v4() {
                return values.computeIfAbsent(new Integer(3), key -> host.v4());
            }

            @Override
            public List<Object> getCachedValues() {
                return Arrays.asList(this.v1(), this.v2(), this.v3(), this.v4());
            }

            @Override
            public Iterator iterator() {
                return this.getCachedValues().iterator();
            }
        };
    }

    public static <T1, T2, T3, T4> PTuple4<T1, T2, T3, T4> ofTuple(Object tuple4) {
        return new TupleImpl(tuple4, 4);
    }

    public static <T1, T2, T3, T4> PTuple4<T1, T2, T3, T4> of(T1 t1, T2 t2, T3 t3, T4 t4) {
        return new TupleImpl(Arrays.asList(t1, t2, t3, t4), 4);
    }
}

