/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.tuple;

import com.aol.cyclops.functions.TriFunction;
import com.aol.cyclops.lambda.tuple.PTuple1;
import com.aol.cyclops.lambda.tuple.PTuple2;
import com.aol.cyclops.lambda.tuple.PTuple8;
import com.aol.cyclops.lambda.tuple.PowerTuples;
import com.aol.cyclops.lambda.tuple.TupleImpl;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap1PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap2PTuple8;
import com.aol.cyclops.lambda.tuple.lazymap.LazyMap3PTuple8;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public interface PTuple3<T1, T2, T3>
extends PTuple2<T1, T2> {
    default public T3 v3() {
        if (this.arity() < 3) {
            throw new ClassCastException("Attempt to upscale to " + PTuple3.class.getCanonicalName() + " from com.aol.cyclops.lambda.tuple.Tuple" + this.arity());
        }
        return (T3)this.getCachedValues().get(2);
    }

    default public T3 _3() {
        return this.v3();
    }

    default public T3 getT3() {
        return this.v3();
    }

    @Override
    default public int arity() {
        return 3;
    }

    default public <R> R apply3(Function<T1, Function<T2, Function<T3, R>>> fn) {
        return fn.apply(this.v1()).apply(this.v2()).apply(this.v3());
    }

    default public <R> R call(TriFunction<T1, T2, T3, R> fn) {
        return (R)fn.apply(this.v1(), this.v2(), this.v3());
    }

    default public <R> CompletableFuture<R> callAsync(TriFunction<T1, T2, T3, R> fn) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2(), i.v3()));
    }

    default public <R> CompletableFuture<R> applyAsync3(Function<T1, Function<T2, Function<T3, R>>> fn) {
        return CompletableFuture.completedFuture(this.v3()).thenApplyAsync(fn.apply(this.v1()).apply(this.v2()));
    }

    default public <R> CompletableFuture<R> callAsync(TriFunction<T1, T2, T3, R> fn, Executor e) {
        return CompletableFuture.completedFuture(this).thenApplyAsync(i -> fn.apply(i.v1(), i.v2(), i.v3()), e);
    }

    default public <R> CompletableFuture<R> applyAsync3(Function<T1, Function<T2, Function<T3, R>>> fn, Executor e) {
        return CompletableFuture.completedFuture(this.v3()).thenApplyAsync(fn.apply(this.v1()).apply(this.v2()), e);
    }

    default public <T> PTuple3<T, T2, T3> map1(Function<T1, T> fn) {
        if (this.arity() != 3) {
            return (PTuple3)PTuple2.super.map1(fn);
        }
        return PowerTuples.tuple(fn.apply(this.v1()), this.v2(), this.v3());
    }

    default public <T> PTuple3<T, T2, T3> lazyMap1(Function<T1, T> fn) {
        if (this.arity() != 3) {
            return (PTuple3)PTuple2.super.lazyMap1((Function)fn);
        }
        return new LazyMap1PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple3<T1, T, T3> lazyMap2(Function<T2, T> fn) {
        if (this.arity() != 3) {
            return (PTuple3)PTuple2.super.lazyMap2(fn);
        }
        return new LazyMap2PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple3<T1, T, T3> map2(Function<T2, T> fn) {
        if (this.arity() != 3) {
            return (PTuple3)PTuple2.super.map2(fn);
        }
        return PTuple3.of(this.v1(), fn.apply(this.v2()), this.v3());
    }

    default public <T> PTuple3<T1, T2, T> lazyMap3(Function<T3, T> fn) {
        return new LazyMap3PTuple8(fn, (PTuple8)this);
    }

    default public <T> PTuple3<T1, T2, T> map3(Function<T3, T> fn) {
        return PTuple3.of(this.v1(), this.v2(), fn.apply(this.v3()));
    }

    default public PTuple1<T1> tuple2() {
        return (PTuple1)this.withArity(2);
    }

    default public PTuple3<T3, T2, T1> swap3() {
        return PTuple3.of(this.v3(), this.v2(), this.v1());
    }

    default public <NT1, NT2, NT3> PTuple3<NT1, NT2, NT3> reorder(final Function<PTuple3<T1, T2, T3>, NT1> v1S, final Function<PTuple3<T1, T2, T3>, NT2> v2S, final Function<PTuple3<T1, T2, T3>, NT3> v3S) {
        final PTuple3 host = this;
        return new TupleImpl(Arrays.asList(new Object[0]), 3){

            @Override
            public NT1 v1() {
                return v1S.apply(host);
            }

            @Override
            public NT2 v2() {
                return v2S.apply(host);
            }

            @Override
            public NT3 v3() {
                return v3S.apply(host);
            }

            @Override
            public List<Object> getCachedValues() {
                return Arrays.asList(this.v1(), this.v2(), this.v3());
            }

            @Override
            public Iterator iterator() {
                return this.getCachedValues().iterator();
            }
        };
    }

    public static ThreeNumbers asThreeNumbers(PTuple3<Number, Number, Number> numbers) {
        return new ThreeNumbers(numbers);
    }

    @Override
    default public PTuple3<T1, T2, T3> memo() {
        if (this.arity() != 3) {
            return (PTuple3)PTuple2.super.memo();
        }
        final PTuple3 host = this;
        final ConcurrentHashMap values = new ConcurrentHashMap();
        return new TupleImpl(Arrays.asList(new Object[0]), 3){

            @Override
            public T1 v1() {
                return values.computeIfAbsent(new Integer(0), key -> host.v1());
            }

            @Override
            public T2 v2() {
                return values.computeIfAbsent(new Integer(1), key -> host.v2());
            }

            @Override
            public T3 v3() {
                return values.computeIfAbsent(new Integer(2), key -> host.v3());
            }

            @Override
            public List<Object> getCachedValues() {
                return Arrays.asList(this.v1(), this.v2(), this.v3());
            }

            @Override
            public Iterator iterator() {
                return this.getCachedValues().iterator();
            }
        };
    }

    public static <T1, T2, T3> PTuple3<T1, T2, T3> ofTuple(Object tuple2) {
        return new TupleImpl(tuple2, 3);
    }

    public static <T1, T2, T3> PTuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {
        return new TupleImpl(Arrays.asList(t1, t2, t3), 3);
    }

    public static class ThreeNumbers {
        private final PTuple3 t3;

        public IntStream asRange() {
            int start = ((Number)this.t3.v1()).intValue();
            int end = ((Number)this.t3.v2()).intValue();
            int step = ((Number)this.t3.v3()).intValue();
            return IntStream.iterate(start, i -> i + step).limit((end - start) / step);
        }

        public LongStream asLongRange() {
            long start = ((Number)this.t3.v1()).longValue();
            long end = ((Number)this.t3.v2()).longValue();
            long step = ((Number)this.t3.v3()).longValue();
            return LongStream.iterate(start, i -> i + step).limit((end - start) / step);
        }

        @ConstructorProperties(value={"t3"})
        public ThreeNumbers(PTuple3 t3) {
            this.t3 = t3;
        }
    }
}

