/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.lambda.monads.Functor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.Function;

public interface WrappingFunctor<T>
extends Functor<T> {
    default public <T> WrappingFunctor<T> withFunctor(T functor) {
        if (this.getFunctor() == this) {
            return (WrappingFunctor)functor;
        }
        try {
            Constructor<?> cons = this.getClass().getConstructor(Object.class);
            cons.setAccessible(true);
            return (WrappingFunctor)cons.newInstance(functor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ExceptionSoftener.throwSoftenedException((Throwable)e);
            return null;
        }
    }

    default public Object getFunctor() {
        return this;
    }

    @Override
    default public <R> WrappingFunctor<R> map(Function<? super T, ? extends R> fn) {
        Object value = new ComprehenderSelector().selectComprehender(this.getFunctor()).map(this.getFunctor(), fn);
        return this.withFunctor(value);
    }

    @Override
    default public WrappingFunctor<T> peek(Consumer<? super T> c) {
        return this.map((T input) -> {
            c.accept(input);
            return input;
        });
    }

    default public <X> X unwrap() {
        if (this.getFunctor() != this && this.getFunctor() instanceof Functor) {
            return ((WrappingFunctor)this.getFunctor()).unwrap();
        }
        return (X)this.getFunctor();
    }
}

