/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public class SkipLastOperator<T> {
    Stream<T> stream;
    ArrayDeque<T> buffer;
    int skip;

    public SkipLastOperator(Stream<T> stream, int skip) {
        this.buffer = new ArrayDeque(skip);
        this.stream = stream;
        this.skip = skip;
    }

    public Stream<T> skipLast() {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){
            boolean finished = false;

            @Override
            public boolean hasNext() {
                while (SkipLastOperator.this.buffer.size() < SkipLastOperator.this.skip && it.hasNext()) {
                    SkipLastOperator.this.buffer.add(it.next());
                }
                this.finished = it.hasNext();
                return this.finished;
            }

            @Override
            public T next() {
                if (this.finished && SkipLastOperator.this.buffer.size() == 0) {
                    throw new NoSuchElementException();
                }
                return SkipLastOperator.this.buffer.pop();
            }
        });
    }
}

