/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.sequence.SequenceM;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple3;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FutureStreamUtils {
    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachX(Stream<T> stream, final long x, final Consumer<? super T> consumerElement) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> SequenceM.fromStream((Stream)stream).subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachXWithError(Stream<T> stream, final long x, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> SequenceM.fromStream((Stream)stream).subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachXEvents(Stream<T> stream, final long x, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError, final Runnable onComplete) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> SequenceM.fromStream((Stream)stream).subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                s.request(x);
                subscription.complete(s);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
                onComplete.run();
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachWithError(Stream<T> stream, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> SequenceM.fromStream((Stream)stream).subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                subscription.complete(s);
                s.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
            }
        }), streamCompleted);
    }

    public static <T, X extends Throwable> Tuple3<CompletableFuture<Subscription>, Runnable, CompletableFuture<Boolean>> forEachEvent(Stream<T> stream, final Consumer<? super T> consumerElement, final Consumer<? super Throwable> consumerError, final Runnable onComplete) {
        final CompletableFuture subscription = new CompletableFuture();
        final CompletableFuture streamCompleted = new CompletableFuture();
        return Tuple.tuple(subscription, () -> SequenceM.fromStream((Stream)stream).subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                Objects.requireNonNull(s);
                subscription.complete(s);
                s.request(Long.MAX_VALUE);
            }

            public void onNext(T t) {
                consumerElement.accept(t);
            }

            public void onError(Throwable t) {
                consumerError.accept(t);
            }

            public void onComplete() {
                streamCompleted.complete(true);
                onComplete.run();
            }
        }), streamCompleted);
    }
}

