/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence;

import com.aol.cyclops.comprehensions.donotation.typed.Do;
import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HeadAndTail;
import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.Unwrapable;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.reactivestreams.ReactiveStreamsLoader;
import com.aol.cyclops.sequence.reactivestreams.ReactiveStreamsPublisher;
import com.aol.cyclops.sequence.spliterators.ReversableSpliterator;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.streams.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SequenceMImpl<T>
implements Unwrapable,
SequenceM<T>,
Iterable<T> {
    private final Seq<T> stream;
    private final Optional<ReversableSpliterator> reversable;

    public SequenceMImpl(Stream<T> stream) {
        this.stream = Seq.seq(stream);
        this.reversable = Optional.empty();
    }

    public SequenceMImpl(Stream<T> stream, ReversableSpliterator rev) {
        this.stream = Seq.seq(stream);
        this.reversable = Optional.of(rev);
    }

    public HotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        return StreamUtils.schedule(this, cron, ex);
    }

    public HotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedDelay(this, delay, ex);
    }

    public HotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedRate(this, rate, ex);
    }

    @Deprecated
    public final <R> R unwrap() {
        return (R)this;
    }

    public final <T1> SequenceM<T1> flatten() {
        return StreamUtils.flatten(this.stream);
    }

    public final Stream<T> unwrapStream() {
        return this.stream;
    }

    public final Optional<List<T>> toOptional() {
        return StreamUtils.streamToOptional(this.stream);
    }

    public final CompletableFuture<List<T>> toCompletableFuture() {
        return StreamUtils.streamToCompletableFuture(this.stream);
    }

    public final SequenceM<T> cycle(int times) {
        return StreamUtils.sequenceM(StreamUtils.cycle(times, AsStreamable.fromStream(this.stream)), this.reversable);
    }

    public final SequenceM<T> cycle() {
        return StreamUtils.sequenceM(StreamUtils.cycle(this.stream), this.reversable);
    }

    public final Tuple2<SequenceM<T>, SequenceM<T>> duplicateSequence() {
        Tuple2<Stream<T>, Stream<T>> tuple = StreamUtils.duplicate(this.stream);
        return tuple.map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final Tuple3<SequenceM<T>, SequenceM<T>, SequenceM<T>> triplicate() {
        Tuple3<Stream<T>, Stream<T>, Stream<T>> tuple = StreamUtils.triplicate(this.stream);
        return tuple.map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map3(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final Tuple4<SequenceM<T>, SequenceM<T>, SequenceM<T>, SequenceM<T>> quadruplicate() {
        Tuple4<Stream<T>, Stream<T>, Stream<T>, Stream<T>> tuple = StreamUtils.quadruplicate(this.stream);
        return tuple.map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map3(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map4(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final Tuple2<Optional<T>, SequenceM<T>> splitSequenceAtHead() {
        Tuple2<SequenceM<T>, SequenceM<T>> Tuple22 = this.splitAt(1);
        return new Tuple2(((SequenceM)Tuple22.v1).toOptional().flatMap((? super T l) -> l.size() > 0 ? Optional.of(l.get(0)) : Optional.empty()), Tuple22.v2);
    }

    public final Tuple2<SequenceM<T>, SequenceM<T>> splitAt(int where) {
        return StreamUtils.splitAt(this.stream, where).map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final Tuple2<SequenceM<T>, SequenceM<T>> splitBy(Predicate<T> splitter) {
        return StreamUtils.splitBy(this.stream, splitter).map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final Tuple2<SequenceM<T>, SequenceM<T>> partitionSequence(Predicate<T> splitter) {
        return StreamUtils.partition(this.stream, splitter).map1(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.sequenceM(s, this.reversable.map((? super T r) -> r.copy())));
    }

    public final SequenceM<T> cycle(Monoid<T> m, int times) {
        return StreamUtils.sequenceM(StreamUtils.cycle(times, Streamable.of((Object[])new Object[]{m.reduce(this.stream)})), this.reversable);
    }

    public final <R> SequenceM<R> cycle(Class<R> monadC, int times) {
        return (SequenceMImpl)this.cycle(times).map(r -> new ComprehenderSelector().selectComprehender(monadC).of(r));
    }

    public final SequenceM<T> cycleWhile(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.cycle(this.stream), this.reversable).limitWhile(predicate);
    }

    public final SequenceM<T> cycleUntil(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.cycle(this.stream), this.reversable).limitWhile(predicate.negate());
    }

    public final <S> SequenceM<Tuple2<T, S>> zip(Stream<? extends S> second) {
        return this.zipStream(second, (a, b) -> new Tuple2(a, b));
    }

    public final <S, U> SequenceM<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.zip(second).zipStream(third).map(p -> new Tuple3(((Tuple2)p.v1()).v1(), ((Tuple2)p.v1()).v2(), p.v2()));
    }

    public final <T2, T3, T4> SequenceM<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.zip3(second, third).zipStream(fourth).map(t -> new Tuple4(((Tuple3)t.v1()).v1(), ((Tuple3)t.v1()).v2(), ((Tuple3)t.v1()).v3(), t.v2()));
    }

    public final SequenceM<Tuple2<T, Long>> zipWithIndex() {
        return this.zipStream(LongStream.iterate(0L, i -> i + 1L), (a, b) -> new Tuple2(a, b));
    }

    public final <S, R> SequenceM<R> zipSequence(SequenceM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.sequenceM(StreamUtils.zipSequence(this.stream, second, zipper), Optional.empty());
    }

    public final <S, R> SequenceM<R> zip(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return this.zipSequence(second.toSequence(), zipper);
    }

    public final <S, R> SequenceM<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.sequenceM(StreamUtils.zipStream(this.stream, second, zipper), Optional.empty());
    }

    public final SequenceM<List<T>> sliding(int windowSize) {
        return StreamUtils.sequenceM(StreamUtils.sliding(this.stream, windowSize), this.reversable);
    }

    public final SequenceM<List<T>> sliding(int windowSize, int increment) {
        return StreamUtils.sequenceM(StreamUtils.sliding(this.stream, windowSize, increment), this.reversable);
    }

    public final SequenceM<List<T>> grouped(int groupSize) {
        return StreamUtils.sequenceM(StreamUtils.batchBySize(this.stream, groupSize), this.reversable);
    }

    public final <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.collect(Collectors.groupingBy(classifier));
    }

    public final SequenceM<T> distinct() {
        return StreamUtils.sequenceM(this.stream.distinct(), this.reversable);
    }

    public final SequenceM<T> scanLeft(Monoid<T> monoid) {
        return StreamUtils.sequenceM(StreamUtils.scanLeft(this.stream, monoid), this.reversable);
    }

    public final <U> SequenceM<U> scanLeft(U seed, BiFunction<U, ? super T, U> function) {
        return StreamUtils.sequenceM(this.stream.scanLeft(seed, function), this.reversable);
    }

    public final SequenceM<T> scanRight(Monoid<T> monoid) {
        return StreamUtils.sequenceM(this.reverse().scanLeft(monoid.zero(), (u, t) -> monoid.combiner().apply(t, u)), this.reversable);
    }

    public final <U> SequenceM<U> scanRight(U identity, BiFunction<? super T, U, U> combiner) {
        return StreamUtils.sequenceM(StreamUtils.scanRight(this.stream, identity, combiner), this.reversable);
    }

    public final SequenceM<T> sorted() {
        return StreamUtils.sequenceM(this.stream.sorted(), this.reversable);
    }

    public final SequenceM<T> sorted(Comparator<? super T> c) {
        return StreamUtils.sequenceM(this.stream.sorted(c), this.reversable);
    }

    public final SequenceM<T> skip(long num) {
        return StreamUtils.sequenceM(this.stream.skip(num), this.reversable);
    }

    public final SequenceM<T> skipWhile(Predicate<? super T> p) {
        return StreamUtils.sequenceM(StreamUtils.skipWhile(this.stream, p), this.reversable);
    }

    public final SequenceM<T> skipUntil(Predicate<? super T> p) {
        return StreamUtils.sequenceM(StreamUtils.skipUntil(this.stream, p), this.reversable);
    }

    public final SequenceM<T> limit(long num) {
        return StreamUtils.sequenceM(this.stream.limit(num), this.reversable);
    }

    public final SequenceM<T> limitWhile(Predicate<? super T> p) {
        return StreamUtils.sequenceM(StreamUtils.limitWhile(this.stream, p), this.reversable);
    }

    public final SequenceM<T> limitUntil(Predicate<? super T> p) {
        return StreamUtils.sequenceM(StreamUtils.limitUntil(this.stream, p), this.reversable);
    }

    public final SequenceM<T> parallel() {
        return this;
    }

    public final boolean allMatch(Predicate<? super T> c) {
        return this.stream.allMatch(c);
    }

    public final boolean anyMatch(Predicate<? super T> c) {
        return this.stream.anyMatch(c);
    }

    public boolean xMatch(int num, Predicate<? super T> c) {
        return (Long)this.stream.filter(t -> c.test(t)).collect(Collectors.counting()) == (long)num;
    }

    public final boolean noneMatch(Predicate<? super T> c) {
        return this.stream.allMatch(c.negate());
    }

    public final String join() {
        return StreamUtils.join(this.stream, "");
    }

    public final String join(String sep) {
        return StreamUtils.join(this.stream, sep);
    }

    public final String join(String sep, String start, String end) {
        return StreamUtils.join(this.stream, sep, start, end);
    }

    public final <U extends Comparable<U>> Optional<T> minBy(Function<T, U> function) {
        return StreamUtils.minBy(this.stream, function);
    }

    public final Optional<T> min(Comparator<? super T> comparator) {
        return StreamUtils.min(this.stream, comparator);
    }

    public final <C extends Comparable<C>> Optional<T> maxBy(Function<T, C> f) {
        return StreamUtils.maxBy(this.stream, f);
    }

    public final Optional<T> max(Comparator<? super T> comparator) {
        return StreamUtils.max(this.stream, comparator);
    }

    public final HeadAndTail<T> headAndTail() {
        return StreamUtils.headAndTail(this.stream);
    }

    public final Optional<HeadAndTail<T>> headAndTailOptional() {
        return StreamUtils.headAndTailOptional(this.stream);
    }

    public final Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    public final Optional<T> findAny() {
        return this.stream.findAny();
    }

    public final <R> R mapReduce(Monoid<R> reducer) {
        return (R)reducer.mapReduce(this.stream);
    }

    public final <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return (R)reducer.reduce((Stream)this.stream.map(mapper));
    }

    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        return (R)this.stream.collect(collector);
    }

    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return (R)this.stream.collect(supplier, accumulator, combiner);
    }

    public final List collect(Stream<Collector> collectors) {
        return StreamUtils.collect(this.stream, collectors);
    }

    public <R> List<R> collectIterable(Iterable<Collector> collectors) {
        return StreamUtils.collect(this.stream, collectors);
    }

    public final T reduce(Monoid<T> reducer) {
        return (T)reducer.reduce(this.stream);
    }

    public final Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream.reduce(accumulator);
    }

    public final T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)this.stream.reduce(identity, accumulator);
    }

    public final <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return (U)this.stream.reduce(identity, accumulator, combiner);
    }

    public final List<T> reduce(Stream<? extends Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream, reducers);
    }

    public final List<T> reduce(Iterable<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream, reducers);
    }

    public final T foldLeft(Monoid<T> reducer) {
        return this.reduce(reducer);
    }

    public final T foldLeft(T identity, BinaryOperator<T> accumulator) {
        return (T)this.stream.reduce(identity, accumulator);
    }

    public final <T> T foldLeftMapToType(Monoid<T> reducer) {
        return (T)reducer.mapReduce(this.stream);
    }

    public final T foldRight(Monoid<T> reducer) {
        return (T)reducer.reduce(this.reverse());
    }

    public final <U> U foldRight(U seed, BiFunction<? super T, U, U> function) {
        return (U)this.stream.foldRight(seed, function);
    }

    public final <T> T foldRightMapToType(Monoid<T> reducer) {
        return (T)reducer.mapReduce(this.reverse());
    }

    public final Streamable<T> toStreamable() {
        return AsStreamable.fromStream(this.stream());
    }

    public final Set<T> toSet() {
        return (Set)this.stream.collect(Collectors.toSet());
    }

    public final List<T> toList() {
        return (List)this.stream.collect(Collectors.toList());
    }

    public final <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.stream.collect(Collectors.toCollection(collectionFactory)));
    }

    public final <T> Stream<T> toStream() {
        return this.stream;
    }

    public final Stream<T> stream() {
        return this.stream;
    }

    public final boolean startsWith(Iterable<T> iterable) {
        return StreamUtils.startsWith(this.stream, iterable);
    }

    public final boolean startsWith(Iterator<T> iterator) {
        return StreamUtils.startsWith(this.stream, iterator);
    }

    public AnyM<T> anyM() {
        return AsGenericMonad.fromStream(this.stream).anyM();
    }

    public final <R> SequenceM<R> map(Function<? super T, ? extends R> fn) {
        return new SequenceMImpl<T>(this.stream.map(fn));
    }

    public final SequenceM<T> peek(Consumer<? super T> c) {
        return new SequenceMImpl<T>(this.stream.peek(c));
    }

    public final <R> SequenceM<R> flatMap(Function<? super T, ? extends Stream<? extends R>> fn) {
        return StreamUtils.sequenceM(this.stream.flatMap(fn), this.reversable);
    }

    public final <R> SequenceM<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapAnyM(this.stream, fn), this.reversable);
    }

    public final <R> SequenceM<R> flatMapCollection(Function<? super T, Collection<? extends R>> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapCollection(this.stream, fn), Optional.empty());
    }

    public final <R> SequenceM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapStream(this.stream, fn), this.reversable);
    }

    public final <R> SequenceM<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapOptional(this.stream, fn), this.reversable);
    }

    public final <R> SequenceM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapCompletableFuture(this.stream, fn), this.reversable);
    }

    public final SequenceM<Character> flatMapCharSequence(Function<? super T, CharSequence> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapCharSequence(this.stream, fn), this.reversable);
    }

    public final SequenceM<String> flatMapFile(Function<? super T, File> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapFile(this.stream, fn), this.reversable);
    }

    public final SequenceM<String> flatMapURL(Function<? super T, URL> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapURL(this.stream, fn), this.reversable);
    }

    public final SequenceM<String> flatMapBufferedReader(Function<? super T, BufferedReader> fn) {
        return StreamUtils.sequenceM(StreamUtils.flatMapBufferedReader(this.stream, fn), this.reversable);
    }

    public final SequenceM<T> filter(Predicate<? super T> fn) {
        return StreamUtils.sequenceM(this.stream.filter(fn), this.reversable);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream.spliterator();
    }

    public boolean isParallel() {
        return this.stream.isParallel();
    }

    public SequenceM<T> sequential() {
        return StreamUtils.sequenceM(this.stream.sequential(), this.reversable);
    }

    public SequenceM<T> unordered() {
        return StreamUtils.sequenceM(this.stream.unordered(), this.reversable);
    }

    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.stream.mapToInt(mapper);
    }

    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.stream.mapToLong(mapper);
    }

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.stream.mapToDouble(mapper);
    }

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.stream.flatMapToInt(mapper);
    }

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.stream.flatMapToLong(mapper);
    }

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.stream.flatMapToDouble(mapper);
    }

    public void forEachOrdered(Consumer<? super T> action) {
        this.stream.forEachOrdered(action);
    }

    public Object[] toArray() {
        return this.stream.toArray();
    }

    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream.toArray(generator);
    }

    public long count() {
        return this.stream.count();
    }

    public SequenceM<T> intersperse(T value) {
        return StreamUtils.sequenceM(this.stream.flatMap(t -> Stream.of(value, t)).skip(1L), this.reversable);
    }

    public <U> SequenceM<U> ofType(Class<U> type) {
        return StreamUtils.sequenceM(StreamUtils.ofType(this.stream, type), this.reversable);
    }

    public <U> SequenceM<U> cast(Class<U> type) {
        return StreamUtils.sequenceM(StreamUtils.cast(this.stream, type), this.reversable);
    }

    public Collection<T> toLazyCollection() {
        return StreamUtils.toLazyCollection(this.stream);
    }

    public Collection<T> toConcurrentLazyCollection() {
        return StreamUtils.toConcurrentLazyCollection(this.stream);
    }

    public Streamable<T> toLazyStreamable() {
        return StreamUtils.toLazyStreamable(this.stream);
    }

    public Streamable<T> toConcurrentLazyStreamable() {
        return StreamUtils.toConcurrentLazyStreamable(this.stream);
    }

    public SequenceM<T> reverse() {
        if (this.reversable.isPresent()) {
            this.reversable.ifPresent(r -> r.invert());
            return this;
        }
        return StreamUtils.sequenceM(StreamUtils.reverse(this.stream), this.reversable);
    }

    public SequenceM<T> onClose(Runnable closeHandler) {
        return this;
    }

    public void close() {
    }

    public SequenceM<T> shuffle() {
        return StreamUtils.sequenceM(StreamUtils.shuffle(this.stream).stream(), this.reversable);
    }

    public SequenceM<T> appendStream(Stream<T> stream) {
        return StreamUtils.sequenceM(StreamUtils.appendStream(this.stream, stream), Optional.empty());
    }

    public SequenceM<T> prependStream(Stream<T> stream) {
        return StreamUtils.sequenceM(StreamUtils.prependStream(this.stream, stream), Optional.empty());
    }

    public SequenceM<T> append(T ... values) {
        return StreamUtils.sequenceM(StreamUtils.append(this.stream, values), Optional.empty());
    }

    public SequenceM<T> prepend(T ... values) {
        return StreamUtils.sequenceM(StreamUtils.prepend(this.stream, values), Optional.empty());
    }

    public SequenceM<T> insertAt(int pos, T ... values) {
        return StreamUtils.sequenceM(StreamUtils.insertAt(this.stream, pos, values), Optional.empty());
    }

    public SequenceM<T> deleteBetween(int start, int end) {
        return StreamUtils.sequenceM(StreamUtils.deleteBetween(this.stream, start, end), Optional.empty());
    }

    public SequenceM<T> insertStreamAt(int pos, Stream<T> stream) {
        return StreamUtils.sequenceM(StreamUtils.insertStreamAt(this.stream, pos, stream), Optional.empty());
    }

    public FutureOperations<T> futureOperations(Executor exec) {
        return StreamUtils.futureOperations(this.stream, exec);
    }

    public boolean endsWith(Iterable<T> iterable) {
        return StreamUtils.endsWith(this.stream, iterable);
    }

    public HotStream<T> hotStream(Executor e) {
        return StreamUtils.hotStream(this.stream, e);
    }

    public T firstValue() {
        return StreamUtils.firstValue(this.stream);
    }

    public void subscribe(Subscriber<? super T> s) {
        ((ReactiveStreamsPublisher)ReactiveStreamsLoader.publisher.get()).subscribe(this.stream, s);
    }

    public <U> SequenceM<Tuple2<T, U>> zip(Seq<U> other) {
        return StreamUtils.sequenceM(this.stream.zip(other), this.reversable);
    }

    public <S, R> SequenceM<R> zipAnyM(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.sequenceM(StreamUtils.zipAnyM(this.stream, second, zipper), this.reversable);
    }

    public <U> SequenceM<Tuple2<T, U>> crossJoin(Stream<U> other) {
        return StreamUtils.sequenceM(this.stream.crossJoin(other), this.reversable);
    }

    public <U> SequenceM<Tuple2<T, U>> innerJoin(Stream<U> other, BiPredicate<T, U> predicate) {
        return StreamUtils.sequenceM(this.stream.innerJoin(other, predicate), this.reversable);
    }

    public <U> SequenceM<Tuple2<T, U>> leftOuterJoin(Stream<U> other, BiPredicate<T, U> predicate) {
        return StreamUtils.sequenceM(this.stream.leftOuterJoin(other, predicate), this.reversable);
    }

    public <U> SequenceM<Tuple2<T, U>> rightOuterJoin(Stream<U> other, BiPredicate<T, U> predicate) {
        return StreamUtils.sequenceM(this.stream.rightOuterJoin(other, predicate), this.reversable);
    }

    public SequenceM<T> onEmpty(T value) {
        return StreamUtils.sequenceM(this.stream.onEmpty(value), Optional.empty());
    }

    public SequenceM<T> onEmptyGet(Supplier<T> supplier) {
        return StreamUtils.sequenceM(this.stream.onEmptyGet(supplier), Optional.empty());
    }

    public <X extends Throwable> SequenceM<T> onEmptyThrow(Supplier<X> supplier) {
        return StreamUtils.sequenceM(this.stream.onEmptyThrow(supplier), Optional.empty());
    }

    public SequenceM<T> concat(Stream<T> other) {
        return StreamUtils.sequenceM(this.stream.concat(other), Optional.empty());
    }

    public SequenceM<T> concat(T other) {
        return StreamUtils.sequenceM(this.stream.concat(other), Optional.empty());
    }

    public SequenceM<T> concat(T ... other) {
        return StreamUtils.sequenceM(this.stream.concat((Object[])other), Optional.empty());
    }

    public <U> SequenceM<T> distinct(Function<? super T, ? extends U> keyExtractor) {
        return StreamUtils.sequenceM(this.stream.distinct(keyExtractor), this.reversable);
    }

    public <U, R> SequenceM<R> zip(Seq<U> other, BiFunction<T, U, R> zipper) {
        return StreamUtils.sequenceM(this.stream.zip(other, zipper), Optional.empty());
    }

    public SequenceM<T> shuffle(Random random) {
        return StreamUtils.sequenceM(this.stream.shuffle(random), this.reversable);
    }

    public SequenceM<T> slice(long from, long to) {
        return StreamUtils.sequenceM(this.stream.slice(from, to), this.reversable);
    }

    public <U extends Comparable<? super U>> SequenceM<T> sorted(Function<? super T, ? extends U> function) {
        return StreamUtils.sequenceM(this.stream.sorted(function), this.reversable);
    }

    public <U> SequenceM<Tuple2<T, U>> zipStream(Stream<U> other) {
        return StreamUtils.sequenceM(StreamUtils.zipStream(this.stream, other, Tuple::tuple), Optional.empty());
    }

    public SequenceM<T> xPer(int x, long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.xPer(this.stream, x, time, t), this.reversable);
    }

    public SequenceM<T> onePer(long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.onePer(this.stream, time, t), this.reversable);
    }

    public SequenceM<T> debounce(long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.debounce(this.stream, time, t), this.reversable);
    }

    public SequenceM<List<T>> batchBySizeAndTime(int size, long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.batchBySizeAndTime(this.stream, size, time, t), this.reversable);
    }

    public SequenceM<List<T>> batchByTime(long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.batchByTime(this.stream, time, t), this.reversable);
    }

    public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return (T)this.reverse().foldLeft(identity, accumulator);
    }

    public boolean endsWith(Stream<T> iterable) {
        return StreamUtils.endsWith(this.stream, () -> iterable.iterator());
    }

    public SequenceM<T> skip(long time, TimeUnit unit) {
        return StreamUtils.sequenceM(StreamUtils.skip(this.stream, time, unit), this.reversable);
    }

    public SequenceM<T> limit(long time, TimeUnit unit) {
        return StreamUtils.sequenceM(StreamUtils.limit(this.stream, time, unit), this.reversable);
    }

    public SequenceM<List<T>> batchBySize(int size) {
        return StreamUtils.sequenceM(StreamUtils.batchBySize(this.stream, size), this.reversable);
    }

    public SequenceM<T> fixedDelay(long l, TimeUnit unit) {
        return StreamUtils.sequenceM(StreamUtils.fixedDelay(this.stream, l, unit), this.reversable);
    }

    public SequenceM<T> jitter(long l) {
        return StreamUtils.sequenceM(StreamUtils.jitter(this.stream, l), this.reversable);
    }

    public SequenceM<Streamable<T>> windowBySizeAndTime(int size, long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.windowBySizeAndTime(this.stream, size, time, t), this.reversable);
    }

    public SequenceM<Streamable<T>> windowWhile(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.windowWhile(this.stream, predicate), this.reversable);
    }

    public SequenceM<Streamable<T>> windowUntil(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.windowWhile(this.stream, predicate.negate()), this.reversable);
    }

    public SequenceM<Streamable<T>> windowStatefullyWhile(BiPredicate<Streamable<? super T>, ? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.windowStatefullyWhile(this.stream, predicate), this.reversable);
    }

    public SequenceM<Streamable<T>> windowByTime(long time, TimeUnit t) {
        return StreamUtils.sequenceM(StreamUtils.windowByTime(this.stream, time, t), this.reversable);
    }

    public SequenceM<List<T>> batchUntil(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.batchUntil(this.stream, predicate), this.reversable);
    }

    public SequenceM<List<T>> batchWhile(Predicate<? super T> predicate) {
        return StreamUtils.sequenceM(StreamUtils.batchWhile(this.stream, predicate), this.reversable);
    }

    public List collectStream(Stream<Collector> collectors) {
        return StreamUtils.collect(this.stream, collectors);
    }

    public <C extends Collection<? super T>> SequenceM<C> batchWhile(Predicate<? super T> predicate, Supplier<C> factory) {
        return StreamUtils.sequenceM(StreamUtils.batchWhile(this.stream, predicate, factory), this.reversable);
    }

    public <C extends Collection<? super T>> SequenceM<C> batchUntil(Predicate<? super T> predicate, Supplier<C> factory) {
        return StreamUtils.sequenceM(StreamUtils.batchWhile(this.stream, predicate.negate(), factory), this.reversable);
    }

    public <C extends Collection<? super T>> SequenceM<C> batchBySizeAndTime(int size, long time, TimeUnit unit, Supplier<C> factory) {
        return StreamUtils.sequenceM(StreamUtils.batchBySizeAndTime(this.stream, size, time, unit, factory), this.reversable);
    }

    public <C extends Collection<T>> SequenceM<C> batchByTime(long time, TimeUnit unit, Supplier<C> factory) {
        return StreamUtils.sequenceM(StreamUtils.batchByTime(this.stream, time, unit, factory), this.reversable);
    }

    public <C extends Collection<T>> SequenceM<C> batchBySize(int size, Supplier<C> factory) {
        return StreamUtils.sequenceM(StreamUtils.batchBySize(this.stream, size, factory), this.reversable);
    }

    public SequenceM<T> skipLast(int num) {
        return StreamUtils.sequenceM(StreamUtils.skipLast(this.stream, num), this.reversable);
    }

    public SequenceM<T> limitLast(int num) {
        return StreamUtils.sequenceM(StreamUtils.limitLast(this.stream, num), this.reversable);
    }

    public SequenceM<T> recover(Function<Throwable, ? extends T> fn) {
        return StreamUtils.sequenceM(StreamUtils.recover(this.stream, fn), this.reversable);
    }

    public <EX extends Throwable> SequenceM<T> recover(Class<EX> exceptionClass, Function<EX, ? extends T> fn) {
        return StreamUtils.sequenceM(StreamUtils.recover(this.stream, exceptionClass, fn), this.reversable);
    }

    public <R1, R2, R> SequenceM<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (SequenceM)Do.add((SequenceM)this).withBaseStream(u -> (BaseStream)stream1.apply(u)).withBaseStream(u -> r1 -> (BaseStream)((Function)stream2.apply(u)).apply(r1)).yield(yieldingFunction).unwrap();
    }

    public <R1, R2, R> SequenceM<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (SequenceM)Do.add((SequenceM)this).withBaseStream(u -> (BaseStream)stream1.apply(u)).withBaseStream(u -> r1 -> (BaseStream)((Function)stream2.apply(u)).apply(r1)).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    public <R1, R> SequenceM<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (SequenceM)Do.add((SequenceM)this).withBaseStream(u -> (BaseStream)stream1.apply(u)).yield(yieldingFunction).unwrap();
    }

    public <R1, R> SequenceM<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, Boolean>> filterFunction, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (SequenceM)Do.add((SequenceM)this).withBaseStream(u -> (BaseStream)stream1.apply(u)).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    public <X extends Throwable> Subscription forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return StreamUtils.forEachX(this, numberOfElements, consumer);
    }

    public <X extends Throwable> Subscription forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return StreamUtils.forEachXWithError(this, numberOfElements, consumer, consumerError);
    }

    public <X extends Throwable> Subscription forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return StreamUtils.forEachXEvents(this, numberOfElements, consumer, consumerError, onComplete);
    }

    public <X extends Throwable> void forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        StreamUtils.forEachWithError(this, consumerElement, consumerError);
    }

    public <X extends Throwable> void forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        StreamUtils.forEachEvent(this, consumerElement, consumerError, onComplete);
    }
}

